/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.util.Properties;
import se.ericsson.cello.emas.sm.elements.FanElementCreator;
import se.ericsson.cello.emas.sm.elements.RPUSlotElementCreator;
import se.ericsson.cello.emas.sm.services.FanNameFactory;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.AttributeBuffer;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

public class FanElement
extends EmasViewElement {
    private MOProxy fan;
    private MOProxy subrack;
    private String fanName;
    private String fanNumber;
    private String cabinetPos;
    private String subrackPos;
    private String userLabel;

    public FanElement(MOComposite aMoc, Properties aProperties, FanElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, (EmasViewElementCreator)aCreator);
        this.fan = aMoc.getMO("Fan");
        this.subrack = this.fan.getParent();
        this.refreshData();
    }

    public FanElement(MOComposite aMoc, Properties aProperties, RPUSlotElementCreator aCreator) throws CSException {
        super(aMoc, aProperties, (EmasViewElementCreator)aCreator);
        this.fan = aMoc.getMO("Fan");
        this.subrack = this.fan.getParent();
        this.refreshData();
    }

    public String getName() {
        return this.fanName;
    }

    public Object getAttributeValue(String aName) {
        String value = null;
        if (aName.equals("ATTR_CABINET")) {
            value = this.cabinetPos;
        } else if (aName.equals("ATTR_SUBRACK")) {
            value = this.subrackPos;
        } else if (aName.equals("ATTR_FAN")) {
            value = this.fanNumber;
        } else if (aName.equals("ATTR_TYPE")) {
            value = this.translateKey("FAN");
        } else if (aName.equals("ATTR_USERLABEL")) {
            value = this.userLabel;
        }
        return value;
    }

    private void refreshData() throws CSException {
        Object moList = null;
        String[] attributes = new String[]{"cabinetPosition", "subrackPosition"};
        try {
            Object[] values = this.subrack.getAttributes(attributes, null);
            this.fanNumber = this.fan.getId();
            AttributeBuffer buffer = new AttributeBuffer(attributes, values);
            this.cabinetPos = (String)buffer.getAttribute("cabinetPosition");
            this.subrackPos = (String)buffer.getAttribute("subrackPosition");
            this.fanName = FanNameFactory.getFanName(this.fan);
            this.userLabel = (String)this.fan.getAttribute("userLabel");
        }
        catch (CSException e) {
            Log.logError((String)"Error determining slot name", (Throwable)e);
            throw e;
        }
    }

    public void refresh() {
        try {
            this.refreshData();
        }
        catch (CSException e) {
            Log.logError((String)"refresh failed", (Throwable)e);
        }
    }
}

