/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emas.sm.elements;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.cello.emas.sm.elements.EmasElementCreator;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElement;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class SwAllocationSlotsElementCreator
extends EmasElementCreator {
    private MOProxy swAllocation = null;
    private Hashtable childElements;
    private Properties properties;
    private Hashtable moProperties = new Hashtable();

    public SwAllocationSlotsElementCreator(Properties p) {
        super(p);
        this.createSlotElements(p);
    }

    public void dispose() {
        if (this.swAllocation != null) {
            this.swAllocation.removeMOListener((MOProxy.MOListener)this);
        }
    }

    public AbstractViewElement[] createInstances(AbstractViewElement parent) {
        MOProxy[] swAllocationSlotList = null;
        Vector<EmasViewElementInterface> newElements = new Vector<EmasViewElementInterface>();
        EmasViewElementInterface parentElement = (EmasViewElementInterface)parent;
        this.swAllocation = ((EmasViewElement)parentElement).getMO("SwAllocation");
        String dn = this.swAllocation.getDN();
        Log.trace((String)("parent LDN=" + this.swAllocation.getDN()));
        if (this.parentElements.containsKey(dn)) {
            Log.trace((String)"already subscribed");
        } else {
            this.parentElements.put(dn, parentElement);
            this.swAllocation.addMOListener((MOProxy.MOListener)this);
            Log.trace((String)("addMOListener to LDN=" + this.swAllocation.getDN()));
        }
        try {
            swAllocationSlotList = (MOProxy[])this.swAllocation.getAttribute("slotList", null);
        }
        catch (CSException e) {
            Log.logError((String)(((Object)((Object)this)).getClass().getName() + "::createInstances failed"), (Throwable)e);
            return newElements.toArray(new AbstractViewElement[0]);
        }
        for (int index = 0; index < swAllocationSlotList.length; ++index) {
            EmasViewElementInterface newElement = null;
            try {
                newElement = this.createSwAllocationSlotsElement(swAllocationSlotList[index]);
                if (newElement == null) continue;
                newElements.add(newElement);
                this.addElement(newElement);
                continue;
            }
            catch (Exception e) {
                Log.logError((String)("SwAllocationSlots Element " + this.getClassName() + " could not be created"), (Throwable)e);
            }
        }
        return newElements.toArray(new AbstractViewElement[0]);
    }

    public void attributesChanged(MOProxy anMO, NameValue[] nameValue) {
        try {
            for (int i = 0; i < nameValue.length; ++i) {
                if (!nameValue[i].name.equals("slotList")) continue;
                AbstractViewElement swa = (AbstractViewElement)this.parentElements.get(anMO.getDN());
                MOProxy[] swAllocationSlotList = Array.getLength(nameValue[i].value) > 0 ? (MOProxy[])nameValue[i].value : new MOProxy[]{};
                this.updateSwAllocation(swa, swAllocationSlotList);
            }
        }
        catch (Exception e) {
            Log.logError((String)"update failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSwAllocation(AbstractViewElement swa, MOProxy[] swAllocationSlotList) {
        if (swAllocationSlotList != null) {
            AbstractViewElement abstractViewElement = swa;
            synchronized (abstractViewElement) {
                TopologyModel topologyModel = swa.getModel();
                synchronized (topologyModel) {
                    AbstractViewElement[] children = swa.getChildren();
                    Vector<MOProxy> swAllocationSlots = new Vector<MOProxy>(Arrays.asList(swAllocationSlotList));
                    for (int i = 0; i < children.length; ++i) {
                        EmasViewElement child = (EmasViewElement)children[i];
                        if (child.getLastMO() == null) continue;
                        if (swAllocationSlots.contains(child.getLastMO())) {
                            swAllocationSlots.remove(child.getLastMO());
                            continue;
                        }
                        if ("Repertoire".equals(child.getLastMO().getType())) continue;
                        swa.removeChild((AbstractViewElement)child);
                        this.deleteElement((EmasViewElementInterface)child);
                    }
                    MOProxy[] newSwAllocationSlots = swAllocationSlots.toArray(new MOProxy[0]);
                    for (int i = 0; i < newSwAllocationSlots.length; ++i) {
                        MOProxy swAllocationSlot = newSwAllocationSlots[i];
                        EmasViewElementInterface newElement = this.createSwAllocationSlotsElement(swAllocationSlot);
                        swa.addChild((AbstractViewElement)newElement);
                        this.addElement(newElement);
                    }
                }
            }
        }
    }

    private EmasViewElementInterface createSwAllocationSlotsElement(MOProxy swAllocationSlot) {
        EmasViewElementInterface newElement = null;
        try {
            MOComposite moc = new MOComposite();
            moc.add(swAllocationSlot);
            this.childElements = new Hashtable();
            MOProxy childElement = swAllocationSlot;
            String key = swAllocationSlot.getDN();
            this.childElements.put(key, childElement);
            Properties p = (Properties)this.moProperties.get(swAllocationSlot.getType());
            Object[] args = new Object[]{moc, p, this};
            Class<?> c = Class.forName(this.getClassName());
            Vector v = new Vector();
            for (int i = 0; i < args.length; ++i) {
                v.add(args[i].getClass());
            }
            Constructor<?> constructor = c.getConstructor(v.toArray(new Class[0]));
            newElement = (EmasViewElementInterface)constructor.newInstance(args);
        }
        catch (Exception e) {
            Log.logError((String)("SwAllocationSlots Element " + this.getClassName() + " could not be created"), (Throwable)e);
        }
        return newElement;
    }

    private void createSlotElements(Properties properties) {
        String elements = properties.getProperty("elements");
        if (elements == null || elements.equals("") || elements.equalsIgnoreCase("null")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(elements, ",");
        while (st.hasMoreTokens()) {
            String mos;
            String tag = st.nextToken();
            String key = "element." + tag;
            String propFileName = properties.getProperty(key + ".properties");
            Properties pp = new Properties();
            try {
                InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(propFileName);
                pp.load(new BufferedInputStream(stream));
            }
            catch (Exception e) {
                Log.logError((String)("Cannot load properties from " + propFileName), (Throwable)e);
            }
            if ((mos = properties.getProperty(key + ".mos")) == null) continue;
            StringTokenizer st2 = new StringTokenizer(mos, ",");
            while (st2.hasMoreTokens()) {
                this.moProperties.put(st2.nextToken(), pp);
            }
        }
    }
}

