/*
 * Decompiled with CFR 0.152.
 */
package enea.ose.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SignalOutputStream
extends FilterOutputStream {
    public static final boolean BIG_ENDIAN = true;
    public static final boolean LITTLE_ENDIAN = false;
    private static boolean hostEndian;
    public static int alignment64bit;
    protected int writepos = 4;
    protected int signalAlignment;
    protected boolean bigEndian;

    public SignalOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.bigEndian = hostEndian;
    }

    public SignalOutputStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.bigEndian = bl;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.writepos;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.writepos += n2;
    }

    public void writeS8(byte by) throws IOException {
        this.out.write(by);
        ++this.writepos;
    }

    public void writeU8(int n) throws IOException {
        this.out.write(n);
        ++this.writepos;
    }

    public void writeS16(short s) throws IOException {
        this.align(2);
        if (this.bigEndian) {
            this.out.write(s >>> 8 & 0xFF);
            this.out.write(s >>> 0 & 0xFF);
        } else {
            this.out.write(s >>> 0 & 0xFF);
            this.out.write(s >>> 8 & 0xFF);
        }
        this.writepos += 2;
        if (this.signalAlignment < 2) {
            this.signalAlignment = 2;
        }
    }

    public void writeU16(int n) throws IOException {
        this.writeS16((short)n);
    }

    public void writeS32(int n) throws IOException {
        this.align(4);
        if (this.bigEndian) {
            this.out.write(n >>> 24 & 0xFF);
            this.out.write(n >>> 16 & 0xFF);
            this.out.write(n >>> 8 & 0xFF);
            this.out.write(n >>> 0 & 0xFF);
        } else {
            this.out.write(n >>> 0 & 0xFF);
            this.out.write(n >>> 8 & 0xFF);
            this.out.write(n >>> 16 & 0xFF);
            this.out.write(n >>> 24 & 0xFF);
        }
        this.writepos += 4;
        if (this.signalAlignment < 4) {
            this.signalAlignment = 4;
        }
    }

    public void writeU32(long l) throws IOException {
        this.writeS32((int)l);
    }

    public void writeS64(long l) throws IOException {
        this.align(alignment64bit);
        if (this.bigEndian) {
            this.out.write((int)(l >>> 56 & 0xFFL));
            this.out.write((int)(l >>> 48 & 0xFFL));
            this.out.write((int)(l >>> 40 & 0xFFL));
            this.out.write((int)(l >>> 32 & 0xFFL));
            this.out.write((int)(l >>> 24 & 0xFFL));
            this.out.write((int)(l >>> 16 & 0xFFL));
            this.out.write((int)(l >>> 8 & 0xFFL));
            this.out.write((int)(l >>> 0 & 0xFFL));
        } else {
            this.out.write((int)(l >>> 0 & 0xFFL));
            this.out.write((int)(l >>> 8 & 0xFFL));
            this.out.write((int)(l >>> 16 & 0xFFL));
            this.out.write((int)(l >>> 24 & 0xFFL));
            this.out.write((int)(l >>> 32 & 0xFFL));
            this.out.write((int)(l >>> 40 & 0xFFL));
            this.out.write((int)(l >>> 48 & 0xFFL));
            this.out.write((int)(l >>> 56 & 0xFFL));
        }
        this.writepos += 8;
        if (this.signalAlignment < 4) {
            this.signalAlignment = 4;
        }
    }

    public void writeS8Array(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.writepos += byArray.length;
    }

    public void writeU8Array(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.writeU8(nArray[i]);
        }
    }

    public void writeS16Array(short[] sArray) throws IOException {
        for (int i = 0; i < sArray.length; ++i) {
            this.writeS16(sArray[i]);
        }
    }

    public void writeU16Array(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.writeU16(nArray[i]);
        }
    }

    public void writeS32Array(int[] nArray) throws IOException {
        for (int i = 0; i < nArray.length; ++i) {
            this.writeS32(nArray[i]);
        }
    }

    public void writeU32Array(long[] lArray) throws IOException {
        for (int i = 0; i < lArray.length; ++i) {
            this.writeU32(lArray[i]);
        }
    }

    public void writeS64Array(long[] lArray) throws IOException {
        for (int i = 0; i < lArray.length; ++i) {
            this.writeS64(lArray[i]);
        }
    }

    public void writeOSBOOLEAN(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        ++this.writepos;
    }

    public void writeString(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)string.charAt(i));
        }
        this.out.write(0);
        this.writepos += n + 1;
    }

    public void writeString(String string, int n) throws IOException, IllegalArgumentException {
        int n2 = n - string.length() - 1;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.writeString(string);
        for (int i = 0; i < n2; ++i) {
            this.out.write(0);
        }
        this.writepos += n2;
    }

    public void align(int n) throws IOException {
        if (n <= 0 || (n & 1) != 0) {
            return;
        }
        int n2 = (n - this.writepos & n - 1) % n;
        for (int i = 0; i < n2; ++i) {
            this.out.write(0);
            ++this.writepos;
        }
    }

    public void flush() throws IOException {
        this.align(this.signalAlignment);
        this.out.flush();
    }

    public int size() {
        return this.writepos;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    static {
        String string = System.getProperty("java.vm.name").equalsIgnoreCase("j9") ? System.getProperty("com.ibm.cpu.endian", "big") : System.getProperty("sun.cpu.endian", "big");
        hostEndian = string.equals("big");
        String string2 = System.getProperty("alignment_64bit", "8");
        alignment64bit = string2.equals("8") ? 8 : 4;
    }
}

