/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pri;

import enea.ose.system.AttachSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.Signal;
import se.ericsson.cello.pri.CelloPriGetStringSysParamRsp;
import se.ericsson.cello.pri.CelloPriInitiateServiceRsp;
import se.ericsson.cello.pri.GetSysParamReq;
import se.ericsson.cello.pri.LongSysParamRsp;
import se.ericsson.cello.pri.LongSystemParameter;
import se.ericsson.cello.pri.OsaPriInitiateServiceReq;
import se.ericsson.cello.pri.PriJavaProxy;
import se.ericsson.cello.pri.PriProcessNotFoundException;
import se.ericsson.cello.pri.StringSystemParameter;
import se.ericsson.cello.pri.SystemParameterNotFoundException;
import se.ericsson.cello.pri.WrongSystemParameterTypeException;
import se.ericsson.cello.support.sigutil.OseNameServer;
import se.ericsson.cello.support.sigutil.SignalHelper;

public class PriJavaProxyImpl
implements PriJavaProxy {
    protected static final String CELLO_PRI_SERVER_NAME = "CelloPiuInfoService";
    private OseProcess factoryProcess = null;
    private OseProcess serviceProcess = null;
    private static int MAX_NUMBER_OF_RETRIES = 2;
    static /* synthetic */ Class class$se$ericsson$cello$pri$CelloPriInitiateServiceRsp;

    protected PriJavaProxyImpl() throws PriProcessNotFoundException {
        for (int i = 1; i <= MAX_NUMBER_OF_RETRIES; ++i) {
            this.factoryProcess = OseNameServer.lookup(CELLO_PRI_SERVER_NAME);
            if (this.factoryProcess == null) {
                throw new PriProcessNotFoundException("PRI Server not found");
            }
            OsaPriInitiateServiceReq osaPriInitiateServiceReq = new OsaPriInitiateServiceReq();
            Signal signal = SignalHelper.sendAndReceiveAttachedClean(this.factoryProcess, (Signal)osaPriInitiateServiceReq, class$se$ericsson$cello$pri$CelloPriInitiateServiceRsp == null ? PriJavaProxyImpl.class$("se.ericsson.cello.pri.CelloPriInitiateServiceRsp") : class$se$ericsson$cello$pri$CelloPriInitiateServiceRsp, 30000);
            if (signal instanceof AttachSignal) {
                if (i != MAX_NUMBER_OF_RETRIES) continue;
                throw new PriProcessNotFoundException("Retries Attempted, PRI Service not responding");
            }
            if (signal == null) {
                throw new PriProcessNotFoundException("PRI Service not responding");
            }
            signal = (CelloPriInitiateServiceRsp)signal;
            this.serviceProcess = signal.getSender();
            break;
        }
    }

    private LongSystemParameter[] getLongSystemParameters_(long[] lArray) throws WrongSystemParameterTypeException, SystemParameterNotFoundException {
        GetSysParamReq getSysParamReq = new GetSysParamReq(lArray);
        Class[] classArray = new Class[]{LongSysParamRsp.class, CelloPriGetStringSysParamRsp.class};
        Signal signal = SignalHelper.sendAndReceiveAttachedClean(this.serviceProcess, (Signal)getSysParamReq, classArray, 30000);
        if (signal == null || signal instanceof AttachSignal) {
            return null;
        }
        if (signal instanceof CelloPriGetStringSysParamRsp) {
            throw new WrongSystemParameterTypeException();
        }
        LongSysParamRsp longSysParamRsp = (LongSysParamRsp)signal;
        LongSystemParameter[] longSystemParameterArray = longSysParamRsp.getLongSysParams();
        for (int i = 0; i < longSystemParameterArray.length; ++i) {
            if (longSystemParameterArray[i].isValid()) continue;
            throw new SystemParameterNotFoundException();
        }
        return longSystemParameterArray;
    }

    public LongSystemParameter[] getLongSystemParameters(long[] lArray) throws SystemParameterNotFoundException, WrongSystemParameterTypeException {
        LongSystemParameter[] longSystemParameterArray = this.getLongSystemParameters_(lArray);
        if (longSystemParameterArray == null) {
            throw new SystemParameterNotFoundException();
        }
        return longSystemParameterArray;
    }

    public LongSystemParameter getLongSystemParameter(long l) throws SystemParameterNotFoundException, WrongSystemParameterTypeException {
        long[] lArray = new long[]{l};
        return this.getLongSystemParameters(lArray)[0];
    }

    private StringSystemParameter getStringSystemParameter_(long l) throws WrongSystemParameterTypeException, SystemParameterNotFoundException {
        long[] lArray = new long[]{l};
        GetSysParamReq getSysParamReq = new GetSysParamReq(lArray);
        Class[] classArray = new Class[]{LongSysParamRsp.class, CelloPriGetStringSysParamRsp.class};
        Signal signal = SignalHelper.sendAndReceiveAttachedClean(this.serviceProcess, (Signal)getSysParamReq, classArray, 30000);
        if (signal == null || signal instanceof AttachSignal) {
            return null;
        }
        if (signal instanceof LongSysParamRsp) {
            LongSysParamRsp longSysParamRsp = (LongSysParamRsp)signal;
            if (longSysParamRsp.getLongSysParams()[0].isValid()) {
                throw new WrongSystemParameterTypeException();
            }
            throw new SystemParameterNotFoundException();
        }
        CelloPriGetStringSysParamRsp celloPriGetStringSysParamRsp = (CelloPriGetStringSysParamRsp)signal;
        return celloPriGetStringSysParamRsp.getStringSysParam();
    }

    public StringSystemParameter getStringSystemParameter(long l) throws SystemParameterNotFoundException, WrongSystemParameterTypeException {
        StringSystemParameter stringSystemParameter = this.getStringSystemParameter_(l);
        if (stringSystemParameter == null) {
            throw new SystemParameterNotFoundException();
        }
        return stringSystemParameter;
    }
}

