/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.control;

import enea.ose.system.InSignal;
import enea.ose.system.OseProcess;
import enea.ose.system.SignalRegistry;
import enea.ose.system.ThisProcess;
import enea.ose.system.UnlinkedSignal;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import se.ericsson.cello.support.control.ClasspathIterator;
import se.ericsson.cello.support.control.ControlImpl;
import se.ericsson.cello.support.control.ControlImplCvm;
import se.ericsson.cello.support.control.ControlImplJ9ME;
import se.ericsson.cello.support.control.ControlImplJ9SE;
import se.ericsson.cello.support.control.OsaCheckJavaHeap;
import se.ericsson.cello.support.control.OsaDumpJavaHeap;
import se.ericsson.cello.support.control.OsaDumpJavaThreads;
import se.ericsson.cello.support.control.OsaJarRetrival;
import se.ericsson.cello.support.debug.JavaHeap;
import se.ericsson.cello.support.debug.MessageLog;

public class Control {
    public static final int OSE = 0;
    public static final int LINUX = 1;
    public static final int CVM = 0;
    public static final int J9 = 1;
    private static ControlImpl impl;
    private static int os;
    private static int vm;
    static /* synthetic */ Class class$se$ericsson$cello$support$control$OsaCheckJavaHeap;
    static /* synthetic */ Class class$se$ericsson$cello$support$control$OsaDumpJavaThreads;
    static /* synthetic */ Class class$se$ericsson$cello$support$control$OsaDumpJavaHeap;
    static /* synthetic */ Class class$se$ericsson$cello$support$control$OsaJarRetrival;

    public static int getOs() {
        return os;
    }

    public static int getVm() {
        return vm;
    }

    private void setupFileSystem(File file, String string) {
        String string2 = System.getProperty("java.home");
        int n = 2048;
        byte[] byArray = new byte[n];
        MessageLog.trace(5, this.getClass(), "Found " + file.getName() + ", version " + string);
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n2;
                File file2;
                if (!zipEntry.getName().startsWith("lib" + File.separator + "security") || zipEntry.isDirectory() || (file2 = new File(string2, zipEntry.getName())).exists() && file2.length() == zipEntry.getSize()) continue;
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    file3.mkdirs();
                }
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                while ((n2 = zipInputStream.read(byArray, 0, n)) > 0) {
                    bufferedOutputStream.write(byArray, 0, n2);
                    if (n2 > 0) continue;
                }
                bufferedOutputStream.close();
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            MessageLog.traceError(this.getClass(), exception.toString());
        }
    }

    void installMeFiles(ControlImpl controlImpl, String string, String string2) {
        boolean bl = false;
        ClasspathIterator classpathIterator = new ClasspathIterator(controlImpl.getClasspath());
        while (classpathIterator.hasNext() && !bl) {
            String string3 = (String)classpathIterator.next();
            try {
                File file = new File(new URI("file:" + string3));
                if (file.isDirectory()) continue;
                JarFile jarFile = new JarFile(file);
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    String string4;
                    Attributes attributes;
                    Attributes attributes2 = manifest.getAttributes(string);
                    if (attributes2 != null) {
                        MessageLog.info(this.getClass(), "Found java_support in separate section");
                        this.setupFileSystem(file, attributes2.getValue(string2));
                        bl = true;
                    }
                    if ((attributes = manifest.getMainAttributes()) != null && (string4 = attributes.getValue("Name")) != null && string4.equals(string)) {
                        MessageLog.info(this.getClass(), "Found java_support in main section");
                        this.setupFileSystem(file, attributes.getValue("Version"));
                        bl = true;
                    }
                }
                jarFile.close();
            }
            catch (IOException iOException) {
                MessageLog.info(this.getClass(), "Jar problem: " + iOException.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                MessageLog.info(this.getClass(), "Jar problem: " + uRISyntaxException.toString());
            }
        }
        if (!bl) {
            MessageLog.info(this.getClass(), "No correct manifest file found for java_support -security problems may follow! Please check configuration of jar files!");
        }
    }

    void start(String[] stringArray) {
        Thread thread = new Thread((Runnable)new Controller(), "Osa_control_thread");
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.start();
        try {
            Method method = null;
            Object[] objectArray = new Object[1];
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray[i + 1];
            }
            objectArray[0] = stringArray2;
            MessageLog.info(this.getClass(), "Starting main class:  " + stringArray[0]);
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Class<?> clazz = classLoader.loadClass(stringArray[0]);
            Class[] classArray = new Class[]{stringArray.getClass()};
            method = clazz.getDeclaredMethod("main", classArray);
            method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throwable.printStackTrace();
            MessageLog.traceError(this.getClass(), throwable.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println(throwable);
            MessageLog.traceError(this.getClass(), throwable.toString());
        }
        MessageLog.info(this.getClass(), "Returning from main class: " + stringArray[0]);
    }

    public static void main(String[] stringArray) {
        impl.setupEnvironment();
        impl.setupSecurity();
        impl.start(stringArray);
    }

    public String findJar(String string) throws IllegalStateException {
        int n;
        if (string.endsWith(".class")) {
            n = string.lastIndexOf(".class");
            string = string.substring(0, n);
        }
        if (string.indexOf(47) != -1 && (n = string.indexOf(46)) != -1) {
            string = string.substring(0, n);
        }
        string = string.replace('.', '/');
        string = string + ".class";
        ClasspathIterator classpathIterator = new ClasspathIterator(impl.getClasspath());
        while (classpathIterator.hasNext()) {
            String string2 = (String)classpathIterator.next();
            File file = new File(string2);
            if (file.isDirectory()) continue;
            try {
                JarFile jarFile = new JarFile(file);
                ZipEntry zipEntry = jarFile.getEntry(string);
                if (zipEntry == null) {
                    zipEntry = jarFile.getJarEntry(string);
                    if (zipEntry == null) continue;
                    return file.getName();
                }
                return file.getName();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "Java class not found";
    }

    private native void dumpJavaThreads(int var1, int var2);

    private native void dumpJavaHeap(int var1, int var2, int var3);

    private void sendMemorySignal(OseProcess oseProcess) {
        JavaHeap javaHeap = new JavaHeap();
        oseProcess.post(new OsaCheckJavaHeap((int)javaHeap.getSize(), (int)javaHeap.getUsed(), (int)javaHeap.getMaxUsed()));
    }

    static {
        if (System.getProperty("os.name").toLowerCase().indexOf("inux") >= 0) {
            impl = new ControlImplJ9SE();
            os = 1;
            vm = 1;
        } else {
            os = 0;
            if (System.getProperty("java.vm.vendor").startsWith("Sun")) {
                impl = new ControlImplCvm();
                vm = 0;
            } else {
                impl = new ControlImplJ9ME();
                vm = 1;
            }
        }
    }

    class Controller
    implements Runnable {
        Controller() {
        }

        public void run() {
            SignalRegistry signalRegistry = new SignalRegistry();
            signalRegistry.add(class$se$ericsson$cello$support$control$OsaCheckJavaHeap == null ? (class$se$ericsson$cello$support$control$OsaCheckJavaHeap = Control.class$("se.ericsson.cello.support.control.OsaCheckJavaHeap")) : class$se$ericsson$cello$support$control$OsaCheckJavaHeap);
            signalRegistry.add(class$se$ericsson$cello$support$control$OsaDumpJavaThreads == null ? (class$se$ericsson$cello$support$control$OsaDumpJavaThreads = Control.class$("se.ericsson.cello.support.control.OsaDumpJavaThreads")) : class$se$ericsson$cello$support$control$OsaDumpJavaThreads);
            signalRegistry.add(class$se$ericsson$cello$support$control$OsaDumpJavaHeap == null ? (class$se$ericsson$cello$support$control$OsaDumpJavaHeap = Control.class$("se.ericsson.cello.support.control.OsaDumpJavaHeap")) : class$se$ericsson$cello$support$control$OsaDumpJavaHeap);
            signalRegistry.add(class$se$ericsson$cello$support$control$OsaJarRetrival == null ? (class$se$ericsson$cello$support$control$OsaJarRetrival = Control.class$("se.ericsson.cello.support.control.OsaJarRetrival")) : class$se$ericsson$cello$support$control$OsaJarRetrival);
            while (true) {
                UnlinkedSignal unlinkedSignal;
                InSignal inSignal;
                if ((inSignal = ThisProcess.receive(signalRegistry)) instanceof OsaCheckJavaHeap) {
                    Control.this.sendMemorySignal(inSignal.getSender());
                    continue;
                }
                if (inSignal instanceof OsaDumpJavaThreads) {
                    unlinkedSignal = (OsaDumpJavaThreads)inSignal;
                    Control.this.dumpJavaThreads(unlinkedSignal.fileDonator, unlinkedSignal.processid);
                    inSignal.getSender().post(new OsaDumpJavaThreads());
                    continue;
                }
                if (inSignal instanceof OsaDumpJavaHeap) {
                    unlinkedSignal = (OsaDumpJavaHeap)inSignal;
                    Runtime.getRuntime().gc();
                    Control.this.dumpJavaHeap(((OsaDumpJavaHeap)unlinkedSignal).fileDonator, ((OsaDumpJavaHeap)unlinkedSignal).type, ((OsaDumpJavaHeap)unlinkedSignal).limit);
                    inSignal.getSender().post(new OsaDumpJavaHeap());
                    continue;
                }
                if (!(inSignal instanceof OsaJarRetrival)) continue;
                unlinkedSignal = (OsaJarRetrival)inSignal;
                String string = Control.this.findJar(((OsaJarRetrival)unlinkedSignal).clazz);
                inSignal.getSender().post(new OsaJarRetrival(string));
            }
        }
    }
}

