/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch.model;

import se.ericsson.cello.emt.mosearch.model.MoSearchModel;
import se.ericsson.cello.emt.mosearch.view.View;
import se.ericsson.cello.emt.moti.LdnSelectionListener;
import se.ericsson.cello.emt.motools.common.config.ifc.Configuration;
import se.ericsson.cello.emt.motools.common.momodel.StartMo;
import se.ericsson.cello.emt.motools.common.momodel.StartMoFactory;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.Scope;

public class MoSearchModelImpl
implements MoSearchModel {
    private ToolServices myToolServices;
    private StartMo myStartMo;
    private Configuration myConfiguration;
    private View myView;

    public MoSearchModelImpl(ToolServices toolServices, Configuration configuration, StartMo aStartMo) {
        this.myToolServices = toolServices;
        this.myStartMo = aStartMo;
        this.myConfiguration = configuration;
    }

    public ToolServices getToolServices() {
        return this.myToolServices;
    }

    public Mo[] search(String type, String criteria) {
        Mo[] mos = this.myStartMo.getMoRef().getChildren(type, criteria, Scope.ALL_LEVELS, null);
        return mos;
    }

    public StartMo getStartMo() {
        return this.myStartMo;
    }

    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    public void setLdnSelectionListener(LdnSelectionListener listener) {
        this.myView.setLdnSelectionListener(listener);
    }

    public void setConfiguration(ToolServices toolServices, Configuration configuration) {
        this.myToolServices = toolServices;
        this.myConfiguration = configuration;
        this.myStartMo.setLdn(configuration.getLdn());
    }

    public void exit() {
    }

    public void showUI() {
        this.myView.showUI(true);
    }

    public void addView(View view) {
        this.myView = view;
    }

    public void setLdn(String ldn) {
        try {
            this.myStartMo = StartMoFactory.createStartMo(this.myToolServices.getNodeServices(), ldn);
            this.myConfiguration.setLdn(ldn);
        }
        catch (StartFailureException e) {
            throw new RuntimeException("Could not start Node Services");
        }
    }
}

