/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.mosearch.view.gui;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import se.ericsson.cello.emt.mosearch.model.MoSearchModel;
import se.ericsson.cello.emt.motools.common.momodel.StartMo;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 8416938339828928154L;
    private String[] colNames = null;
    protected final String ldn = "LDN";
    protected final String noSelected = "Not Selected";
    private String attrName;
    final int[] columnWidth = new int[]{300, 200};
    protected final int MIN_PREFERRED_COLUMN_WIDTH = 20;
    final boolean[] editable = new boolean[]{false, false};
    private Hashtable<String, Mo> data = null;
    private List<Mo> mySuObjectList = new ArrayList<Mo>();
    private SortedMap<Mo, String> myMoAttrMap = new TreeMap<Mo, String>();
    private MoSearchModel searchModel;

    public SearchResultTableModel(MoSearchModel searchModel) {
        this.searchModel = searchModel;
    }

    public void init() {
    }

    @Override
    public int getColumnCount() {
        return this.colNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.mySuObjectList == null) {
            return 0;
        }
        return this.mySuObjectList.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.colNames[column];
    }

    public synchronized void setAttrName(String aName) {
        this.attrName = aName;
        this.colNames = new String[]{"LDN", this.attrName};
    }

    public String getAttrName() {
        return this.attrName;
    }

    @Override
    public Object getValueAt(int row, int column) {
        String aLDN = null;
        String aValue = null;
        Mo aMo = this.mySuObjectList.get(row);
        switch (column) {
            case 0: {
                try {
                    aLDN = aMo.getLdn();
                }
                catch (Exception e) {
                    aLDN = "Error LDN";
                }
                return aLDN;
            }
            case 1: {
                aValue = this.getAttrValue(aMo);
                this.myMoAttrMap.put(aMo, aValue);
                return aValue;
            }
        }
        return "Data error.";
    }

    private String getAttrValue(Mo mo) {
        String givenMoType;
        String[] attrs = new String[]{this.attrName};
        NameValue[] nameValues = mo.getAttributes(attrs, null);
        StartMo startMo = this.searchModel.getStartMo();
        MomClass aMomClass = startMo.getMomClass(givenMoType = mo.getType());
        MomAttribute aMomAttr = aMomClass.getAttribute(this.attrName);
        MomEntity momEntity = aMomAttr.getType();
        if (momEntity instanceof MomEnumRef) {
            return this.getEnumSymbolAndDigit((MomEnumRef)momEntity, nameValues[0].getIntegerValue());
        }
        if (momEntity instanceof MomStruct) {
            return this.getStructValue(nameValues[0]);
        }
        return nameValues[0].valueToString();
    }

    private String getEnumSymbolAndDigit(MomEnumRef enumRef, int value) {
        MomEnum momEnum = enumRef.getEnum();
        Iterator iter = momEnum.getMembers();
        while (iter.hasNext()) {
            MomEnumMember member = (MomEnumMember)iter.next();
            if (member.getValue() != value) continue;
            return member.getName() + " [" + value + "]";
        }
        return "";
    }

    private String getStructValue(NameValue value) {
        String ret = "";
        Struct structValue = value.getStructValue();
        NameValue[] nameValues = structValue.getNameValueArray();
        for (int i = 0; i < nameValues.length; ++i) {
            ret = ret + nameValues[i].valueToString();
        }
        return ret;
    }

    public Class getColumnClass(int column) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.editable[column];
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    public void setData(Hashtable t) {
        this.data = t;
        this.mySuObjectList.clear();
        if (t != null && t.size() > 0) {
            this.mySuObjectList.addAll(this.data.values());
        }
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void initColumns(JTable jTable) {
        TableColumn tableColumn = null;
        for (int i = 0; i < this.columnWidth.length; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            tableColumn.setPreferredWidth(this.columnWidth[i]);
        }
    }

    public List<Mo> getModelData() {
        return this.mySuObjectList;
    }

    public SortedMap<Mo, String> getMoAttrMap() {
        return this.myMoAttrMap;
    }
}

