/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.OE_Attr_TextField;
import se.ericsson.cello.emt.motools.common.gui.components.StringGUIDocumentListener;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.CorbaTypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class FloatGUI
extends DataTypeGUI {
    private static final long serialVersionUID = 8667016511122252476L;
    static final int VALUE_LENGTH = 18;
    private double previousValue;
    private double initialValue;
    private double maxValue;
    private double minValue;
    private FloatTextField valueT = null;
    private JPanel panel = null;
    private boolean isValidInput = true;
    private boolean readOnly = false;
    private JTextField hiddenTextField = new JTextField();

    public FloatGUI(CorbaTypeValue aAttr, boolean isReadOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices) {
        super(aAttr, container, aToolServices);
        this.panel = this.getPanel();
        String theMaxValueAsString = aAttr.getMaxAsStringValue();
        String theMinValueAsString = aAttr.getMinAsStringValue();
        try {
            this.minValue = Float.parseFloat(theMinValueAsString);
        }
        catch (NumberFormatException e) {
            this.minValue = -2.147483648E9;
        }
        try {
            this.maxValue = Float.parseFloat(theMaxValueAsString);
        }
        catch (NumberFormatException e) {
            this.maxValue = 2.147483647E9;
        }
        this.readOnly = isReadOnly;
        Float floatValueObj = null;
        String stringValue = "";
        if (aAttr.isValueDefined()) {
            stringValue = aAttr.getValueAsString();
            floatValueObj = Float.valueOf(Float.parseFloat(stringValue));
        } else {
            stringValue = "";
            floatValueObj = new Float(0.0f);
        }
        this.valueT = new FloatTextField(stringValue, floatValueObj.floatValue(), this.readOnly);
        this.valueT.getDocument().addDocumentListener(new StringGUIDocumentListener(this));
        this.valueT.setName("valueField");
        this.panel.add(this.valueT);
        if (!supportNullValue && !aAttr.isValueDefined()) {
            JLabel statusL = new JLabel("Value is not defined");
            this.panel.add(statusL);
        }
    }

    public boolean faultyValueEntered() {
        return !this.isValidInput;
    }

    public void newValue(String value) {
        this.valueT.setText(value);
    }

    public String getValue() {
        return this.valueT.getText();
    }

    public void setValue(String value) {
        this.valueT.putValue(value);
        this.setModified(false);
    }

    public void setGUIEditable(boolean editable) {
        this.valueT.setEditable(editable);
        if (editable) {
            this.valueT.setOpaque(true);
        } else {
            this.valueT.setOpaque(false);
        }
    }

    class FloatTextField
    extends OE_Attr_TextField {
        private static final long serialVersionUID = 3229705756554717114L;
        Color errorColor;
        Color errorForegroundColor;

        FloatTextField(String stringValue, double value, boolean readOnly) {
            super(stringValue, 18);
            this.errorColor = new Color(255, 200, 200);
            this.errorForegroundColor = new Color(204, 0, 0);
            FloatGUI.this.initialValue = value;
            FloatGUI.this.previousValue = FloatGUI.this.initialValue;
            this.setEditable(!readOnly);
            if (readOnly) {
                this.setOpaque(false);
                this.setBorder(null);
            } else {
                this.setOpaque(true);
                this.addKeyListener(new KeyAdapter(){

                    public void keyPressed(KeyEvent event) {
                        switch (event.getKeyCode()) {
                            case 40: {
                                FloatGUI.this.newValue(Double.toString(FloatGUI.this.previousValue - 1.0));
                                break;
                            }
                            case 38: {
                                FloatGUI.this.newValue(Double.toString(FloatGUI.this.previousValue + 1.0));
                            }
                        }
                    }
                });
            }
            String toolTipType = FloatGUI.this.getTypeCode();
            String resolution = FloatGUI.this.getResolution();
            String min = FloatGUI.this.minValue + ",";
            String max = "," + FloatGUI.this.maxValue;
            if (FloatGUI.this.minValue == (double)1.4E-45f) {
                min = "";
            }
            if (FloatGUI.this.maxValue == 3.4028234663852886E38) {
                max = "";
            }
            if (min.equals(max)) {
                if (resolution != null) {
                    this.setToolTipText(toolTipType + ";" + " resolution:" + resolution);
                } else {
                    this.setToolTipText(toolTipType);
                }
            } else if (resolution != null) {
                this.setToolTipText(toolTipType + " ; [" + FloatGUI.this.minValue + "..." + FloatGUI.this.maxValue + "]" + ";" + " resolution:" + resolution);
            } else {
                this.setToolTipText(toolTipType + "; [" + FloatGUI.this.minValue + "..." + FloatGUI.this.maxValue + "]");
            }
        }

        public void putValue(String value) {
            this.setText(value);
            try {
                FloatGUI.this.initialValue = Double.valueOf(value);
                FloatGUI.this.previousValue = FloatGUI.this.initialValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            FloatGUI.this.setModified(false);
        }

        public boolean verifyInput(String inputString) {
            double attemptedValue = 0.0;
            boolean accept = true;
            boolean changeValue = true;
            if (inputString.endsWith("e") || inputString.endsWith("E") || inputString.endsWith("e-") || inputString.endsWith("E-") || inputString.endsWith("e+") || inputString.endsWith("E+")) {
                FloatGUI.this.isValidInput = accept;
                return accept;
            }
            if (inputString.equals("") || inputString.equals("-")) {
                accept = false;
            } else {
                try {
                    attemptedValue = Double.valueOf(inputString);
                    if (!(attemptedValue == FloatGUI.this.initialValue || attemptedValue >= FloatGUI.this.minValue && attemptedValue <= FloatGUI.this.maxValue)) {
                        accept = false;
                    }
                }
                catch (NumberFormatException e) {
                    accept = false;
                    changeValue = false;
                }
            }
            this.setOpaque(true);
            if (accept) {
                FloatGUI.this.previousValue = attemptedValue;
                this.setForeground(FloatGUI.this.hiddenTextField.getForeground());
            } else if (changeValue) {
                this.setForeground(this.errorForegroundColor);
            } else {
                this.setForeground(FloatGUI.this.hiddenTextField.getForeground());
            }
            this.validate();
            this.requestFocus();
            FloatGUI.this.isValidInput = accept;
            return changeValue;
        }
    }
}

