/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel.typevalue;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import se.ericsson.cello.emt.motools.common.mimparser.MimCompatibility;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.EnumTypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueDecorator;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomEnumMember;
import se.ericsson.cello.neal.cm.NameValue;

public class EnumTypeValueImpl
extends TypeValueDecorator
implements EnumTypeValue {
    protected HashMap<String, Integer> myDisplaySymbolToIntegerMap = new HashMap();
    protected SortedMap<Integer, String> myIntegerToDisplaySymbolMap = new TreeMap<Integer, String>();
    protected SortedMap<Integer, String> myIntegerToDisplaySymbolNoStrikethroughMap = new TreeMap<Integer, String>();
    protected MomEnum myMomEnum = null;
    protected NameValue myWrappedNameValue = null;
    protected boolean myIsUpdated = false;

    public EnumTypeValueImpl(TypeValue aDecoratedAttrModel, MomEnum aMomEnum) {
        super(aDecoratedAttrModel);
        if (aMomEnum == null) {
            throw new RuntimeException("EnumTypeValueImpl.constructor: myMomEnum is null");
        }
        this.myMomEnum = aMomEnum;
        this.myWrappedNameValue = super.getNameValue();
        this.fillUpMaps();
    }

    public String[] getAllEnumMemberDisplaySymbols() {
        String[] displaySymbolArray = null;
        try {
            displaySymbolArray = new String[this.myIntegerToDisplaySymbolMap.size()];
            Collection<String> displaySymbolCollection = this.myIntegerToDisplaySymbolMap.values();
            displaySymbolCollection.toArray(displaySymbolArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return displaySymbolArray;
    }

    public String[] getAllEnumMemberDisplaySymbolsNoStrikethrough() {
        String[] displaySymbolArray = null;
        try {
            displaySymbolArray = new String[this.myIntegerToDisplaySymbolNoStrikethroughMap.size()];
            Collection<String> displaySymbolCollection = this.myIntegerToDisplaySymbolNoStrikethroughMap.values();
            displaySymbolCollection.toArray(displaySymbolArray);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return displaySymbolArray;
    }

    public String getEnumValueAsDisplaySymbol() {
        String displaySymbol = null;
        try {
            if (this.myWrappedNameValue != null) {
                Integer enumIntegerValue = this.myWrappedNameValue.getIntegerValue();
                displaySymbol = (String)this.myIntegerToDisplaySymbolMap.get(enumIntegerValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return displaySymbol;
    }

    public String getEnumMemberDescription() {
        if (this.myWrappedNameValue != null) {
            Integer enumIntegerValue = this.myWrappedNameValue.getIntegerValue();
            Iterator memberEnumsIter = this.myMomEnum.getMembers();
            while (memberEnumsIter.hasNext()) {
                MomEnumMember member = (MomEnumMember)memberEnumsIter.next();
                if (!enumIntegerValue.equals(member.getValue())) continue;
                return member.getDescription();
            }
        }
        return null;
    }

    public void setEnumValueByDisplaySymbol(String aDisplaySymbol) {
        Integer enumIntegerValue = this.myDisplaySymbolToIntegerMap.get(aDisplaySymbol);
        if (enumIntegerValue == null) {
            throw new RuntimeException("Failed to setEnumValueByDisplaySymbol for enum=" + this.myMomEnum.getName());
        }
        if (this.myWrappedNameValue == null) {
            this.myWrappedNameValue = this.getCmServices().getNameValueFactory().create(this.getName(), enumIntegerValue.intValue());
        } else {
            this.myWrappedNameValue.setIntValue(enumIntegerValue.intValue());
        }
        this.myIsUpdated = true;
    }

    public String getValueAsString() {
        return this.getEnumValueAsDisplaySymbol();
    }

    public MomEnum getMomEnum() {
        return this.myMomEnum;
    }

    public String setValue(String aValue) {
        return null;
    }

    public boolean isUpdated() {
        return this.myIsUpdated;
    }

    public NameValue getNameValue() {
        return this.myWrappedNameValue;
    }

    public String getEnumValue(String aDisplaySymbol) {
        return this.myDisplaySymbolToIntegerMap.get(aDisplaySymbol).toString();
    }

    public String getMomXmlType() {
        return this.myMomEnum.getXmlType();
    }

    public boolean isValueDefined() {
        return this.myWrappedNameValue != null;
    }

    public boolean isValueOutOfRange() {
        if (null == this.myWrappedNameValue) {
            return true;
        }
        Integer value = this.myWrappedNameValue.getIntegerValue();
        if (null == value) {
            return true;
        }
        Iterator memberEnumsIter = this.myMomEnum.getMembers();
        while (memberEnumsIter.hasNext()) {
            MomEnumMember member = (MomEnumMember)memberEnumsIter.next();
            if (MimCompatibility.getObsolete((MomEntity)member) != null || !value.equals(member.getValue())) continue;
            return false;
        }
        return true;
    }

    private void fillUpMaps() {
        try {
            this.myIntegerToDisplaySymbolMap.clear();
            this.myDisplaySymbolToIntegerMap.clear();
            Iterator memberEnumsIter = this.myMomEnum.getMembers();
            while (memberEnumsIter.hasNext()) {
                MomEnumMember member = (MomEnumMember)memberEnumsIter.next();
                if (MimCompatibility.getObsolete((MomEntity)member) != null) continue;
                Integer enumMemberValue = member.getValue();
                String enumMemberDisplaySymbol = null;
                String enumMemberDisplaySymbolNoStrikethrough = null;
                if (MimCompatibility.getDeprecated((MomEntity)member) != null) {
                    enumMemberDisplaySymbolNoStrikethrough = member.getName() + "[" + enumMemberValue + "]";
                    enumMemberDisplaySymbol = "<html><strike>" + enumMemberDisplaySymbolNoStrikethrough + "</strike></html>";
                } else {
                    enumMemberDisplaySymbolNoStrikethrough = enumMemberDisplaySymbol = member.getName() + "[" + enumMemberValue + "]";
                }
                this.myIntegerToDisplaySymbolMap.put(enumMemberValue, enumMemberDisplaySymbol);
                this.myDisplaySymbolToIntegerMap.put(enumMemberDisplaySymbol, enumMemberValue);
                this.myIntegerToDisplaySymbolNoStrikethroughMap.put(enumMemberValue, enumMemberDisplaySymbolNoStrikethrough);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

