/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.XMLReader;
import se.ericsson.cello.mimparser.DerivedDataType;
import se.ericsson.cello.mimparser.DomainExtension;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAssociationEnd;
import se.ericsson.cello.mimparser.MomBiDirectionalAssociation;
import se.ericsson.cello.mimparser.MomChild;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomContainment;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomException;
import se.ericsson.cello.mimparser.MomMetaData;
import se.ericsson.cello.mimparser.MomSoftLink;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomSupport;
import se.ericsson.cello.mimparser.MomSupported;
import se.ericsson.cello.mimparser.MomUniDirectionalAssociation;
import se.ericsson.cello.mimparser.MomVisitor;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MimPartImpl;
import se.ericsson.cello.mimparser.model.MomBase;
import se.ericsson.cello.mimparser.model.MomBiDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.MomContainmentImpl;
import se.ericsson.cello.mimparser.model.MomEntityResolvable;
import se.ericsson.cello.mimparser.model.MomRelationshipExtImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.model.MomSoftLinkImpl;
import se.ericsson.cello.mimparser.model.MomSupportImpl;
import se.ericsson.cello.mimparser.model.MomUniDirectionalAssociationImpl;
import se.ericsson.cello.mimparser.model.ReferenceResolver;
import se.ericsson.cello.mimparser.model.RelationshipResolver;
import se.ericsson.cello.mimparser.state.DtdVersionSettable;

public class MimModelImpl
implements MimModel,
DtdVersionSettable {
    private String momFile;
    private int contentLevel;
    private boolean isTemporaryModel = false;
    private int cacheSize = Integer.MAX_VALUE;
    private List parsedDescriptions = new ArrayList(0);
    private List containmentRelationships = new ArrayList(0);
    private List supportRelationships = new ArrayList(0);
    private List relationshipsExt = new ArrayList(0);
    private ReferenceResolver referenceResolver = new ReferenceResolver();
    private RelationshipResolver relationshipResolver = new RelationshipResolver();
    private Map myClasses = new HashMap(0);
    private Map myStructs = new HashMap(0);
    private Map myEnums = new HashMap(0);
    private Map exceptions = new HashMap(0);
    private Map myDataTypes = new HashMap(0);
    private String dtdVersion;
    private String version;
    private String name;
    private String release;
    private String description;
    private String applicationTag;
    private String copyright;
    private XMLReader clientSuppliedXMLReader;
    private MomMetaData momMetaData;
    private DomainExtension domainExtension;
    private List warningList;
    private List uniDirectionalRelationships = new ArrayList(0);
    private List biDirectionalRelationships = new ArrayList(0);
    private List softLinkRelationships = new ArrayList(0);
    private List myMimParts = new ArrayList(0);

    public MimModelImpl(String momFile, int contentLevel) {
        this.momFile = momFile;
        this.contentLevel = contentLevel;
        this.warningList = new ArrayList(0);
    }

    public void setTemporaryModel() {
        this.isTemporaryModel = true;
    }

    public DomainExtension getDomain() {
        return this.domainExtension;
    }

    public void setDomain(DomainExtensionImpl domainExtension) {
        this.domainExtension = domainExtension;
    }

    public MomMetaData getMomMetaData() {
        return this.momMetaData;
    }

    public void setMomMetaData(MomMetaData momMetaData) {
        this.momMetaData = momMetaData;
    }

    public Iterator getMimParts() {
        return this.myMimParts.iterator();
    }

    public void addMimParts(MimPartImpl mimPart) {
        this.myMimParts.add(mimPart);
    }

    public String getDtdVersion() {
        return this.dtdVersion;
    }

    public void setDtdVersion(String dtdVersion) {
        this.dtdVersion = dtdVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String aVersion) {
        this.version = aVersion;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String aRelease) {
        this.release = aRelease;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDescription) {
        this.description = aDescription;
    }

    public String getApplicationTag() {
        return this.applicationTag;
    }

    public void setApplicationTag(String anApplicationTag) {
        this.applicationTag = anApplicationTag;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String aCopyright) {
        this.copyright = aCopyright;
    }

    public boolean hasWarnings() {
        return !this.warningList.isEmpty();
    }

    public Iterator getWarningList() {
        return this.warningList.iterator();
    }

    public void addToWarningList(String str) {
        this.warningList.add(str);
    }

    public MomClass getRoot() {
        return this.getClass("ManagedElement");
    }

    public MomClass getClass(String name) {
        return (MomClass)this.myClasses.get(name);
    }

    public Iterator getClasses() {
        return this.myClasses.values().iterator();
    }

    public DerivedDataType getDerivedDataType(String name) {
        return (DerivedDataType)this.myDataTypes.get(name);
    }

    public Iterator getAllDerivedDataType() {
        return this.myDataTypes.values().iterator();
    }

    public Iterator findDerivedDataTypes(String query) {
        Iterator allDataTypes = this.getAllDerivedDataType();
        return this.simpleFind(query, allDataTypes);
    }

    public Iterator findClasses(String query) {
        Iterator allClasses = this.getClasses();
        return this.simpleFind(query, allClasses);
    }

    public Iterator findEnums(String query) {
        Iterator allEnums = this.getEnums();
        return this.simpleFind(query, allEnums);
    }

    public Iterator findStructs(String query) {
        Iterator allStructs = this.getStructs();
        return this.simpleFind(query, allStructs);
    }

    private Iterator simpleFind(String query, Iterator momEntities) {
        ArrayList<MomEntity> validMomEntities = new ArrayList<MomEntity>();
        while (momEntities.hasNext()) {
            MomEntity entity = (MomEntity)momEntities.next();
            String name = entity.getName();
            if (query.equals("*")) {
                validMomEntities.add(entity);
                continue;
            }
            if (query.startsWith("*")) {
                String endMatch = query.substring(1);
                if (!name.endsWith(endMatch)) continue;
                validMomEntities.add(entity);
                continue;
            }
            if (query.endsWith("*")) {
                String startMatch = query.substring(0, query.length() - 1);
                if (!name.startsWith(startMatch)) continue;
                validMomEntities.add(entity);
                continue;
            }
            if (!name.equals(query)) continue;
            validMomEntities.add(entity);
        }
        return validMomEntities.iterator();
    }

    public void addClass(String name, MomClass moClass) {
        if (!this.isTemporaryModel) {
            this.myClasses.put(name, moClass);
        }
    }

    public void addStruct(String name, MomStruct moStruct) {
        if (!this.isTemporaryModel) {
            this.myStructs.put(name, moStruct);
        }
    }

    public void addEnum(String name, MomEnum moEnum) {
        if (!this.isTemporaryModel) {
            this.myEnums.put(name, moEnum);
        }
    }

    public void addDerivedDataType(String name, DerivedDataType derivedType) {
        if (!this.isTemporaryModel) {
            this.myDataTypes.put(name, derivedType);
        }
    }

    public MomStruct getStruct(String name) {
        return (MomStruct)this.myStructs.get(name);
    }

    public Iterator getStructs() {
        return this.myStructs.values().iterator();
    }

    public MomEnum getEnum(String name) {
        return (MomEnum)this.myEnums.get(name);
    }

    public Iterator getEnums() {
        return this.myEnums.values().iterator();
    }

    void addException(String name, MomException moException) {
        this.exceptions.put(name, moException);
    }

    MomException getException(String name) {
        return (MomException)this.exceptions.get(name);
    }

    public void accept(MomVisitor momVisitor) {
        MomEntity entity;
        Iterator entities = this.getClasses();
        while (entities.hasNext()) {
            entity = (MomClass)entities.next();
            momVisitor.visitClass((MomClass)entity);
        }
        entities = this.getEnums();
        while (entities.hasNext()) {
            entity = (MomEnum)entities.next();
            momVisitor.visitEnum((MomEnum)entity);
        }
        entities = this.getStructs();
        while (entities.hasNext()) {
            entity = (MomStruct)entities.next();
            momVisitor.visitStruct((MomStruct)entity);
        }
    }

    public String getMomFile() {
        return this.momFile;
    }

    public int getContentLevel() {
        return this.contentLevel;
    }

    public void addparsedDescription(MomBase momBase) {
        if (this.parsedDescriptions.size() == this.cacheSize) {
            this.removeFromCache(1);
        }
        this.parsedDescriptions.add(momBase);
    }

    public void cleanUp() {
        int size = this.parsedDescriptions.size();
        this.removeFromCache(size);
        this.cacheSize = 0;
    }

    public void setCache(int size) {
        if (size < this.parsedDescriptions.size()) {
            this.removeFromCache(this.parsedDescriptions.size() - size);
        }
        this.cacheSize = size;
    }

    private void removeFromCache(int noItems) {
        int noItemsToRemove = noItems;
        int size = this.parsedDescriptions.size();
        if (noItemsToRemove > size) {
            noItemsToRemove = size;
        }
        int FIRST_INDEX = 0;
        for (int i = 0; i < noItemsToRemove; ++i) {
            MomBase mb = (MomBase)this.parsedDescriptions.get(FIRST_INDEX);
            mb.setDescription(null);
            this.parsedDescriptions.remove(FIRST_INDEX);
        }
    }

    public void addMomEntityStructToBeResolved(String name, MomEntityResolvable momEntity) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addStructRef(name, momEntity);
        }
    }

    public void addMomEntityMoToBeResolved(String name, MomEntityResolvable momEntity) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addMoRef(name, momEntity);
        }
    }

    public void addMomEntityDerivedDataTypeToBeResolved(String name, MomEntityResolvable momEntity) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addDerivedDataTypeRef(name, momEntity);
        }
    }

    public void addMomEntityEnumToBeResolved(String name, MomEntityResolvable momEntity) {
        if (!this.isTemporaryModel) {
            this.referenceResolver.addEnumRef(name, momEntity);
        }
    }

    public void resolveReferences() {
        if (!this.isTemporaryModel) {
            this.referenceResolver.resolve(this);
            this.referenceResolver = null;
        }
    }

    public void addRelationshipToBeResolved(MomRelationshipImpl relationship) {
        if (!this.isTemporaryModel) {
            this.relationshipResolver.addRelationship(relationship);
        }
    }

    public void resolveRelationships() {
        if (!this.isTemporaryModel) {
            this.relationshipResolver.resolve(this);
            this.relationshipResolver = null;
        }
    }

    public XMLReader getXMLReader() {
        return this.clientSuppliedXMLReader;
    }

    public void setXMLReader(XMLReader reader) {
        this.clientSuppliedXMLReader = reader;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public Iterator getContainmentRelationships() {
        return this.containmentRelationships.iterator();
    }

    public void addContainmentRelationshipToBeResolved(MomContainmentImpl containmentRelationship) {
        this.containmentRelationships.add(containmentRelationship);
        this.relationshipResolver.addContainment(containmentRelationship);
    }

    public Iterator getBiDirectionalAssociations() {
        return this.biDirectionalRelationships.iterator();
    }

    public void addBiDirectionalAssociationToBeResolved(MomBiDirectionalAssociationImpl biDirectional) {
        this.biDirectionalRelationships.add(biDirectional);
        this.relationshipResolver.addBiDirectionalAssociation(biDirectional);
    }

    public Iterator getSoftLinkRelationships() {
        return this.softLinkRelationships.iterator();
    }

    public void addSoftLinkRelationShipToBeResolved(MomSoftLinkImpl softLink) {
        this.softLinkRelationships.add(softLink);
        this.relationshipResolver.addSoftLink(softLink);
    }

    public Iterator getSupportRelationships() {
        return this.supportRelationships.iterator();
    }

    public void addSupportRelationShipToBeResolved(MomSupportImpl support) {
        this.supportRelationships.add(support);
        this.relationshipResolver.addSupport(support);
    }

    public Iterator getUniDirectionalAssociations() {
        return this.uniDirectionalRelationships.iterator();
    }

    public void addUniDirectionalRelationShipToBeResolved(MomUniDirectionalAssociationImpl uniDirectional) {
        this.uniDirectionalRelationships.add(uniDirectional);
        this.relationshipResolver.addUniDirectionalAssociation(uniDirectional);
    }

    public Iterator getRelationships() {
        return this.relationshipsExt.iterator();
    }

    public void addRelationshipToBeResolved(MomRelationshipExtImpl momRelationshipExtObject) {
        this.relationshipsExt.add(momRelationshipExtObject);
    }

    public Iterator getBiDirectionalAssociations(String associationEndFrom, String associationEndTo) {
        ArrayList<MomBiDirectionalAssociation> result = new ArrayList<MomBiDirectionalAssociation>();
        Iterator associations = this.getBiDirectionalAssociations();
        while (associations.hasNext()) {
            MomBiDirectionalAssociation association = (MomBiDirectionalAssociation)associations.next();
            if (associationEndFrom != null && associationEndTo == null) {
                String parent = association.getAssociationEndFrom().getHasClass().getMomClass().getName();
                if (!associationEndFrom.equals(parent)) continue;
                result.add(association);
                continue;
            }
            if (associationEndTo != null && associationEndFrom == null) {
                Iterator children = association.getAssociationEndsTo();
                while (children.hasNext()) {
                    MomAssociationEnd child = (MomAssociationEnd)children.next();
                    if (!associationEndTo.equals(child.getHasClass().getName())) continue;
                    result.add(association);
                }
                continue;
            }
            if (associationEndTo == null || associationEndFrom == null) continue;
            boolean foundParent = false;
            boolean foundChild = false;
            String parent = association.getAssociationEndFrom().getHasClass().getMomClass().getName();
            if (associationEndFrom.equals(parent)) {
                foundParent = true;
            }
            Iterator children = association.getAssociationEndsTo();
            while (children.hasNext()) {
                MomAssociationEnd child = (MomAssociationEnd)children.next();
                if (!associationEndTo.equals(child.getHasClass().getName())) continue;
                foundChild = true;
            }
            if (!foundParent || !foundChild) continue;
            result.add(association);
        }
        return result.iterator();
    }

    public Iterator getContainmentRelationships(String parentClass, String childClass) {
        Iterator containments = this.getContainmentRelationships();
        ArrayList<MomContainment> result = new ArrayList<MomContainment>();
        while (containments.hasNext()) {
            MomContainment containment = (MomContainment)containments.next();
            if (parentClass != null && childClass == null) {
                String parent = containment.getParent().getHasClass().getMomClass().getName();
                if (!parentClass.equals(parent)) continue;
                result.add(containment);
                continue;
            }
            if (childClass != null && parentClass == null) {
                Iterator children = containment.getChildren();
                while (children.hasNext()) {
                    MomChild child = (MomChild)children.next();
                    if (!childClass.equals(child.getHasClass().getName())) continue;
                    result.add(containment);
                }
                continue;
            }
            if (childClass == null || parentClass == null) continue;
            boolean foundParent = false;
            boolean foundChild = false;
            String parent = containment.getParent().getHasClass().getMomClass().getName();
            if (parentClass.equals(parent)) {
                foundParent = true;
            }
            Iterator children = containment.getChildren();
            while (children.hasNext()) {
                MomChild child = (MomChild)children.next();
                if (!childClass.equals(child.getHasClass().getName())) continue;
                foundChild = true;
            }
            if (!foundParent || !foundChild) continue;
            result.add(containment);
        }
        return result.iterator();
    }

    public Iterator getSoftLinkRelationships(String parentClass, String childClass) {
        ArrayList<MomSoftLink> result = new ArrayList<MomSoftLink>();
        Iterator softlinks = this.getSoftLinkRelationships();
        while (softlinks.hasNext()) {
            MomSoftLink softlink = (MomSoftLink)softlinks.next();
            if (parentClass != null && childClass == null) {
                String parent = softlink.getParent().getHasClass().getMomClass().getName();
                if (!parentClass.equals(parent)) continue;
                result.add(softlink);
                continue;
            }
            if (childClass != null && parentClass == null) {
                Iterator children = softlink.getChildren();
                while (children.hasNext()) {
                    MomChild child = (MomChild)children.next();
                    if (!childClass.equals(child.getHasClass().getName())) continue;
                    result.add(softlink);
                }
                continue;
            }
            if (childClass == null || parentClass == null) continue;
            boolean foundParent = false;
            boolean foundChild = false;
            String parent = softlink.getParent().getHasClass().getMomClass().getName();
            if (parentClass.equals(parent)) {
                foundParent = true;
            }
            Iterator children = softlink.getChildren();
            while (children.hasNext()) {
                MomChild child = (MomChild)children.next();
                if (!childClass.equals(child.getHasClass().getName())) continue;
                foundChild = true;
            }
            if (!foundParent || !foundChild) continue;
            result.add(softlink);
        }
        return result.iterator();
    }

    public Iterator getSupportRelationships(String supporterClass, String supportedClass) {
        ArrayList<MomSupport> result = new ArrayList<MomSupport>();
        Iterator supports = this.getSupportRelationships();
        while (supports.hasNext()) {
            MomSupport support = (MomSupport)supports.next();
            if (supporterClass != null && supportedClass == null) {
                String parent = support.getSupporter().getHasClass().getMomClass().getName();
                if (!supporterClass.equals(parent)) continue;
                result.add(support);
                continue;
            }
            if (supportedClass != null && supporterClass == null) {
                Iterator children = support.getSupported();
                while (children.hasNext()) {
                    MomSupported child = (MomSupported)children.next();
                    if (!supportedClass.equals(child.getHasClass().getName())) continue;
                    result.add(support);
                }
                continue;
            }
            if (supportedClass == null || supporterClass == null) continue;
            boolean foundParent = false;
            boolean foundChild = false;
            String supporter = support.getSupporter().getHasClass().getMomClass().getName();
            if (supporterClass.equals(supporter)) {
                foundParent = true;
            }
            Iterator children = support.getSupported();
            while (children.hasNext()) {
                MomSupported supported = (MomSupported)children.next();
                if (!supportedClass.equals(supported.getHasClass().getName())) continue;
                foundChild = true;
            }
            if (!foundParent || !foundChild) continue;
            result.add(support);
        }
        return result.iterator();
    }

    public Iterator getUniDirectionalAssociations(String startClass, String associationEndTo) {
        ArrayList<MomUniDirectionalAssociation> result = new ArrayList<MomUniDirectionalAssociation>();
        Iterator associations = this.getUniDirectionalAssociations();
        while (associations.hasNext()) {
            String parent;
            MomUniDirectionalAssociation association = (MomUniDirectionalAssociation)associations.next();
            if (startClass != null && associationEndTo == null && startClass.equals(parent = association.getHasClass().getMomClass().getName())) {
                result.add(association);
            }
            if (associationEndTo != null && startClass == null) {
                Iterator children = association.getAssociationEndsTo();
                while (children.hasNext()) {
                    MomAssociationEnd child = (MomAssociationEnd)children.next();
                    if (!associationEndTo.equals(child.getHasClass().getName())) continue;
                    result.add(association);
                }
                continue;
            }
            if (startClass == null || associationEndTo == null) continue;
            boolean foundParent = false;
            boolean foundChild = false;
            String parent2 = association.getHasClass().getMomClass().getName();
            if (startClass.equals(parent2)) {
                foundParent = true;
            }
            Iterator children = association.getAssociationEndsTo();
            while (children.hasNext()) {
                MomAssociationEnd child = (MomAssociationEnd)children.next();
                if (!associationEndTo.equals(child.getHasClass().getName())) continue;
                foundChild = true;
            }
            if (!foundParent || !foundChild) continue;
            result.add(association);
        }
        return result.iterator();
    }
}

