/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.model.DomainExtensionImpl;
import se.ericsson.cello.mimparser.model.MomParameterImpl;
import se.ericsson.cello.mimparser.state.DomainExtensionState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

class ParameterState
extends MomBaseState {
    private MomParameterImpl momParameter;
    private static String PARAMETER_TAG = "parameter";
    private static String EXCEPTION_PARAMETER_TAG = "exceptionParameter";
    private static final String[] allPossibleParameterTags = new String[]{PARAMETER_TAG, EXCEPTION_PARAMETER_TAG};

    public ParameterState(MomParameterImpl momParameter, String parameterTag) {
        super(parameterTag);
        this.momParameter = momParameter;
    }

    public void startElement(StateMachine stateMachine, String name, Attributes attributes) {
        super.startElement(stateMachine, name, this.momParameter);
        if (!this.handleKindElements(name)) {
            stateMachine.getDataTypeManager().handleDataTypes(this.momParameter, name, attributes);
        } else if (name.equals("domainExtension")) {
            DomainExtensionImpl domainObject = new DomainExtensionImpl(name, attributes, stateMachine.getParseInfo().getMimModel(), stateMachine.getParseInfo().getNextId());
            this.momParameter.setDomain(domainObject);
            stateMachine.pushState(new DomainExtensionState(domainObject));
        }
    }

    private boolean handleKindElements(String name) {
        boolean isKind = false;
        if (name.equals("in")) {
            this.momParameter.setKind("in");
            isKind = true;
        } else if (name.equals("out")) {
            this.momParameter.setKind("out");
            isKind = true;
        } else if (name.equals("inout")) {
            this.momParameter.setKind("inout");
            isKind = true;
        }
        return isKind;
    }

    public static boolean isParameter(String tag) {
        boolean parameterTag = false;
        for (int i = 0; i < allPossibleParameterTags.length; ++i) {
            if (!tag.equals(allPossibleParameterTags[i])) continue;
            parameterTag = true;
            break;
        }
        return parameterTag;
    }
}

