/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.supsys.omf.aue.step2.actions;

import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.step2.actions.util.Step2Handler;

public class CreateMaoEcBusAction
implements MoDataAction {
    private static final String STRING_TRUE = "true";
    private static final Class THIS_CLASS = CreateMaoEcBusAction.class;
    private static final AbstractLogger logger = LoggingService.getLogger((String)THIS_CLASS.getName());
    private static final String ECBUS_DATA = "ecBusData";
    private static final String ECBUS_LDN = "ManagedElement=1,Equipment=1,EcBus=1";
    private static final String PLUG_IN_UNIT_LDN = "ManagedElement=1,Equipment=1,Subrack=1,Slot=1,PlugInUnit=1";
    private static final String FRO_ID_ATTR_NAME = "froId";
    private static final String BOOL_CREATE_ECBUS_DATA = "boolCreateEcBusData";
    private static final String ECBUS_ATT_CONNECTOR_REF = "ecBusConnectorRef";

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string = step2Handler.retrieveFromAuePersistency("", BOOL_CREATE_ECBUS_DATA);
        if (string.equalsIgnoreCase(STRING_TRUE)) {
            int n = this.getFroIdFromStep1(ECBUS_LDN, converterContext);
            this.createMo(converterContext, ECBUS_LDN, n, coordinator);
        }
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private int getFroIdFromStep1(String string, ConverterContext converterContext) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "getFroIdFromStep1()");
        int n = 0;
        Step2Handler step2Handler = (Step2Handler)converterContext.getAttribute("CURRENT_STEP2_HANDLER");
        String string2 = step2Handler.retrieveFromAuePersistency("", ECBUS_DATA);
        if (string2 == null || string2.length() == 0) {
            throw new CrbsAueException("Can not find froId in AuePersistency database table for ldn=" + string);
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new CrbsAueException("Can not read froId from AuePersistency database table for ldn=" + string + " Exception=" + exception.toString(), (Throwable)exception);
        }
        logger.traceReturn(THIS_CLASS, "getFroIdFromStep1()");
        return n;
    }

    private void createMo(ConverterContext converterContext, String string, int n, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createMo()");
        MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
        try {
            MoDataWrapper moDataWrapper = moDataAccessor.create(string, coordinator);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            this.addFroIdAttribute(moDataWrapper, n);
            this.addReferenceAttribute(moDataWrapper, ECBUS_ATT_CONNECTOR_REF, PLUG_IN_UNIT_LDN);
        }
        catch (AueException aueException) {
            CrbsAueException crbsAueException = new CrbsAueException(aueException.getMessage());
            crbsAueException.setStackTrace(aueException.getStackTrace());
            throw crbsAueException;
        }
        logger.traceReturn(THIS_CLASS, "createMo()");
    }

    private void addFroIdAttribute(MoDataWrapper moDataWrapper, int n) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addFroIdAttribute()");
        IntegerAttribute integerAttribute = new IntegerAttribute(FRO_ID_ATTR_NAME, false, n);
        moDataWrapper.registerPersistentAttr((Attribute)integerAttribute);
        logger.traceReturn(THIS_CLASS, "addFroIdAttribute()");
    }

    private void addReferenceAttribute(MoDataWrapper moDataWrapper, String string, String string2) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "addReferenceAttribute()");
        ReferenceAttribute referenceAttribute = new ReferenceAttribute(string, string2, false);
        moDataWrapper.registerPersistentAttr((Attribute)referenceAttribute);
        logger.traceReturn(THIS_CLASS, "addReferenceAttribute()");
    }
}

