/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import se.ericsson.cello.neal.internal.NealLog;

class HttpsClient {
    private static final HostnameVerifier DISABLE_VERIFY = new HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            NealLog.fine("Host name is acceptable");
            return true;
        }
    };
    private static final TrustManager TRUST_MANAGER = new X509TrustManager(){

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            NealLog.fine("checkClientTrusted OK");
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            NealLog.fine("checkServerTrusted OK");
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };
    public static final int DEFAULT_TIMEOUT = 60000;
    private static final String HTTPS = "https";
    private static final String METHOD = "GET";
    private static final String USER_AGENT = "SMO/1.0";
    private URL url = null;
    private HttpsURLConnection connection = null;
    private InputStream inputStream = null;
    private int responseCode;
    private long contentLength;

    public HttpsClient() {
        this.clearFields();
    }

    public HttpsClient(String string) throws IOException {
        this(new URL(string));
    }

    public HttpsClient(String string, int n) throws IOException {
        this(new URL(string), n);
    }

    public HttpsClient(URL uRL) throws IOException {
        this.connect(uRL);
    }

    public HttpsClient(URL uRL, int n) throws IOException {
        this.connect(uRL, n);
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public void connect(URL uRL) throws IOException {
        this.connect(uRL, 60000);
    }

    public void connect(URL uRL, int n) throws IOException {
        NealLog.fine("Connect to URL " + uRL);
        TimeoutThread timeoutThread = null;
        this.close();
        this.clearFields();
        try {
            TrustManager[] trustManagerArray = new TrustManager[]{TRUST_MANAGER};
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            this.setUrl(uRL);
            this.connection = (HttpsURLConnection)uRL.openConnection();
            this.connection.setHostnameVerifier(DISABLE_VERIFY);
            this.connection.setRequestMethod(METHOD);
            this.connection.setDoInput(true);
            this.connection.setDoOutput(this.isConnected());
            this.connection.setRequestProperty("User-Agent", USER_AGENT);
            timeoutThread = new TimeoutThread(this.connection, n);
            timeoutThread.start();
            this.responseCode = this.connection.getResponseCode();
            this.inputStream = this.connection.getInputStream();
            timeoutThread.abort();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException("This JVM doesn't support SSL");
            iOException.initCause(noSuchAlgorithmException);
            throw iOException;
        }
        catch (KeyManagementException keyManagementException) {
            IOException iOException = new IOException("There was a problem trusting the server.");
            iOException.initCause(keyManagementException);
            throw iOException;
        }
        catch (IOException iOException) {
            this.close();
            if (timeoutThread != null) {
                timeoutThread.abort();
            }
            throw iOException;
        }
    }

    public void close() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
            this.inputStream = null;
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    private void clearFields() {
        this.responseCode = -1;
        this.contentLength = -1L;
    }

    private void setUrl(URL uRL) throws IOException {
        if (this.connection != null) {
            throw new IOException("Can not change URL while connected.");
        }
        if (uRL == null) {
            throw new IOException("URL can not be null.");
        }
        this.url = null;
        if (!uRL.getProtocol().equalsIgnoreCase(HTTPS)) {
            throw new IOException("Unsupported protocol: " + uRL.getProtocol());
        }
        int n = uRL.getPort();
        if (n == -1) {
            n = 443;
        }
        if (n == -1) {
            throw new IOException("Unknown default port for protocol in url: " + uRL);
        }
        this.url = uRL;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("here");
            HttpsClient httpsClient = new HttpsClient("https://localhost:8080");
            System.out.println("Response code: " + httpsClient.getResponseCode());
            int n = 0;
            InputStream inputStream = httpsClient.getInputStream();
            while (inputStream.read() != -1) {
                ++n;
            }
            System.out.println("Read " + n + " additional bytes.");
            httpsClient.close();
            System.out.println("done");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    private class TimeoutThread
    extends Thread {
        private HttpURLConnection myhttpsConnection;
        private int timeout;

        public TimeoutThread(HttpURLConnection httpURLConnection, int n) {
            this.myhttpsConnection = httpURLConnection;
            this.timeout = n;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
                this.myhttpsConnection.disconnect();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void abort() {
            this.interrupt();
        }
    }
}

