/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swmanagement;

import java.text.StringCharacterIterator;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.equipment.eqaccess.MO_HandlerFactoryAccess;
import se.ericsson.cello.equipment.eqaccess.PiuTypeMO_HandlerAccess;
import se.ericsson.cello.equipment.intma.PiuTypeAccess;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.InternalConfigurationErrorException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.NoSuchFieldException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductDataInterface;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.MoConfigurationInterface;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.PiuTypeDataInterface;
import se.ericsson.cello.sudom.extif.sudom.proxy.piutype.ProgramConfigurationInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.PiuTypeProxyInformation;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.PiuTypeReadProxyInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.ProxySelectorSwmInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.InvalidIndexException;
import se.ericsson.cello.swmanagement.PiuTypeMoInternal;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformation;
import se.ericsson.cello.swmanagement.suaccess.ProgramConfigurationInformations;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.util.library.Lib;

public class PiuTypeMoImpl
extends ManagedObjectBase
implements PiuTypeMoInternal,
PiuTypeMoSU_Access,
PiuTypeAccess {
    PiuTypeProxyInformation myPiuTypeProxyInformation = null;
    ProxySelectorSwmInterface myProxySelectorInterface = (ProxySelectorSwmInterface)ServiceLocatorFacade.getRepository().getService(ProxySelectorSwmInterface.class);
    String myProductNumberOpt = null;
    String myProductRevisionOpt = null;
    private MoData data;
    private StringAttribute userLabel;
    private IntegerAttribute defAllowedSeqRestarts;
    private StringAttribute productNumber;
    private StringAttribute productRevision;
    private StringAttribute productName;
    private StringAttribute productInfo;
    private StringAttribute productionDate;
    private IntegerAttribute boardWidth;
    private SequenceAttribute tagSeq;
    private SequenceAttribute loadableProcessorNameSeq;
    private SequenceAttribute subParentLDNSeq;
    private SequenceAttribute programMoTypeNameSeq;
    private SequenceAttribute reservedBy;
    private BooleanAttribute isInstalled;
    private IntegerAttribute piuRole;
    private IntegerAttribute loadModuleFilesInstallState;
    private FloatAttribute normalLowTempAirFlow;
    private FloatAttribute normalHighTempAirFlow;
    private FloatAttribute noiseReducedLowTempAirFlow;
    private FloatAttribute noiseReducedHighTempAirFlow;
    private SequenceAttribute spSubParentLDNSeq;
    private SequenceAttribute moTypeNameSeq;
    private SequenceAttribute identitySeq;
    private StructAttribute mySU_DOM_Key = null;
    private static String[] moConfigurationNames = new String[]{"spSubParentLDN", "moTypeNamea", "identity"};
    private static String[] programConfigurationNames = new String[]{"tag", "subParentLDN", "programMoTypeName", "loadableProcessorName"};
    private static String[] adminProductDataNames = new String[]{"productNumber", "productRevision", "productName", "productInfo", "productionDate"};
    static final String[] SUPPORTED_VERSIONS = new String[]{"SU_2", "SU_3", "SU_4"};
    private static final String EMPTY_STRING = "";
    private static final int MO_DATA_REVISION_5100 = 5100;
    private static final int MO_DATA_REVISION_6100 = 6100;
    private static final int MO_DATA_REVISION_9000 = 9000;
    private static final int MO_DATA_REVISION_14100 = 14100;
    private static final int MO_DATA_REVISION_LATEST = 14100;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"create(ManagedObject aParent, AttrList anAttributes, String anIdentity, ManagedObject source, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanAttributes: " + Lib.toString((AttrList)attrList) + "\n\tanIdentity: " + string + "\n\taSource: " + managedObject2 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return PiuTypeMoImpl.createMO(managedObject, attrList, string, true, coordinator);
    }

    public static synchronized ManagedObject createAtUpgrade(ManagedObject managedObject, AttrList attrList, String string, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"createAtUpgrade(ManagedObject aParent, AttrList anAttributes, String anIdentity, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanAttributes: " + Lib.toString((AttrList)attrList) + "\n\tanIdentity: " + string + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        return PiuTypeMoImpl.createMO(managedObject, attrList, string, false, coordinator);
    }

    public static synchronized PiuTypeMoSU_Access createAtUpgrade(ManagedObject managedObject, String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"createAtUpgrade(ManagedObject aParent, String anIdentity, String aProductNumber, String aProductRevision, String anUserLabel, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanIdentity: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tanUserLabel: " + string4 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"PiuType", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"SwManagement");
        if (!string3.equals("*")) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string3);
            char c = stringCharacterIterator.first();
            if (!(c == 'R' | c == 'r' | c == 'P' | c == 'p')) {
                throw new ValueOutOfRangeException("productRevision", "PiuType");
            }
            c = stringCharacterIterator.next();
            if (!Character.isDigit(c)) {
                throw new ValueOutOfRangeException("productRevision", "PiuType");
            }
        }
        return new PiuTypeMoImpl(managedObject, string, string2, string3, string4, coordinator);
    }

    private static ManagedObject createMO(ManagedObject managedObject, AttrList attrList, String string, boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"create( ManagedObject aParent, AttrList anAttributes, String anIdentity, boolean anIsCheckOfExistingRevisionsNeeded, Coordinator aCoordinator)", (String)("aParent: " + managedObject + "\n\tanAttributes: " + Lib.toString((AttrList)attrList) + "\n\tanIdentity: " + string + "\n\tanIsCheckOfExistingRevisionsNeeded: " + bl + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"PiuType", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"SwManagement");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)EMPTY_STRING, (String)"PiuType", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"defAllowedSeqRestarts", (AttrList)attrList, (boolean)true, (int)3, (int)-1, (int)3, (String)"PiuType");
        int n2 = PiuTypeMoImpl.checkAndGetRole(attrList);
        Struct struct = PiuTypeMoImpl.checkAndGetProductData(attrList, bl);
        Struct struct2 = PiuTypeMoImpl.checkAndGetAirFlowData(attrList);
        int n3 = PiuTypeMoImpl.checkAndGetBoardWidth(attrList);
        boolean bl2 = PiuTypeMoImpl.checkAndGetIsInstalled(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"PiuType");
        return new PiuTypeMoImpl(managedObject, string, string2, n, struct, struct2, n3, bl2, n2, coordinator);
    }

    private PiuTypeMoImpl(ManagedObject managedObject, String string, String string2, int n, Struct struct, Struct struct2, int n2, boolean bl, int n3, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "PiuType", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PiuTypeMoImpl( ManagedObject parent, String identity, String userL, Struct prodData, Struct airFlowData, int boardWd, boolean install, int role, Coordinator context )", (String)("parent: " + managedObject + "\n\tidentity: " + string + "\n\tuserL: " + string2 + "\n\tprodData: " + Lib.toString((Struct)struct) + "\n\tairFlowData: " + Lib.toString((Struct)struct2) + "\n\tboardWd: " + n2 + "\n\tinstall: " + bl + "\n\trole: " + n3 + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.mySU_DOM_Key = new StructAttribute("SU_DOM_KEY", false);
        this.data.registerPersistentAttr((Attribute)this.mySU_DOM_Key);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.defAllowedSeqRestarts = new IntegerAttribute("defAllowedSeqRestarts", false, n);
        this.data.registerPersistentAttr((Attribute)this.defAllowedSeqRestarts);
        this.productNumber = new StringAttribute("productNumber", false);
        this.productNumber.setValue((String)struct.getValue("productNumber"));
        this.data.registerPersistentAttr((Attribute)this.productNumber);
        this.myProductNumberOpt = Lib.optimize((String)((String)struct.getValue("productNumber")));
        this.productRevision = new StringAttribute("productRevision", false);
        this.productRevision.setValue((String)struct.getValue("productRevision"));
        this.data.registerPersistentAttr((Attribute)this.productRevision);
        this.myProductRevisionOpt = Lib.optimize((String)((String)struct.getValue("productRevision")));
        this.productName = new StringAttribute("productName", false);
        if (struct.size() > 2) {
            this.productName.setValue((String)struct.getValue("productName"));
        }
        this.data.registerPersistentAttr((Attribute)this.productName);
        this.productInfo = new StringAttribute("productInfo", false);
        if (struct.size() > 3) {
            this.productInfo.setValue((String)struct.getValue("productInfo"));
        }
        this.data.registerPersistentAttr((Attribute)this.productInfo);
        this.productionDate = new StringAttribute("productionDate", false);
        if (struct.size() > 4) {
            this.productionDate.setValue((String)struct.getValue("productionDate"));
        }
        this.data.registerPersistentAttr((Attribute)this.productionDate);
        this.normalLowTempAirFlow = new FloatAttribute("normalLowTempAirFlow", false);
        this.normalLowTempAirFlow.setValue((Float)struct2.getValue("normalLowTempAirFlow"));
        this.data.registerPersistentAttr((Attribute)this.normalLowTempAirFlow);
        this.normalHighTempAirFlow = new FloatAttribute("normalHighTempAirFlow", false);
        this.normalHighTempAirFlow.setValue((Float)struct2.getValue("normalHighTempAirFlow"));
        this.data.registerPersistentAttr((Attribute)this.normalHighTempAirFlow);
        this.noiseReducedLowTempAirFlow = new FloatAttribute("noiseReducedLowTempAirFlow", false);
        this.noiseReducedLowTempAirFlow.setValue((Float)struct2.getValue("noiseReducedLowTempAirFlow"));
        this.data.registerPersistentAttr((Attribute)this.noiseReducedLowTempAirFlow);
        this.noiseReducedHighTempAirFlow = new FloatAttribute("noiseReducedHighTempAirFlow", false);
        this.noiseReducedHighTempAirFlow.setValue((Float)struct2.getValue("noiseReducedHighTempAirFlow"));
        this.data.registerPersistentAttr((Attribute)this.noiseReducedHighTempAirFlow);
        this.boardWidth = new IntegerAttribute("boardWidth", false, n2);
        this.data.registerPersistentAttr((Attribute)this.boardWidth);
        this.piuRole = new IntegerAttribute("role", false, n3);
        this.data.registerPersistentAttr((Attribute)this.piuRole);
        this.loadModuleFilesInstallState = new IntegerAttribute("lmFilesInstallState", true, 0);
        this.data.registerPersistentAttr((Attribute)this.loadModuleFilesInstallState);
        this.tagSeq = new SequenceAttribute("tag", false);
        this.data.registerPersistentAttr((Attribute)this.tagSeq);
        this.subParentLDNSeq = new SequenceAttribute("subParentLDN", false);
        this.data.registerPersistentAttr((Attribute)this.subParentLDNSeq);
        this.programMoTypeNameSeq = new SequenceAttribute("programMoTypeName", false);
        this.data.registerPersistentAttr((Attribute)this.programMoTypeNameSeq);
        this.loadableProcessorNameSeq = new SequenceAttribute("loadableProcessorName", false);
        this.data.registerPersistentAttr((Attribute)this.loadableProcessorNameSeq);
        this.isInstalled = new BooleanAttribute("isInstalled", false, bl);
        this.data.registerPersistentAttr((Attribute)this.isInstalled);
        this.spSubParentLDNSeq = new SequenceAttribute("spSubParentLDN", false);
        this.data.registerPersistentAttr((Attribute)this.spSubParentLDNSeq);
        this.moTypeNameSeq = new SequenceAttribute("moTypeNamea", false);
        this.data.registerPersistentAttr((Attribute)this.moTypeNameSeq);
        this.identitySeq = new SequenceAttribute("identity", false);
        this.data.registerPersistentAttr((Attribute)this.identitySeq);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.reservedBy.setValue(new Attribute[0]);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.data.setRevision(14100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    private PiuTypeMoImpl(ManagedObject managedObject, String string, String string2, String string3, String string4, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "PiuType", string, coordinator);
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"SubrackProdTypeMoImpl(ManagedObject aParent, String anIdentity, String aProductNumber, String aProductRevision, String anUserLabel, Coordinator aCoordinator)", (String)("parent: " + managedObject + "\n\tidentity: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3 + "\n\tanUserLabel: " + string4 + "\n\taCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.mySU_DOM_Key = new StructAttribute("SU_DOM_KEY", false);
        StringAttribute stringAttribute = null;
        stringAttribute = new StringAttribute("productNumber", false, string2);
        this.mySU_DOM_Key.addElement((Attribute)stringAttribute);
        stringAttribute = new StringAttribute("productRevision", false, string3);
        this.mySU_DOM_Key.addElement((Attribute)stringAttribute);
        this.data.registerPersistentAttr((Attribute)this.mySU_DOM_Key);
        this.myProductNumberOpt = string2;
        this.myProductRevisionOpt = string3;
        this.userLabel = new StringAttribute("userLabel", true, string4);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.defAllowedSeqRestarts = new IntegerAttribute("defAllowedSeqRestarts", false, 0);
        this.data.registerPersistentAttr((Attribute)this.defAllowedSeqRestarts);
        this.productNumber = new StringAttribute("productNumber", false);
        this.productNumber.setValue(EMPTY_STRING);
        this.data.registerPersistentAttr((Attribute)this.productNumber);
        this.productRevision = new StringAttribute("productRevision", false);
        this.productRevision.setValue(EMPTY_STRING);
        this.data.registerPersistentAttr((Attribute)this.productRevision);
        this.productName = new StringAttribute("productName", false);
        this.productName.setValue(EMPTY_STRING);
        this.data.registerPersistentAttr((Attribute)this.productName);
        this.productInfo = new StringAttribute("productInfo", false);
        this.productInfo.setValue(EMPTY_STRING);
        this.data.registerPersistentAttr((Attribute)this.productInfo);
        this.productionDate = new StringAttribute("productionDate", false);
        this.productionDate.setValue(EMPTY_STRING);
        this.data.registerPersistentAttr((Attribute)this.productionDate);
        this.normalLowTempAirFlow = new FloatAttribute("normalLowTempAirFlow", false);
        this.normalLowTempAirFlow.setValue(0.0f);
        this.data.registerPersistentAttr((Attribute)this.normalLowTempAirFlow);
        this.normalHighTempAirFlow = new FloatAttribute("normalHighTempAirFlow", false);
        this.normalHighTempAirFlow.setValue(0.0f);
        this.data.registerPersistentAttr((Attribute)this.normalHighTempAirFlow);
        this.noiseReducedLowTempAirFlow = new FloatAttribute("noiseReducedLowTempAirFlow", false);
        this.noiseReducedLowTempAirFlow.setValue(0.0f);
        this.data.registerPersistentAttr((Attribute)this.noiseReducedLowTempAirFlow);
        this.noiseReducedHighTempAirFlow = new FloatAttribute("noiseReducedHighTempAirFlow", false);
        this.noiseReducedHighTempAirFlow.setValue(0.0f);
        this.data.registerPersistentAttr((Attribute)this.noiseReducedHighTempAirFlow);
        this.boardWidth = new IntegerAttribute("boardWidth", false, 0);
        this.data.registerPersistentAttr((Attribute)this.boardWidth);
        this.piuRole = new IntegerAttribute("role", false, 0);
        this.data.registerPersistentAttr((Attribute)this.piuRole);
        this.loadModuleFilesInstallState = new IntegerAttribute("lmFilesInstallState", true, 0);
        this.data.registerPersistentAttr((Attribute)this.loadModuleFilesInstallState);
        this.tagSeq = new SequenceAttribute("tag", false);
        this.data.registerPersistentAttr((Attribute)this.tagSeq);
        this.subParentLDNSeq = new SequenceAttribute("subParentLDN", false);
        this.data.registerPersistentAttr((Attribute)this.subParentLDNSeq);
        this.programMoTypeNameSeq = new SequenceAttribute("programMoTypeName", false);
        this.data.registerPersistentAttr((Attribute)this.programMoTypeNameSeq);
        this.loadableProcessorNameSeq = new SequenceAttribute("loadableProcessorName", false);
        this.data.registerPersistentAttr((Attribute)this.loadableProcessorNameSeq);
        this.isInstalled = new BooleanAttribute("isInstalled", false, false);
        this.data.registerPersistentAttr((Attribute)this.isInstalled);
        this.spSubParentLDNSeq = new SequenceAttribute("spSubParentLDN", false);
        this.data.registerPersistentAttr((Attribute)this.spSubParentLDNSeq);
        this.moTypeNameSeq = new SequenceAttribute("moTypeNamea", false);
        this.data.registerPersistentAttr((Attribute)this.moTypeNameSeq);
        this.identitySeq = new SequenceAttribute("identity", false);
        this.data.registerPersistentAttr((Attribute)this.identitySeq);
        this.reservedBy = new SequenceAttribute("reservedBy", false);
        this.reservedBy.setValue(new Attribute[0]);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.data.setRevision(14100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public PiuTypeMoImpl(MoData moData) throws MoAccessException {
        super(moData.getLocalDistinguishedName());
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"PiuTypeMoImpl(MoData recoveredData)", (String)("recoveredData: " + moData));
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(14100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("defAllowedSeqRestarts");
        moDataRecoveryHelper.assertAttribute("productNumber");
        moDataRecoveryHelper.assertAttribute("productRevision");
        moDataRecoveryHelper.assertAttribute("productName");
        moDataRecoveryHelper.assertAttribute("productInfo");
        moDataRecoveryHelper.assertAttribute("productionDate");
        moDataRecoveryHelper.assertAttribute("normalLowTempAirFlow");
        moDataRecoveryHelper.assertAttribute("normalHighTempAirFlow");
        moDataRecoveryHelper.assertAttribute("noiseReducedLowTempAirFlow");
        moDataRecoveryHelper.assertAttribute("noiseReducedHighTempAirFlow");
        moDataRecoveryHelper.assertAttribute("boardWidth");
        moDataRecoveryHelper.assertAttribute("tag");
        moDataRecoveryHelper.assertAttribute("subParentLDN");
        moDataRecoveryHelper.assertAttribute("spSubParentLDN");
        moDataRecoveryHelper.assertAttribute("programMoTypeName");
        moDataRecoveryHelper.assertAttribute("loadableProcessorName");
        moDataRecoveryHelper.assertAttribute("isInstalled");
        moDataRecoveryHelper.assertAttribute("role");
        moDataRecoveryHelper.assertAttribute("moTypeNamea");
        moDataRecoveryHelper.assertAttribute("identity");
        moDataRecoveryHelper.assertAttribute("lmFilesInstallState");
        moDataRecoveryHelper.assertAttribute("SU_DOM_KEY");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.defAllowedSeqRestarts = (IntegerAttribute)moData.getAttribute("defAllowedSeqRestarts");
        this.productNumber = (StringAttribute)moData.getAttribute("productNumber");
        this.productRevision = (StringAttribute)moData.getAttribute("productRevision");
        this.productName = (StringAttribute)moData.getAttribute("productName");
        this.productInfo = (StringAttribute)moData.getAttribute("productInfo");
        this.productionDate = (StringAttribute)moData.getAttribute("productionDate");
        this.normalLowTempAirFlow = (FloatAttribute)moData.getAttribute("normalLowTempAirFlow");
        this.normalHighTempAirFlow = (FloatAttribute)moData.getAttribute("normalHighTempAirFlow");
        this.noiseReducedLowTempAirFlow = (FloatAttribute)moData.getAttribute("noiseReducedLowTempAirFlow");
        this.noiseReducedHighTempAirFlow = (FloatAttribute)moData.getAttribute("noiseReducedHighTempAirFlow");
        this.boardWidth = (IntegerAttribute)moData.getAttribute("boardWidth");
        this.tagSeq = (SequenceAttribute)moData.getAttribute("tag");
        this.subParentLDNSeq = (SequenceAttribute)moData.getAttribute("subParentLDN");
        this.spSubParentLDNSeq = (SequenceAttribute)moData.getAttribute("spSubParentLDN");
        this.programMoTypeNameSeq = (SequenceAttribute)moData.getAttribute("programMoTypeName");
        this.loadableProcessorNameSeq = (SequenceAttribute)moData.getAttribute("loadableProcessorName");
        this.isInstalled = (BooleanAttribute)moData.getAttribute("isInstalled");
        this.piuRole = (IntegerAttribute)moData.getAttribute("role");
        this.moTypeNameSeq = (SequenceAttribute)moData.getAttribute("moTypeNamea");
        this.identitySeq = (SequenceAttribute)moData.getAttribute("identity");
        this.loadModuleFilesInstallState = (IntegerAttribute)moData.getAttribute("lmFilesInstallState");
        this.mySU_DOM_Key = (StructAttribute)this.data.getAttribute("SU_DOM_KEY");
        this.reservedBy = (SequenceAttribute)this.data.getAttribute("reservedBy");
        this.optimizeProductData();
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"delete(Coordinator context)", (String)("context: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.reservedBy.isEmpty()) {
            throw new MoReservedNotDeletableException("PiuType");
        }
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"reserve( ManagedObject userId, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PiuType", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"release( ManagedObject userId, Coordinator context )", (String)("userId: " + managedObject + "\n\tcontext: " + Lib.toString((Coordinator)coordinator)));
        this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"PiuType", (MoData)this.data, (SequenceAttribute)this.reservedBy);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getReservedBy (Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Attribute[] attributeArray = this.reservedBy.getValue(coordinator);
        ManagedObject[] managedObjectArray = new ManagedObject[this.reservedBy.size()];
        for (int i = 0; i < this.reservedBy.size(); ++i) {
            managedObjectArray[i] = ((ReferenceAttribute)attributeArray[i]).getValue(coordinator);
        }
        return managedObjectArray;
    }

    public String[] getSupportedVersions() {
        return SUPPORTED_VERSIONS;
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getUserLabel(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"PiuType", (int)128, (int)0);
        UpgradeTrace.debug(this.getClass(), (int)72, (String)"setUserLabel(String value, Coordinator c)", (String)("value: " + string + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getDefAllowedSeqRestarts(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.defAllowedSeqRestarts.getValue(coordinator);
        }
        return this.getPiuTypeReadProxyInterface().getDefAllowedSeqRestartsValue((PiuTypeMoSU_Access)this);
    }

    public void setDefAllowedSeqRestartsForUpgrade(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.defAllowedSeqRestarts.setValue(n);
    }

    public Struct getProductData(Coordinator coordinator) throws MoAccessException {
        ProductDataInterface productDataInterface;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductData(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[5];
        if (this.mySU_DOM_Key.isEmpty()) {
            objectArray[0] = this.productNumber.getValue(coordinator);
            objectArray[1] = this.productRevision.getValue(coordinator);
            objectArray[2] = this.productName.getValue(coordinator);
            objectArray[3] = this.productInfo.getValue(coordinator);
            objectArray[4] = this.productionDate.getValue(coordinator);
        } else {
            productDataInterface = this.getPiuTypeReadProxyInterface().getProductData((PiuTypeMoSU_Access)this);
            objectArray[0] = productDataInterface.getNumberRaw();
            objectArray[1] = productDataInterface.getRevisionRaw();
            objectArray[2] = productDataInterface.getName();
            objectArray[3] = productDataInterface.getInformation();
            objectArray[4] = productDataInterface.getDate();
            if (objectArray[3] == null) {
                objectArray[3] = EMPTY_STRING;
            }
            if (objectArray[4] == null) {
                objectArray[4] = EMPTY_STRING;
            }
        }
        productDataInterface = new StructImpl(adminProductDataNames, objectArray);
        return productDataInterface;
    }

    public String getProductionDate(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.productionDate.getValue(coordinator);
        }
        String string = this.getPiuTypeReadProxyInterface().getProductData((PiuTypeMoSU_Access)this).getDate();
        if (string != null) {
            return string;
        }
        return EMPTY_STRING;
    }

    public String getProductName(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.productName.getValue(coordinator);
        }
        return this.getPiuTypeReadProxyInterface().getProductData((PiuTypeMoSU_Access)this).getName();
    }

    public String getProductNumber(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductNumber(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.productNumber.getValue(coordinator);
        }
        return this.getPiuTypeReadProxyInterface().getProductData((PiuTypeMoSU_Access)this).getNumberRaw();
    }

    public String getProductRevision(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProductRevision(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.productRevision.getValue(coordinator);
        }
        return this.getPiuTypeReadProxyInterface().getProductData((PiuTypeMoSU_Access)this).getRevisionRaw();
    }

    public String getProductNumberOpt(Coordinator coordinator) throws MoAccessException {
        return this.myProductNumberOpt;
    }

    public String getProductRevisionOpt(Coordinator coordinator) throws MoAccessException {
        return this.myProductRevisionOpt;
    }

    public int getBoardWidth(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getBoardWidth(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.boardWidth.getValue(coordinator);
        }
        return this.getPiuTypeReadProxyInterface().getPiuTypeDataInterface((PiuTypeMoSU_Access)this).getBoardWidth();
    }

    public Struct getAirFlowData(Coordinator coordinator) throws MoAccessException {
        PiuTypeDataInterface piuTypeDataInterface;
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getAirFlowData(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[4];
        if (this.mySU_DOM_Key.isEmpty()) {
            objectArray[0] = new Float(this.normalLowTempAirFlow.getValue(coordinator));
            objectArray[1] = new Float(this.normalHighTempAirFlow.getValue(coordinator));
            objectArray[2] = new Float(this.noiseReducedLowTempAirFlow.getValue(coordinator));
            objectArray[3] = new Float(this.noiseReducedHighTempAirFlow.getValue(coordinator));
        } else {
            piuTypeDataInterface = this.getPiuTypeReadProxyInterface().getPiuTypeDataInterface((PiuTypeMoSU_Access)this);
            objectArray[0] = piuTypeDataInterface.getNormalLowTempAirFlow();
            objectArray[1] = piuTypeDataInterface.getNormalHighTempAirFlow();
            objectArray[2] = piuTypeDataInterface.getNoiseReducedLowTempAirFlow();
            objectArray[3] = piuTypeDataInterface.getNoiseReducedHighTempAirFlow();
            if (objectArray[0] == null) {
                objectArray[0] = new Float(250.0f);
            }
            if (objectArray[1] == null) {
                objectArray[1] = new Float(400.0f);
            }
            if (objectArray[2] == null) {
                objectArray[2] = new Float(250.0f);
            }
            if (objectArray[3] == null) {
                objectArray[3] = new Float(400.0f);
            }
        }
        piuTypeDataInterface = new StructImpl(airFlowDataNames, objectArray);
        return piuTypeDataInterface;
    }

    public Struct[] getProgramConfiguration(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProgramConfiguration(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.createProgramConfigurationData(coordinator);
        }
        return this.createProgramConfigurationDataSU_DOM();
    }

    public ProgramConfigurationInformations getProgramConfigurationInformation(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getProgramConfigurationInformation(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            Struct[] structArray = this.createProgramConfigurationData(coordinator);
            ProgramConfigurationInformations programConfigurationInformations = new ProgramConfigurationInformations();
            for (int i = 0; i < structArray.length; ++i) {
                programConfigurationInformations.add(new ProgramConfigurationInformation(new Integer(this.getProgramConfigurationTag(structArray[i])), this.getProgramConfigurationProgramMoTypeName(structArray[i]), this.getProgramConfigurationProgramsSubParentLDN(structArray[i])));
            }
            return programConfigurationInformations;
        }
        return this.createProgramConfigurationInformationSU_DOM();
    }

    private ProgramConfigurationInformations createProgramConfigurationInformationSU_DOM() throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createProgramConfigurationInformationSU_DOM( )");
        ProgramConfigurationInformations programConfigurationInformations = new ProgramConfigurationInformations();
        Collection collection = this.getPiuTypeReadProxyInterface().getProgramConfigurationInterfaces((PiuTypeMoSU_Access)this);
        Iterator iterator = collection.iterator();
        ProgramConfigurationInterface programConfigurationInterface = null;
        while (iterator.hasNext()) {
            programConfigurationInterface = (ProgramConfigurationInterface)iterator.next();
            String string = programConfigurationInterface.getSubParentLdn();
            if (string == null) {
                string = EMPTY_STRING;
            }
            programConfigurationInformations.add(new ProgramConfigurationInformation(programConfigurationInterface.getTag(), programConfigurationInterface.getMoTypeName(), string));
        }
        return programConfigurationInformations;
    }

    public String getProgramConfigurationTag(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("tag");
        }
        return null;
    }

    public String getProgramConfigurationProgramMoTypeName(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("programMoTypeName");
        }
        return null;
    }

    public String getProgramConfigurationProgramsSubParentLDN(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("subParentLDN");
        }
        return null;
    }

    public Struct[] getMoConfiguration(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getMoConfiguration(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.createMoConfigurationData(coordinator);
        }
        return this.createMoConfigurationDataSU_DOM();
    }

    public String getMoConfigurationMoIdentity(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("identity");
        }
        return null;
    }

    public String getMoConfigurationHardwareMoTypeName(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("moTypeNamea");
        }
        return null;
    }

    public String getMoConfigurationHardwaresSubParentLDN(Struct struct) throws MoAccessException {
        if (struct != null) {
            return (String)struct.getValue("spSubParentLDN");
        }
        return null;
    }

    public int getRole(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getRole(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            return this.piuRole.getValue(coordinator);
        }
        return this.getPiuTypeReadProxyInterface().getRole((PiuTypeMoSU_Access)this);
    }

    public void setRoleForUpgrade(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.piuRole.setValue(n);
    }

    public void activatePiuTypeMo(String string, String string2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"activatePiuTypeMo(String aProductNumber, String aProductRevision, Coordinator c)", (String)("aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            StringAttribute stringAttribute = null;
            stringAttribute = new StringAttribute("productNumber", false, string);
            this.mySU_DOM_Key.addElement((Attribute)stringAttribute);
            stringAttribute = new StringAttribute("productRevision", false, string2);
            this.mySU_DOM_Key.addElement((Attribute)stringAttribute);
            this.defAllowedSeqRestarts.setValue(0);
            ((StringAttribute)this.data.getAttribute("productNumber")).setValue(EMPTY_STRING);
            ((StringAttribute)this.data.getAttribute("productRevision")).setValue(EMPTY_STRING);
            ((StringAttribute)this.data.getAttribute("productName")).setValue(EMPTY_STRING);
            ((StringAttribute)this.data.getAttribute("productInfo")).setValue(EMPTY_STRING);
            ((StringAttribute)this.data.getAttribute("productionDate")).setValue(EMPTY_STRING);
            ((FloatAttribute)this.data.getAttribute("normalLowTempAirFlow")).setValue(0.0f);
            ((FloatAttribute)this.data.getAttribute("normalHighTempAirFlow")).setValue(0.0f);
            ((FloatAttribute)this.data.getAttribute("noiseReducedLowTempAirFlow")).setValue(0.0f);
            ((FloatAttribute)this.data.getAttribute("noiseReducedHighTempAirFlow")).setValue(0.0f);
            ((IntegerAttribute)this.data.getAttribute("boardWidth")).setValue(0);
            ((IntegerAttribute)this.data.getAttribute("role")).setValue(0);
            ((SequenceAttribute)this.data.getAttribute("tag")).setValue((Attribute[])new StringAttribute[0]);
            ((SequenceAttribute)this.data.getAttribute("subParentLDN")).setValue((Attribute[])new StringAttribute[0]);
            ((SequenceAttribute)this.data.getAttribute("programMoTypeName")).setValue((Attribute[])new StringAttribute[0]);
            ((SequenceAttribute)this.data.getAttribute("loadableProcessorName")).setValue((Attribute[])new StringAttribute[0]);
            ((SequenceAttribute)this.data.getAttribute("spSubParentLDN")).setValue((Attribute[])new StringAttribute[0]);
            ((SequenceAttribute)this.data.getAttribute("moTypeNamea")).setValue((Attribute[])new StringAttribute[0]);
            ((SequenceAttribute)this.data.getAttribute("identity")).setValue((Attribute[])new StringAttribute[0]);
        }
    }

    public void saveDataFromSU_DOM(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"saveDataFromSU_DOM(Coordinator aCoordinator)", (String)("aCoordinator: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.mySU_DOM_Key.isEmpty()) {
            Struct struct = this.getProductData(coordinator);
            ((StringAttribute)this.data.getAttribute("productNumber")).setValue((String)struct.getValue("productNumber"));
            ((StringAttribute)this.data.getAttribute("productRevision")).setValue((String)struct.getValue("productRevision"));
            ((StringAttribute)this.data.getAttribute("productName")).setValue((String)struct.getValue("productName"));
            ((StringAttribute)this.data.getAttribute("productInfo")).setValue((String)struct.getValue("productInfo"));
            ((StringAttribute)this.data.getAttribute("productionDate")).setValue((String)struct.getValue("productionDate"));
            Struct struct2 = this.getAirFlowData(coordinator);
            ((FloatAttribute)this.data.getAttribute("normalLowTempAirFlow")).setValue(((Float)struct2.getValue("normalLowTempAirFlow")).floatValue());
            ((FloatAttribute)this.data.getAttribute("normalHighTempAirFlow")).setValue(((Float)struct2.getValue("normalHighTempAirFlow")).floatValue());
            ((FloatAttribute)this.data.getAttribute("noiseReducedLowTempAirFlow")).setValue(((Float)struct2.getValue("noiseReducedLowTempAirFlow")).floatValue());
            ((FloatAttribute)this.data.getAttribute("noiseReducedHighTempAirFlow")).setValue(((Float)struct2.getValue("noiseReducedHighTempAirFlow")).floatValue());
            this.defAllowedSeqRestarts.setValue(this.getDefAllowedSeqRestarts(coordinator));
            ((IntegerAttribute)this.data.getAttribute("boardWidth")).setValue(this.getBoardWidth(coordinator));
            ((IntegerAttribute)this.data.getAttribute("role")).setValue(this.getRole(coordinator));
            Struct[] structArray = this.getMoConfiguration(coordinator);
            for (int i = 0; i < structArray.length; ++i) {
                this.addMoConfiguration(structArray[i], coordinator);
            }
            Struct[] structArray2 = this.getProgramConfiguration(coordinator);
            for (int i = 0; i < structArray2.length; ++i) {
                this.addProgramConfiguration(structArray2[i], coordinator);
            }
            Attribute[] attributeArray = this.mySU_DOM_Key.getElements(coordinator);
            for (int i = 0; i < attributeArray.length; ++i) {
                this.mySU_DOM_Key.removeElement(attributeArray[i]);
            }
        } else {
            UpgradeTrace.debug(this.getClass(), (int)70, (String)"saveDataFromSU_DOM(Coordinator aCoordinator)", (String)"No need to transfer data from SU DOM to MoData since already stored in MoData i.e. mySU_DOM_Key is empty");
        }
    }

    public boolean getIsInstalled(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getIsInstalled(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.isInstalled.getValue(coordinator);
    }

    public void setIsInstalled(boolean bl, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setIsInstalled(boolean value, Coordinator c)", (String)("value: " + bl + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.isInstalled.setValue(bl);
    }

    public void addProgramConfiguration(Struct struct, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addProgramConfiguration(Struct programConfiguration, Coordinator c)", (String)("programConfiguration: " + struct + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (struct.size() > 4) {
            throw new NoSuchFieldException("Unknown field in struct");
        }
        if (struct.size() < 3) {
            throw new NoSuchFieldException("Mandatory field missing in Struct");
        }
        StringAttribute stringAttribute = new StringAttribute(EMPTY_STRING, false, (String)struct.getValue("tag"));
        StringAttribute stringAttribute2 = new StringAttribute(EMPTY_STRING, false, (String)struct.getValue("subParentLDN"));
        StringAttribute stringAttribute3 = new StringAttribute(EMPTY_STRING, false, (String)struct.getValue("programMoTypeName"));
        StringAttribute stringAttribute4 = new StringAttribute(EMPTY_STRING, false);
        String string = (String)struct.getValue("loadableProcessorName");
        if (string != null) {
            stringAttribute4.setValue(string);
        } else {
            stringAttribute4.setValue(EMPTY_STRING);
        }
        this.tagSeq.addElement((Attribute)stringAttribute);
        this.subParentLDNSeq.addElement((Attribute)stringAttribute2);
        this.programMoTypeNameSeq.addElement((Attribute)stringAttribute3);
        this.loadableProcessorNameSeq.addElement((Attribute)stringAttribute4);
    }

    public void addMoConfiguration(Struct struct, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"addMoConfiguration(Struct moConfiguration, Coordinator c)", (String)("moConfiguration: " + Lib.toString((Struct)struct) + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (struct.size() > 4) {
            throw new NoSuchFieldException("Unknown field in struct");
        }
        if (struct.size() < 3) {
            throw new NoSuchFieldException("Mandatory field missing in Struct");
        }
        StringAttribute stringAttribute = new StringAttribute(EMPTY_STRING, false, (String)struct.getValue("spSubParentLDN"));
        StringAttribute stringAttribute2 = new StringAttribute(EMPTY_STRING, false, (String)struct.getValue("moTypeNamea"));
        StringAttribute stringAttribute3 = new StringAttribute(EMPTY_STRING, false, (String)struct.getValue("identity"));
        this.spSubParentLDNSeq.addElement((Attribute)stringAttribute);
        this.moTypeNameSeq.addElement((Attribute)stringAttribute2);
        this.identitySeq.addElement((Attribute)stringAttribute3);
    }

    public String getType() {
        return "PiuType";
    }

    public boolean matchPiuTypeMo(String string, String string2, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"matchPiuTypeMo(String prodNo, String prodRev, Coordinator c)", (String)("prodNo: " + string + "\n\tprodRev: " + string2 + "\n\tthis productNumber: " + this.getProductNumber(coordinator) + "\n\tthis productRevision: " + this.getProductRevision(coordinator) + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return PiuTypeMoImpl.pidcompare(this.getProductRevision(coordinator), string2) && PiuTypeMoImpl.pidcompare(this.getProductNumber(coordinator), string);
    }

    private static Struct checkAndGetProductData(AttrList attrList, boolean bl) throws MoAccessException {
        Object[] objectArray;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"checkAndGetProductData( AttrList attributes, boolean anIsCheckOfExistingRevisionsNeeded )", (String)("attributes: " + Lib.toString((AttrList)attrList) + "\n\tanIsCheckOfExistingRevisionsNeeded: " + bl));
        Struct struct = null;
        int n = attrList.indexOf("productData");
        if (n == -1) {
            throw new AttrMissingAtCreateException("PiuType", "productData");
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("productData", "PiuType");
        }
        struct = (Struct)attrList.getValue(n);
        if (struct.size() > 5) {
            throw new NoSuchFieldException("Unknown field in struct");
        }
        PiuTypeMoImpl.validateAdministrativeProductData(struct);
        try {
            string5 = (String)struct.getValue("productRevision");
            string4 = (String)struct.getValue("productNumber");
            string3 = (String)struct.getValue("productName");
            if (string5 == null || string4 == null || string3 == null) {
                throw new AttrMissingAtCreateException("productData", "PiuType");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AttrMissingAtCreateException("productData", "PiuType");
        }
        try {
            string2 = (String)struct.getValue("productInfo");
            if (string2 == null) {
                string2 = EMPTY_STRING;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string2 = EMPTY_STRING;
        }
        try {
            string = (String)struct.getValue("productionDate");
            if (string == null) {
                string = EMPTY_STRING;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            string = EMPTY_STRING;
        }
        if (!string5.equals("*")) {
            objectArray = new StringCharacterIterator(string5);
            char c = objectArray.first();
            if (!(c == 'R' | c == 'r' | c == 'P' | c == 'p')) {
                throw new ValueOutOfRangeException("productRevision", "PiuType");
            }
            c = objectArray.next();
            if (!Character.isDigit(c)) {
                throw new ValueOutOfRangeException("productRevision", "PiuType");
            }
        }
        if (bl) {
            objectArray = (MO_HandlerFactoryAccess)ServiceLocatorFacade.getRepository().getService(MO_HandlerFactoryAccess.class);
            PiuTypeMO_HandlerAccess piuTypeMO_HandlerAccess = objectArray.getPiuTypeMO_HandlerAccess();
            piuTypeMO_HandlerAccess.verifyThatProductNumberAndRevisionIsAllowed(string4, string5);
        }
        objectArray = new String[]{string4, string5, string3, string2, string};
        struct = new StructImpl(adminProductDataNames, objectArray);
        attrList.removeElementAt(n);
        return struct;
    }

    private static void checkDateFormat(String string) throws ValueOutOfRangeException {
        if (string.length() == 0) {
            return;
        }
        if (string.length() != 5 && string.length() != 8) {
            throw new ValueOutOfRangeException("productionDate", "PiuType");
        }
        if (string.length() == 8) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) continue;
                throw new ValueOutOfRangeException("productionDate", "PiuType");
            }
        } else {
            char c = string.charAt(2);
            if (c != 'w' && c != 'W') {
                throw new ValueOutOfRangeException("productionDate", "PiuType");
            }
            for (int i = 0; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (Character.isDigit(c2) || i == 2) continue;
                throw new ValueOutOfRangeException("productionDate", "PiuType");
            }
        }
    }

    private static Struct checkAndGetAirFlowData(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"checkAndGetAirFlowData(AttrList attributes)", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        Struct struct = null;
        int n = attrList.indexOf("airFlowData");
        if (n == -1) {
            Object[] objectArray = new Object[]{new Float(250.0f), new Float(400.0f), new Float(250.0f), new Float(400.0f)};
            struct = new StructImpl(airFlowDataNames, objectArray);
            return struct;
        }
        if (!(attrList.getValue(n) instanceof Struct)) {
            throw new WrongAttributeTypeException("airFlowData", "PiuType");
        }
        struct = (Struct)attrList.getValue(n);
        if (struct.size() != 4) {
            throw new NoSuchFieldException("Unknown field in struct");
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = struct.getValue("normalLowTempAirFlow");
        Float f = (Float)struct.getValue("normalLowTempAirFlow");
        int n2 = f.intValue();
        if (n2 < 0) {
            throw new ValueOutOfRangeException("normalLowTempAirFlow", "PiuType");
        }
        objectArray[1] = struct.getValue("normalHighTempAirFlow");
        Float f2 = (Float)struct.getValue("normalHighTempAirFlow");
        int n3 = f2.intValue();
        if (n3 < 0) {
            throw new ValueOutOfRangeException("normalHighTempAirFlow", "PiuType");
        }
        objectArray[2] = struct.getValue("noiseReducedLowTempAirFlow");
        Float f3 = (Float)struct.getValue("noiseReducedLowTempAirFlow");
        int n4 = f3.intValue();
        if (n4 < 0) {
            throw new ValueOutOfRangeException("noiseReducedLowTempAirFlow", "PiuType");
        }
        objectArray[3] = struct.getValue("noiseReducedHighTempAirFlow");
        Float f4 = (Float)struct.getValue("noiseReducedHighTempAirFlow");
        int n5 = f4.intValue();
        if (n5 < 0) {
            throw new ValueOutOfRangeException("noiseReducedHighTempAirFlow", "PiuType");
        }
        struct = new StructImpl(airFlowDataNames, objectArray);
        attrList.removeElementAt(n);
        return struct;
    }

    private static int checkAndGetBoardWidth(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"checkAndGetBoardWidth( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = -1;
        int n2 = attrList.indexOf("boardWidth");
        if (n2 == -1) {
            throw new AttrMissingAtCreateException("PiuType", "boardWidth");
        }
        if (!(attrList.getValue(n2) instanceof Integer)) {
            throw new WrongAttributeTypeException("boardWidth", "PiuType");
        }
        n = (Integer)attrList.getValue(n2);
        if (n < 0) {
            throw new ValueOutOfRangeException("boardWidth", "PiuType");
        }
        attrList.removeElementAt(n2);
        return n;
    }

    private static int checkAndGetRole(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"checkAndGetRole( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        int n = attrList.indexOf("role");
        if (n == -1) {
            throw new AttrMissingAtCreateException("PiuType", "role");
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("role", "PiuType");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 5) {
            throw new ValueOutOfRangeException("role", "PiuType");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static boolean checkAndGetIsInstalled(AttrList attrList) throws MoAccessException {
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"checkAndGetIsInstalled( AttrList attributes )", (String)("attributes: " + Lib.toString((AttrList)attrList)));
        boolean bl = false;
        int n = attrList.indexOf("isInstalled");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("isInstalled", "PiuType");
        }
        bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private Struct[] createProgramConfigurationData(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createProgramConfigurationData(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        int n = this.tagSeq.size();
        Struct[] structArray = new Struct[n];
        Enumeration enumeration = this.tagSeq.elements();
        Enumeration enumeration2 = this.subParentLDNSeq.elements();
        Enumeration enumeration3 = this.programMoTypeNameSeq.elements();
        Enumeration enumeration4 = this.loadableProcessorNameSeq.elements();
        int n2 = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Object[] objectArray = new Object[]{((StringAttribute)enumeration.nextElement()).getValue(coordinator), ((StringAttribute)enumeration2.nextElement()).getValue(coordinator), ((StringAttribute)enumeration3.nextElement()).getValue(coordinator), ((StringAttribute)enumeration4.nextElement()).getValue(coordinator)};
            StructImpl structImpl = new StructImpl(programConfigurationNames, objectArray);
            structArray[n2++] = structImpl;
        }
        return structArray;
    }

    private Struct[] createProgramConfigurationDataSU_DOM() throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createProgramConfigurationDataSU_DOM( )");
        Collection collection = this.getPiuTypeReadProxyInterface().getProgramConfigurationInterfaces((PiuTypeMoSU_Access)this);
        Struct[] structArray = new Struct[collection.size()];
        Iterator iterator = collection.iterator();
        ProgramConfigurationInterface programConfigurationInterface = null;
        int n = 0;
        while (iterator.hasNext()) {
            programConfigurationInterface = (ProgramConfigurationInterface)iterator.next();
            Object[] objectArray = new Object[4];
            objectArray[0] = programConfigurationInterface.getTag().toString();
            objectArray[1] = programConfigurationInterface.getSubParentLdn();
            if (objectArray[1] == null) {
                objectArray[1] = EMPTY_STRING;
            }
            objectArray[2] = programConfigurationInterface.getMoTypeName();
            objectArray[3] = programConfigurationInterface.getExecUnitNameInfo();
            if (objectArray[3] == null) {
                objectArray[3] = EMPTY_STRING;
            }
            StructImpl structImpl = new StructImpl(programConfigurationNames, objectArray);
            structArray[n++] = structImpl;
        }
        return structArray;
    }

    private Struct[] createMoConfigurationData(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createMoConfigurationData(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        int n = this.moTypeNameSeq.size();
        Struct[] structArray = new Struct[n];
        Enumeration enumeration = this.spSubParentLDNSeq.elements();
        Enumeration enumeration2 = this.moTypeNameSeq.elements();
        Enumeration enumeration3 = this.identitySeq.elements();
        int n2 = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Object[] objectArray = new Object[]{((StringAttribute)enumeration.nextElement()).getValue(coordinator), ((StringAttribute)enumeration2.nextElement()).getValue(coordinator), ((StringAttribute)enumeration3.nextElement()).getValue(coordinator)};
            StructImpl structImpl = new StructImpl(moConfigurationNames, objectArray);
            UpgradeTrace.debug((Class)(class$se$ericsson$cello$swmanagement$PiuTypeMoImpl == null ? PiuTypeMoImpl.class$("se.ericsson.cello.swmanagement.PiuTypeMoImpl") : class$se$ericsson$cello$swmanagement$PiuTypeMoImpl), (int)72, (String)"createMoConfigurationData(Coordinator c)", (String)("moConfig[" + n2 + "]: " + structImpl));
            structArray[n2++] = structImpl;
        }
        return structArray;
    }

    private Struct[] createMoConfigurationDataSU_DOM() throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"createMoConfigurationDataSU_DOM( )");
        Collection collection = this.getPiuTypeReadProxyInterface().getMoConfigurationInterfaces((PiuTypeMoSU_Access)this);
        Iterator iterator = collection.iterator();
        Struct[] structArray = new Struct[collection.size()];
        int n = 0;
        MoConfigurationInterface moConfigurationInterface = null;
        while (iterator.hasNext()) {
            moConfigurationInterface = (MoConfigurationInterface)iterator.next();
            Object[] objectArray = new Object[3];
            objectArray[0] = moConfigurationInterface.getSubParentLdn();
            if (objectArray[0] == null) {
                objectArray[0] = EMPTY_STRING;
            }
            objectArray[1] = moConfigurationInterface.getMoTypeName();
            objectArray[2] = moConfigurationInterface.getIdentity();
            StructImpl structImpl = new StructImpl(moConfigurationNames, objectArray);
            UpgradeTrace.debug(this.getClass(), (int)72, (String)"createMoConfigurationDataSU_DOM(Coordinator aCoordinator)", (String)("pidData: " + Lib.toString((Struct)structImpl)));
            structArray[n++] = structImpl;
        }
        return structArray;
    }

    public Struct actionGetMoConfiguration(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionGetMoConfiguration(int index, Coordinator c)", (String)("indexindex: " + n + "\n\tc: " + Lib.toString((Coordinator)coordinator)));
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.mySU_DOM_Key.isEmpty()) {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Enumeration enumeration = this.spSubParentLDNSeq.elements();
            Enumeration enumeration2 = this.moTypeNameSeq.elements();
            Enumeration enumeration3 = this.identitySeq.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement(((StringAttribute)enumeration.nextElement()).getValue(coordinator));
            }
            while (enumeration2.hasMoreElements()) {
                vector2.addElement(((StringAttribute)enumeration2.nextElement()).getValue(coordinator));
            }
            while (enumeration3.hasMoreElements()) {
                vector3.addElement(((StringAttribute)enumeration3.nextElement()).getValue(coordinator));
            }
            if (vector.size() != vector2.size() || vector2.size() != vector3.size() || vector.size() != vector3.size()) {
                throw new InternalConfigurationErrorException("PiuType", "Mismatch between sequence attributes in actionGetMoConfiguration");
            }
            if (n < 0 || n >= vector.size()) {
                throw new InvalidIndexException("PiuType");
            }
            Object[] objectArray = new Object[]{vector.elementAt(n).toString(), vector2.elementAt(n).toString(), vector3.elementAt(n).toString()};
            StructImpl structImpl = new StructImpl(moConfigurationNames, objectArray);
            return structImpl;
        }
        Struct[] structArray = this.createMoConfigurationDataSU_DOM();
        if (n < 0 || n >= structArray.length) {
            throw new InvalidIndexException("PiuType");
        }
        return structArray[n];
    }

    public int actionNumberOfMoConfigurations(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"actionNumberOfMoConfigurations(Coordinator c)", (String)("c: " + Lib.toString((Coordinator)coordinator)));
        Struct[] structArray = this.getMoConfiguration(coordinator);
        int n = structArray.length;
        return n;
    }

    public void setLmFilesInstallStateForUpgrade(int n, Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"setLmFilesInstallStateForUpgrade(int aLoadModuleFilesInstallState, Coordinator c)", (String)("aLoadModuleFilesInstallState: " + n + "c: " + Lib.toString((Coordinator)coordinator)));
        MoAttributeValidator.checkIntegerAttribute((String)"lmFilesInstallState", (int)n, (int)0, (int)2, (String)"PiuType");
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.loadModuleFilesInstallState.setValue(n);
    }

    public int getLmFilesInstallState(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.loadModuleFilesInstallState.getValue(coordinator);
    }

    public static boolean pidcompare(String string, String string2) {
        return string == null ? PiuTypeMoImpl.removeWhiteSpace(string2) == null : (string2 == null ? PiuTypeMoImpl.removeWhiteSpace(string) == null : PiuTypeMoImpl.removeWhiteSpace(string).equalsIgnoreCase(PiuTypeMoImpl.removeWhiteSpace(string2)));
    }

    public static String removeWhiteSpace(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (Character.isSpaceChar(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    private static void validateAdministrativeProductData(Struct struct) throws MoAccessException {
        String[] stringArray = struct.getNames();
        String string = EMPTY_STRING;
        UpgradeTrace.debug((Class)PiuTypeMoImpl.class, (int)70, (String)"validateAdministrativeProductData(Struct adminProductData))", (String)("names: " + Lib.toString((String[])stringArray)));
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase("productInfo")) {
                    if (!struct.getValue("productInfo").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productInfo", "PiuType");
                    }
                    string = (String)struct.getValue("productInfo");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productInfo", (String)"PiuType", (int)13, (int)0);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productionDate")) {
                    if (!struct.getValue("productionDate").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productionDate", "PiuType");
                    }
                    string = (String)struct.getValue("productionDate");
                    PiuTypeMoImpl.checkDateFormat(string);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productName")) {
                    if (!struct.getValue("productName").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productName", "PiuType");
                    }
                    string = (String)struct.getValue("productName");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productName", (String)"PiuType", (int)12, (int)1);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productNumber")) {
                    if (!struct.getValue("productNumber").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productNumber", "PiuType");
                    }
                    string = (String)struct.getValue("productNumber");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productNumber", (String)"PiuType", (int)24, (int)1);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("productRevision")) {
                    if (!struct.getValue("productRevision").getClass().getName().equals("java.lang.String")) {
                        throw new WrongAttributeTypeException("productRevision", "PiuType");
                    }
                    string = (String)struct.getValue("productRevision");
                    MoAttributeValidator.checkStringWithLength((String)string, (String)"productRevision", (String)"PiuType", (int)7, (int)1);
                    continue;
                }
                throw new NoSuchFieldException("PiuType Mo, Unknown field in administrativeProductData " + stringArray[i]);
            }
        }
    }

    public boolean getSU_DOM_Required(Coordinator coordinator) throws MoAccessException {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getSU_DOM_Required(Coordinator aCoordinator)");
        return !this.mySU_DOM_Key.isEmpty();
    }

    private String getSU_DOM_KeyProductNumber() {
        StringAttribute stringAttribute = (StringAttribute)this.mySU_DOM_Key.getElement("productNumber", null);
        return stringAttribute.getValue(null);
    }

    private String getSU_DOM_KeyProductRevision() {
        StringAttribute stringAttribute = (StringAttribute)this.mySU_DOM_Key.getElement("productRevision", null);
        return stringAttribute.getValue(null);
    }

    private PiuTypeReadProxyInterface getPiuTypeReadProxyInterface() throws MoAccessException {
        try {
            return this.getPiuTypeProxyInformation().getPiuTypeReadProxyInterface();
        }
        catch (Throwable throwable) {
            String string = "\n\tSU_DOM_KeyProductNumber: " + this.getSU_DOM_KeyProductNumber() + "\n\tSU_DOM_KeyProductRevision: " + this.getSU_DOM_KeyProductRevision();
            if (throwable instanceof NullPointerException) {
                PiuTypeProxyInformation piuTypeProxyInformation = this.getPiuTypeProxyInformation();
                string = string + "\n\tgetPiuTypeProxyInformation( ) returns " + piuTypeProxyInformation;
                if (piuTypeProxyInformation != null) {
                    PiuTypeReadProxyInterface piuTypeReadProxyInterface = piuTypeProxyInformation.getPiuTypeReadProxyInterface();
                    string = string + "\n\tgetPiuTypeProxyInformation( ).getPiuTypeReadProxyInterface( ) returns " + piuTypeReadProxyInterface;
                }
            }
            UpgradeTrace.error(this.getClass(), (String)"getPiuTypeReadProxyInterface( )", (String)("Throwable caught," + string), (Throwable)throwable);
            throw new SoftwareErrorException(throwable);
        }
    }

    private PiuTypeProxyInformation getPiuTypeProxyInformation() {
        UpgradeTrace.debug(this.getClass(), (int)70, (String)"getPiuTypeProxyInformation()");
        this.myPiuTypeProxyInformation = this.getProxySelectorInterface().getPiuTypeReadProxyInterface(this.getSU_DOM_KeyProductNumber(), this.getSU_DOM_KeyProductRevision(), this.myPiuTypeProxyInformation);
        return this.myPiuTypeProxyInformation;
    }

    private ProxySelectorSwmInterface getProxySelectorInterface() {
        if (this.myProxySelectorInterface == null) {
            this.myProxySelectorInterface = (ProxySelectorSwmInterface)ServiceLocatorFacade.getRepository().getService(ProxySelectorSwmInterface.class);
        }
        return this.myProxySelectorInterface;
    }

    private void optimizeProductData() throws MoAccessException {
        if (this.mySU_DOM_Key.isEmpty()) {
            this.myProductNumberOpt = Lib.optimize((String)this.getProductNumber(null));
            this.myProductRevisionOpt = Lib.optimize((String)this.getProductRevision(null));
            if (UpgradeTrace.valid(this.getClass(), (int)72)) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"optimizeProductData()", (String)("Initial configured i.e. not accessible from SU DOM: myProductNumberOpt: " + this.myProductNumberOpt + " myProductRevisionOpt: " + this.myProductRevisionOpt));
            }
        } else {
            this.myProductNumberOpt = this.getSU_DOM_KeyProductNumber();
            this.myProductRevisionOpt = this.getSU_DOM_KeyProductRevision();
            if (UpgradeTrace.valid(this.getClass(), (int)72)) {
                UpgradeTrace.debug(this.getClass(), (int)72, (String)"optimizeProductData()", (String)("PiuType Mo is accessible via SU DOM: myProductNumberOpt: " + this.myProductNumberOpt + " myProductRevisionOpt: " + this.myProductRevisionOpt));
            }
        }
    }
}

