/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.alarmlog.controller.impl;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import se.ericsson.cello.em.fm.alarmlog.AlarmLog;
import se.ericsson.cello.em.fm.alarmlog.view.impl.AlarmLogView;
import se.ericsson.cello.em.fm.common.config.ifc.LogConfiguration;
import se.ericsson.cello.em.fm.common.config.ifc.PrintingService;
import se.ericsson.cello.em.fm.common.controller.ifc.LogToolController;
import se.ericsson.cello.em.fm.common.details.controller.impl.DetailsController;
import se.ericsson.cello.em.fm.common.model.ifc.SelectedObjectInterface;
import se.ericsson.cello.em.fm.common.model.impl.LogFileParser;
import se.ericsson.cello.em.fm.common.model.impl.NonEditableSortedTableModel;
import se.ericsson.cello.em.fm.common.model.impl.RecordContent;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.FmError;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.utils.impl.TimeConverter;
import se.ericsson.cello.em.fm.common.view.impl.AbstractActions;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.eprops.EKEY;
import se.ericsson.security.launcher.eprops.EProps;
import se.ericsson.security.launcher.eprops.EmasException;
import se.ericsson.security.launcher.util.EmasUtilities;
import se.ericsson.security.utils.EmLogger;

public class AlarmLogController
implements SelectedObjectInterface,
LogToolController,
EKEY {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final Dimension DEFAULT_DIMENSION = new Dimension(800, 500);
    private AlarmLogView view;
    private DetailsController detailsController = null;
    private NonEditableSortedTableModel model;
    private final ToolService toolService;
    private final LogConfiguration logConfiguration;
    private final Launchable alarmLog;
    protected PrintingService printingService = null;

    public AlarmLogController(Launchable launchable, ToolService toolService, LogConfiguration logConfig) {
        this.toolService = toolService;
        this.alarmLog = launchable;
        this.logConfiguration = logConfig;
    }

    public void init() throws EmasException {
        LOG.info("Initializing alarm log controller and view...", new Object[0]);
        this.model = new NonEditableSortedTableModel(FmType.ALARM_LOG);
        SwingUtilities.invokeLater(new GuiThread(Action.CREATE_VIEW));
        try {
            this.processLog();
        }
        catch (EmasException e) {
            e.set(ACTION, (Object)"Processing Alarm Log file");
            throw e;
        }
        SwingUtilities.invokeLater(new GuiThread(Action.UPDATE_TABLE));
    }

    public void bringGuiToFront() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.view.bringToFront();
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.BRING2FRONT));
        }
    }

    public RecordContent getSelectedObject() {
        return this.model.getRow(this.view.getSelectedRow());
    }

    public void disposeDetailWindow() {
        this.detailsController = null;
    }

    public JFrame getView() {
        return this.view == null ? null : this.view.getView();
    }

    public void rowSelected() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processLog() throws EmasException {
        LOG.info("Processing alarm log...", new Object[0]);
        URL xmlURL = null;
        InputStream inputStream = null;
        try {
            xmlURL = this.logConfiguration.getUrlToLogFile();
            LOG.info("Trying to connect to the remote file via: " + xmlURL.toString(), new Object[0]);
            LogFileParser parser = new LogFileParser();
            inputStream = EmasUtilities.getInstance().getInputStreamByUrl(xmlURL);
            NodeList recordContentNodes = parser.getNodeList(inputStream, "RecordContent");
            int nodes = recordContentNodes.getLength();
            for (int i = 0; i < nodes; ++i) {
                Node node = recordContentNodes.item(i);
                RecordContent recordContent = parser.parse(node, FmType.ALARM_LOG);
                if (recordContent.isOk()) {
                    this.model.addRowNoUpdate(recordContent);
                    continue;
                }
                FmError.XML.displayError(this.getView(), null, new Object[0]);
            }
        }
        catch (IOException e) {
            try {
                EProps prop = new EProps();
                prop.set(PROBLEM_USER_LEVEL, (Object)"IO exception when getInputStreamByUrl");
                prop.set(INPUT_FILE, (Object)xmlURL.toExternalForm());
                prop.setUnlessNull(LIKELY_REASON, (Object)this.getLikelyReasonForLogFileException(e));
                throw new EmasException(prop, (Throwable)e);
                catch (Exception e2) {
                    prop = new EProps();
                    prop.set(PROBLEM_USER_LEVEL, (Object)"Failed to read file from the node");
                    prop.set(INPUT_FILE, (Object)xmlURL.toExternalForm());
                    prop.setUnlessNull(LIKELY_REASON, (Object)this.getLikelyReasonForLogFileException(e2));
                    throw new EmasException(prop, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                EmasUtilities.closeInputStream(inputStream);
                throw throwable;
            }
        }
        EmasUtilities.closeInputStream((InputStream)inputStream);
    }

    private String getLikelyReasonForLogFileException(Exception e) {
        if (e instanceof MalformedURLException) {
            return "The path to the input file is incorrect";
        }
        if (e instanceof FileNotFoundException) {
            return "The file is missing on the node, or has wrong permissions";
        }
        if (e instanceof IOException) {
            return "The file is corrupt";
        }
        if (e instanceof ParserConfigurationException) {
            return "The file is not a valid XML file";
        }
        if (e instanceof SAXException) {
            return "The file is not a valid XML file";
        }
        return null;
    }

    private void updateTable() {
        this.view.sortTable();
        this.view.setNoOfAlarms(this.model.getRowCount());
        this.view.setTimeStamp(new TimeConverter().getCurrentTime());
        if (this.alarmLog instanceof AlarmLog) {
            ((AlarmLog)this.alarmLog).sendEmNotification(GuiTestEventTypes.ALARMLOG_UPDATED, null, this);
        }
    }

    private void exit() {
        LOG.info("Closing Alarm Log main window...", new Object[0]);
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.detailsController != null) {
                this.detailsController.exit();
            }
            this.view.disposeWindow();
            this.detailsController = null;
            this.view = null;
            this.alarmLog.exit();
            LOG.info("Alarm Log Tool closed.", new Object[0]);
        } else {
            SwingUtilities.invokeLater(new GuiThread(Action.EXIT));
        }
    }

    class RefreshAction
    extends AbstractActions.AbstractRefreshAction {
        private static final long serialVersionUID = 1L;

        RefreshAction() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmLogController.this.model.removeAllRows();
            try {
                AlarmLogController.this.processLog();
                AlarmLogController.this.updateTable();
            }
            catch (EmasException emasException) {
                // empty catch block
            }
        }
    }

    class PrintAction
    extends AbstractActions.AbstractPrintAction {
        private static final long serialVersionUID = 1L;

        PrintAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.print(AlarmLogController.this.view.getTable(), AlarmLogController.this.toolService);
        }
    }

    class PageSetupAction
    extends AbstractActions.AbstractPageSetupAction {
        private static final long serialVersionUID = 1L;

        PageSetupAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.pageSetup(AlarmLogController.this.view, AlarmLogController.this.toolService);
        }
    }

    class ExportAction
    extends AbstractActions.AbstractExportAction {
        private static final long serialVersionUID = 1L;

        ExportAction() {
        }

        public void actionPerformed(ActionEvent event) {
            super.export(FmType.ALARM_LOG, AlarmLogController.this.view, AlarmLogController.this.model);
        }
    }

    class DetailsAction
    extends AbstractActions.AbstractDetailsAction {
        private static final long serialVersionUID = 1L;

        DetailsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (AlarmLogController.this.detailsController == null) {
                AlarmLogController.this.detailsController = new DetailsController(FmType.ALARM_LOG, AlarmLogController.this, AlarmLogController.this.toolService);
                AlarmLogController.this.detailsController.createView();
            } else {
                AlarmLogController.this.detailsController.refreshView();
            }
        }
    }

    class CloseAction
    extends AbstractActions.AbstractCloseAction {
        private static final long serialVersionUID = 1L;

        CloseAction() {
        }

        public void actionPerformed(ActionEvent event) {
            AlarmLogController.this.exit();
        }
    }

    class WindowClosingListener
    extends WindowAdapter {
        WindowClosingListener() {
        }

        public void windowClosing(WindowEvent e) {
            AlarmLogController.this.exit();
        }
    }

    class GuiThread
    implements Runnable {
        private Action action;

        GuiThread(Action action) {
            this.action = action;
        }

        public void run() {
            switch (this.action) {
                case CREATE_VIEW: {
                    AlarmLogController.this.view = new AlarmLogView(AlarmLogController.this.toolService);
                    AlarmLogController.this.view.init(DEFAULT_DIMENSION);
                    AlarmLogController.this.view.addWindowClosingListener(new WindowClosingListener());
                    AlarmLogController.this.view.addCloseAction(new CloseAction());
                    AlarmLogController.this.view.addDetailsAction(new DetailsAction());
                    AlarmLogController.this.view.addExportAction(new ExportAction());
                    AlarmLogController.this.view.addPageSetupAction(new PageSetupAction());
                    AlarmLogController.this.view.addPrintAction(new PrintAction());
                    AlarmLogController.this.view.addRefreshAction(new RefreshAction());
                    AlarmLogController.this.view.setAlarmLogModel(AlarmLogController.this.model);
                    LOG.info("Alarm log controller and view are initialized.", new Object[0]);
                    break;
                }
                case BRING2FRONT: {
                    AlarmLogController.this.bringGuiToFront();
                    break;
                }
                case EXIT: {
                    AlarmLogController.this.exit();
                    break;
                }
                case UPDATE_TABLE: {
                    AlarmLogController.this.updateTable();
                    break;
                }
                default: {
                    LOG.severe("Unhandled GUI action: " + this.action.name(), new Object[0]);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Action {
        BRING2FRONT,
        CREATE_VIEW,
        EXIT,
        UPDATE_TABLE;

    }
}

