/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.model.impl;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import se.ericsson.cello.em.fm.availability.model.impl.AdditionalData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogRecordEventRow {
    String logRecordTag = "";
    String time = "";
    String eventType = "";
    String eventReason = "";
    private String service = "";
    private String additionalInfo = "";
    private String board = "";
    private String progHw = "";
    private String configurationVersion = "";
    private String upgradePackage = "";
    private ArrayList<AdditionalData> details;

    LogRecordEventRow(String logRecordTag, String service, String time, String eventType, String eventReason, String additionalInfo, String board, String progHw, String configurationVersion, String upgradePackage) {
        this.logRecordTag = logRecordTag;
        this.service = service;
        this.time = time;
        this.eventType = eventType;
        this.eventReason = eventReason;
        this.additionalInfo = additionalInfo;
        this.board = board;
        this.progHw = progHw;
        this.configurationVersion = configurationVersion;
        this.upgradePackage = upgradePackage;
        this.additionalInfo = additionalInfo;
    }

    public String getRecordTag() {
        return this.logRecordTag;
    }

    public Integer getRecordId() {
        int recordTagId = -1;
        String recordTag = this.getRecordTag();
        Matcher matcher = Pattern.compile("(\\d+)").matcher(recordTag);
        if (matcher.find()) {
            recordTagId = Integer.parseInt(matcher.group(1));
        }
        return recordTagId;
    }

    public String getTime() {
        return this.time;
    }

    public String getEvent() {
        return this.eventType;
    }

    public String getEventReason() {
        return this.eventReason;
    }

    public String getAdditionalData(String delimiter, boolean shouldIndent) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.details.size(); ++i) {
            if (i > 0) {
                result.append(delimiter);
            }
            if (shouldIndent) {
                for (int j = 0; j < this.details.get(i).getIndent(); ++j) {
                    result.append("   ");
                }
            }
            result.append(this.details.get(i).getElementName());
            if ("".equals(this.details.get(i).getElementValue())) continue;
            result.append("=" + this.details.get(i).getElementValue());
        }
        return result.toString();
    }

    public String getExportData(String type, String[] colName, boolean shouldIndent) {
        StringBuilder myRowBuilder = new StringBuilder();
        String delimiter = "EXPORT".equals(type) ? ";" : "\n";
        for (int i = 0; i < colName.length; ++i) {
            String columnName = colName[i];
            if (columnName.equals("LogRecord")) {
                if ("".equals(this.getRecordTag())) continue;
                myRowBuilder.append(this.getRecordTag());
                myRowBuilder.append(delimiter);
                continue;
            }
            if (columnName.equals("Time")) {
                if ("".equals(this.getTime())) continue;
                myRowBuilder.append(this.getTime());
                myRowBuilder.append(delimiter);
                continue;
            }
            if (columnName.equals("Type")) {
                if ("".equals(this.getEvent())) continue;
                myRowBuilder.append(this.getEvent());
                myRowBuilder.append(delimiter);
                continue;
            }
            if (columnName.equals("Reason")) {
                if ("".equals(this.getEventReason())) continue;
                myRowBuilder.append(this.getEventReason());
                myRowBuilder.append(delimiter);
                continue;
            }
            if (!columnName.equals("LogRecord") || "".equals(this.getAdditionalData(delimiter, shouldIndent))) continue;
            myRowBuilder.append(this.getAdditionalData(delimiter, shouldIndent));
            myRowBuilder.append(delimiter);
        }
        return myRowBuilder.toString();
    }

    public String getLogRecordTag() {
        return this.logRecordTag;
    }

    public String getService() {
        return this.service;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public String getBoard() {
        return this.board;
    }

    public String getProgHw() {
        return this.progHw;
    }

    public String getConfigurationVersion() {
        return this.configurationVersion;
    }

    public String getUpgradePackage() {
        return this.upgradePackage;
    }

    public void setDetailsInfo(ArrayList<AdditionalData> details) {
        this.details = details;
    }

    public String getDetailsInfo() {
        return this.getAdditionalData("\n", true);
    }
}

