/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.availability.model.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import se.ericsson.cello.em.fm.availability.model.impl.AdditionalData;
import se.ericsson.cello.em.fm.availability.model.impl.LogToolAttributeRecord;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTreeDumper {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;

    private ArrayList<AdditionalData> dumpLoop(ArrayList<AdditionalData> addDataArray, Node node, int indent) {
        String nName = node.getNodeName();
        if (!(nName.equals("year") || nName.equals("month") || nName.equals("day") || nName.equals("hour") || nName.equals("minute") || nName.equals("second") || nName.equals("Unknown"))) {
            switch (node.getNodeType()) {
                case 2: {
                    this.dumpAttributeNode(addDataArray, (Attr)node);
                    break;
                }
                case 1: {
                    this.dumpElement(addDataArray, (Element)node, indent);
                    break;
                }
                case 3: {
                    this.dumpTextNode(addDataArray, (Text)node, indent);
                    break;
                }
            }
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                this.dumpLoop(addDataArray, list.item(i), indent + 1);
            }
        }
        return addDataArray;
    }

    private void dumpAttributeNode(ArrayList<AdditionalData> addDataInstance, Attr node) {
        addDataInstance.get(addDataInstance.size() - 1).setElementValue(node.getName());
    }

    private void dumpElement(ArrayList<AdditionalData> addDataInstance, Element node, int indent) {
        String nodeTagName = node.getTagName().trim();
        if (nodeTagName.equals("TimeStamp") || nodeTagName.equals("NewTime") || nodeTagName.equals("OldTime") || nodeTagName.equals("DownTime")) {
            String dateTimeFromFunction = this.getTimeValue(node);
            addDataInstance.add(new AdditionalData(indent, nodeTagName, dateTimeFromFunction));
        } else {
            addDataInstance.add(new AdditionalData(indent, nodeTagName, ""));
        }
        NamedNodeMap nm = node.getAttributes();
        for (int i = 0; i < nm.getLength(); ++i) {
            this.dumpLoop(addDataInstance, nm.item(i), indent + 1);
        }
    }

    private void dumpTextNode(ArrayList<AdditionalData> addDataList, Text node, int indent) {
        String nodeTextValue = node.getNodeValue().trim();
        if (nodeTextValue != null && nodeTextValue.length() > 0) {
            addDataList.get(addDataList.size() - 1).setElementValue(nodeTextValue);
        }
    }

    public String getLogRecordNumber(Node node) {
        String logRecordTag = "";
        if (null != node) {
            logRecordTag = node.getNodeName();
            NamedNodeMap nm = node.getAttributes();
            for (int i = 0; i < nm.getLength(); ++i) {
                if (!nm.item(i).getNodeName().startsWith("number")) continue;
                logRecordTag = logRecordTag + " " + nm.item(i);
            }
        }
        return logRecordTag;
    }

    public String getTimeValue(Node node) {
        String timeStamp = "";
        StringBuilder dateTimeDataBuf = new StringBuilder();
        Node unknownNode = this.getChildNodeByName(node, "Unknown");
        if (unknownNode == null) {
            dateTimeDataBuf.append(this.getChildNodeValue(node, "year"));
            dateTimeDataBuf.append("-");
            dateTimeDataBuf.append(this.getChildNodeValue(node, "month"));
            dateTimeDataBuf.append("-");
            dateTimeDataBuf.append(this.getChildNodeValue(node, "day"));
            dateTimeDataBuf.append(" ");
            dateTimeDataBuf.append(this.getChildNodeValue(node, "hour"));
            dateTimeDataBuf.append(":");
            dateTimeDataBuf.append(this.getChildNodeValue(node, "minute"));
            dateTimeDataBuf.append(":");
            dateTimeDataBuf.append(this.getChildNodeValue(node, "second"));
            timeStamp = this.getFormatDate(dateTimeDataBuf.toString());
        } else {
            timeStamp = unknownNode.getNodeName();
        }
        return timeStamp.trim();
    }

    String getEventValue(Node node) {
        String result = "";
        if (null != node) {
            result = this.getChildNodeNameForEvent(node, LogToolAttributeRecord.EVENT_TYPES).trim();
        }
        return result;
    }

    String getEventReasonValue(Node node) {
        String result = "";
        if (null != node) {
            result = this.getChildNodeValue(node, "EventReason").trim();
        }
        return result;
    }

    String getChildNodeNameForEvent(Node parentNode, String[] eventNodeNames) {
        int trunc;
        String childNodeName = "";
        NodeList childNodes = parentNode.getChildNodes();
        for (int cnnInc = 0; cnnInc < childNodes.getLength(); ++cnnInc) {
            if (!this.checkIfTypeNodeExists(eventNodeNames, childNodes.item(cnnInc).getNodeName())) continue;
            childNodeName = childNodes.item(cnnInc).getNodeName().trim();
            break;
        }
        String childTruncated = "";
        if (!"".equals(childNodeName) && (trunc = childNodeName.indexOf("Event")) != -1) {
            childTruncated = childNodeName.substring(0, trunc);
        }
        return "".equals(childTruncated) ? childNodeName : childTruncated;
    }

    boolean checkIfTypeNodeExists(String[] inputArray, String searchTerm) {
        boolean eventNode = false;
        for (int i = 0; i < inputArray.length; ++i) {
            if (!inputArray[i].equals(searchTerm)) continue;
            eventNode = true;
            break;
        }
        return eventNode;
    }

    Node getChildNodeByName(Node parentNode, String nodeName) {
        Node childNodeByName = null;
        if (parentNode != null) {
            NodeList childNodes = parentNode.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                if (!childNodes.item(i).getNodeName().equals(nodeName)) continue;
                childNodeByName = childNodes.item(i);
                break;
            }
        }
        return childNodeByName;
    }

    String getChildNodeValue(Node parentNode, String nodeName) {
        String childNodeValue = "";
        NodeList childNodes = parentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals(nodeName)) continue;
            childNodeValue = childNodes.item(i).getTextContent().trim();
        }
        return childNodeValue;
    }

    String getFormatDate(String uTimeStamp) {
        String fTimeStamp = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date d = null;
        try {
            d = dateFormat.parse(uTimeStamp);
            dateFormat.applyPattern("yyyy-MM-dd HH:mm:ss");
            fTimeStamp = dateFormat.format(d);
        }
        catch (Exception e) {
            LOG.info("Data format errorDate format could not be recognized.  " + e.getMessage(), new Object[0]);
            fTimeStamp = "Data format error";
        }
        return fTimeStamp;
    }

    private Node getChildNode(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node nodeTmp = children.item(i);
            if (!nodeTmp.getNodeName().equals(name)) continue;
            return nodeTmp;
        }
        return null;
    }

    public String getConfigurationValue(Node recordContentNode) {
        Node cppCoreChild;
        String result = "";
        if (null != recordContentNode && (cppCoreChild = this.getCPPCoreNodeIdInfo(recordContentNode)) != null) {
            Node test = this.getChildNode(cppCoreChild, "ConfigurationVersion");
            result = test.getFirstChild().getNodeValue();
        }
        return result.trim();
    }

    public String getUpgradePackage(Node recordContentNode) {
        Node cppCoreChild;
        String result = "";
        if (null != recordContentNode && (cppCoreChild = this.getCPPCoreNodeIdInfo(recordContentNode)) != null) {
            Node test = this.getChildNode(cppCoreChild, "UpgradePackage");
            result = test.getFirstChild().getNodeValue();
        }
        return result.trim();
    }

    private Node getCPPCoreNodeIdInfo(Node recordContentNode) {
        Node result = null;
        Node cppCoreChild = this.getChildNodeByName(recordContentNode, "AvailabilityInfo");
        if (cppCoreChild != null) {
            result = this.getChildNode(cppCoreChild, "CppCoreNodeIdentityInfo");
        }
        return result;
    }

    public String getHwProg(Node recordContentNode) {
        StringBuilder result = new StringBuilder();
        if (null != recordContentNode) {
            String hwType;
            Node nodeId;
            Node pid = this.getCPPCoreNodeIdInfo(recordContentNode);
            if (pid != null && (nodeId = this.getChildNodeByName(pid, "NodeIdentity")) != null) {
                result.append(this.getChildNodeValue(nodeId, "Site") + " ");
                result.append(this.getChildNodeValue(nodeId, "LogicalName") + " ");
                result.append(this.getChildNodeValue(nodeId, "ProdNo") + " ");
                result.append(this.getChildNodeValue(nodeId, "ProdRev") + " ");
                result.append(this.getChildNodeValue(nodeId, "ProdName") + " ");
            }
            if ((pid = this.getChildNode(recordContentNode, "HwPid")) != null) {
                result.append(this.getChildNodeValue(pid, "ProdNo") + " ");
                result.append(this.getChildNodeValue(pid, "ProdRev") + " ");
                result.append(this.getChildNodeValue(pid, "ProdName") + " ");
            }
            if ((pid = this.getChildNode(recordContentNode, "SwPid")) != null) {
                result.append(this.getChildNodeValue(pid, "ProdNo "));
                result.append(this.getChildNodeValue(pid, "ProdRev "));
            }
            if (!"".equals(hwType = this.getChildNodeValue(recordContentNode, "HwType"))) {
                result.append(hwType + " ");
            }
            String hwAddress = this.getChildNodeValue(recordContentNode, "HwAddress");
            if (!"".equals(hwType)) {
                result.append(hwAddress);
            }
        }
        return result.toString();
    }

    public String getService(Node recordContentNode) {
        String result = "";
        if (recordContentNode != null) {
            if (this.getChildNodeByName(recordContentNode, "InService") != null) {
                result = "IN";
            } else if (this.getChildNodeByName(recordContentNode, "OutOfService") != null) {
                result = "OUT";
            } else if (this.getChildNodeByName(recordContentNode, "PartiallyOutOfService") != null) {
                result = "PART";
            }
        }
        return result;
    }

    public String getBoardInfo(Node recordContentNode) {
        StringBuilder result = new StringBuilder();
        if (null != recordContentNode) {
            String piuType;
            Node piuAddress = this.getChildNodeByName(recordContentNode, "PiuAddress");
            if (piuAddress != null) {
                result.append(this.getChildNodeValue(piuAddress, "SwitchModuleNumber") + ":");
                result.append(this.getChildNodeValue(piuAddress, "SwitchPortNumber") + ":");
            }
            if ((piuType = this.getChildNodeValue(recordContentNode, "PiuType")) != null && !"".equals(piuType)) {
                result.append(piuType);
            }
        }
        return result.toString().trim();
    }

    public String getAdditionalInfo(Node logRecordNode) {
        String res;
        StringBuilder result = new StringBuilder();
        if (null != logRecordNode) {
            Node logInfo = this.getChildNodeByName(logRecordNode, "LogInfoRecord");
            if (logInfo != null) {
                result.append(this.getLogInfo(logInfo));
            } else {
                Node recordContent = this.getChildNodeByName(logRecordNode, "RecordContent");
                if (recordContent != null) {
                    Node addInfo = this.getChildNodeByName(recordContent, "AdditionalInfo");
                    if (addInfo != null) {
                        result.append(this.getAddInfo(addInfo));
                    }
                    String serviceType = this.getChildNodeValue(recordContent, "ServiceType");
                    String serviceInstance = this.getChildNodeValue(recordContent, "ServiceInstance");
                    if (!"".equals(serviceType)) {
                        result.append("ServiceType=" + serviceType + ",");
                    }
                    if (!"".equals(serviceType)) {
                        result.append("ServiceInstance=" + serviceInstance);
                    }
                }
            }
        }
        if ((res = result.toString()).endsWith(",")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    private String getAddInfo(Node addInfo) {
        Node appLog;
        StringBuilder result = new StringBuilder();
        Node cppCore = this.getChildNodeByName(addInfo, "CppCore");
        if (cppCore != null) {
            result.append(this.dumpAdditionalInfo(cppCore));
        }
        if ((appLog = this.getChildNodeByName(addInfo, "AppLog")) != null) {
            result.append(this.dumpAdditionalInfo(appLog));
        }
        return result.toString().trim();
    }

    private String dumpAdditionalInfo(Node addInfoChild) {
        StringBuilder result = new StringBuilder();
        NodeList children = addInfoChild.getChildNodes();
        StringBuilder textNodes = new StringBuilder();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() == 3) {
                String value = node.getTextContent().trim();
                if ("".equals(value)) continue;
                textNodes.append(value);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("CppCoreNodeDown")) {
                String downTime = this.getNodeDownTime(node);
                if ("".equals(downTime)) continue;
                result.append(downTime + ",");
                continue;
            }
            if (node.hasChildNodes()) {
                Node child = node.getFirstChild();
                String value = child.getNodeValue();
                if (value == null || value.equals("")) continue;
                result.append(value + ",");
                continue;
            }
            result.append(node.getNodeName() + ",");
        }
        if (!"".equals(textNodes.toString())) {
            result.append(textNodes.toString() + ",");
        }
        return result.toString().trim();
    }

    private String getNodeDownTime(Node coreDown) {
        StringBuilder result = new StringBuilder();
        Node downTime = this.getChildNodeByName(coreDown, "DownTime");
        if (downTime != null) {
            Node nodeUnknown = this.getChildNodeByName(downTime, "Unknown");
            if (nodeUnknown != null) {
                result.append(nodeUnknown.getNodeName());
            } else {
                result.append(this.getTimeValue(downTime));
            }
        }
        return result.toString().trim();
    }

    private String getLogInfo(Node logInfo) {
        StringBuilder result = new StringBuilder();
        Node cppCoreTimeChanged = this.getChildNodeByName(logInfo, "CppCoreTimeChange");
        if (cppCoreTimeChanged != null) {
            Node oldTime = this.getChildNodeByName(cppCoreTimeChanged, "OldTime");
            Node newTime = this.getChildNodeByName(cppCoreTimeChanged, "NewTime");
            if (oldTime != null) {
                result.append("OldTime=" + this.getTimeValue(oldTime) + ",");
            }
            if (newTime != null) {
                result.append("NewTime=" + this.getTimeValue(newTime));
            }
        }
        return result.toString();
    }

    public ArrayList<AdditionalData> getDetailsInfo(Node logRecordNode) {
        ArrayList<AdditionalData> result = new ArrayList<AdditionalData>();
        if (null != logRecordNode) {
            this.dumpLoop(result, logRecordNode, 0);
        }
        return result;
    }
}

