/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.details.view.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import se.ericsson.cello.em.fm.common.config.ifc.Configuration;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.view.impl.Menu;
import se.ericsson.security.utils.EmLogger;

public class DetailsView
extends JPanel {
    private static final EmLogger LOG = EmLogger.TROUBLE_SHOOTING;
    private static final String ADDITIONAL_WINDOW_TITLE = " Details";
    private static final long serialVersionUID = -7146993970763166093L;
    private static final Dimension DEFAULT_DIMENSION = new Dimension(600, 600);
    private JDialog view;
    private JPanel contentPanel = new JPanel();
    private JPanel buttonPanel = new JPanel();
    private BorderLayout borderLayout = new BorderLayout();
    private FlowLayout contentLayout = new FlowLayout();
    private FlowLayout buttonsLayout = new FlowLayout();
    private JEditorPane content;
    private JLabel contentLabel = new JLabel();
    private JButton closeButton = new JButton();
    private JButton helpButton = new JButton();
    private JPopupMenu copyPopupMenu = new JPopupMenu();
    private JMenuItem copyMenuItem = new JMenuItem();
    private Point location;
    private Dimension size;
    private ToolService toolService;

    public DetailsView(ToolService toolService, Point location, Dimension size) {
        this.toolService = toolService;
        this.location = location;
        this.size = size;
    }

    public void layoutWindow(JFrame owner) {
        this.view = new JDialog(owner);
        Configuration configuration = this.toolService.getConfiguration();
        this.view.setTitle(configuration.getTitleForWindow() + ADDITIONAL_WINDOW_TITLE);
        if (this.location != null) {
            this.view.setLocation(this.location);
        }
        if (this.size == null) {
            this.view.setSize(DEFAULT_DIMENSION);
        } else {
            this.view.setSize(this.size);
        }
        this.view.setContentPane(this);
        this.setLayout(this.borderLayout);
        this.contentLayout.setAlignment(0);
        this.contentLabel.setText("Additional details");
        this.contentLabel.setForeground(Color.black);
        this.contentPanel.setLayout(this.contentLayout);
        this.contentPanel.add((Component)this.contentLabel, null);
        this.add((Component)this.contentPanel, "North");
        this.content = new JEditorPane("text/html", " ");
        this.content.setEditable(false);
        this.content.setForeground(Color.black);
        this.content.setBackground(this.contentPanel.getBackground());
        JScrollPane scrollPane = new JScrollPane(this.content, 20, 30);
        this.add((Component)scrollPane, "Center");
        this.buttonsLayout.setAlignment(2);
        this.buttonPanel.setLayout(this.buttonsLayout);
        this.buttonPanel.add((Component)this.closeButton, null);
        this.buttonPanel.add((Component)this.helpButton, null);
        this.add((Component)this.buttonPanel, "South");
        this.closeButton.requestFocus();
        this.copyPopupMenu.add(this.copyMenuItem);
        this.copyPopupMenu.setEnabled(true);
    }

    public void tidyUp() {
        try {
            Field[] fields = this.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!(!Modifier.isFinal(field.getModifiers()) & !field.getType().isPrimitive())) continue;
                fields[i].set(this, null);
            }
        }
        catch (Throwable t) {
            LOG.info("Exception while closing Details window.", t);
        }
    }

    public void addTextAreaMouseListener(MouseAdapter listener) {
        this.content.addMouseListener(listener);
    }

    public void addCloseAction(Action action) {
        this.closeButton.setAction(action);
    }

    public void addCopyAction(Action action) {
        this.copyMenuItem.setAction(action);
    }

    public void addHelpAction(Action action) {
        this.helpButton.setAction(action);
        this.helpButton.setText(Menu.HELP.TEXT);
    }

    public void addWindowClosingListener(WindowAdapter listener) {
        this.view.addWindowListener(listener);
    }

    public void bringToFront() {
        this.view.toFront();
        this.view.requestFocus();
    }

    public void disposeWindow() {
        if (this.view != null) {
            this.view.setVisible(false);
            this.view.dispose();
            this.view = null;
        }
    }

    public String getSelectedText() {
        return this.content.getSelectedText();
    }

    public void showContent(String text) {
        this.content.setText(text);
        this.content.setCaretPosition(0);
        this.view.setVisible(true);
    }

    public void enableCopyPopupMenu(boolean enable) {
        this.copyMenuItem.setEnabled(enable);
    }

    public void showCopyPopupMenu(MouseEvent e) {
        this.copyPopupMenu.show(this.content, (int)e.getPoint().getX(), (int)e.getPoint().getY());
    }

    public Point getLocation() {
        return this.view.getLocation();
    }

    public Dimension getSize() {
        return this.view.getSize();
    }
}

