/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.model.impl;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.em.fm.common.model.impl.TableMap;
import se.ericsson.cello.em.fm.common.view.impl.SortedTable;

public class SortedTableModel
extends TableMap {
    private static final long serialVersionUID = 1L;
    private int[] indexes;
    private int indexesLength = 0;
    private Vector<Integer> sortingColumns = new Vector();
    private ListMouseListener listMouseListener = null;
    private JTableHeader tableHeader = null;
    private SortedTable table;
    private boolean setSortOnRowInsertDelete = false;
    private int clickedColumn = 0;
    private boolean ascending = true;

    public SortedTableModel(TableModel model) {
        this.setModel(model);
    }

    void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public int getIndex(int row) {
        if (row < this.indexesLength && row >= 0) {
            return this.indexes[row];
        }
        throw new ArrayIndexOutOfBoundsException(row + "not in 0.." + (this.indexesLength - 1));
    }

    public int getPresentedIndex(int originalRow) {
        for (int i = 0; i < this.indexesLength; ++i) {
            if (originalRow != this.indexes[i]) continue;
            int presentedRow = i;
            return presentedRow;
        }
        throw new ArrayIndexOutOfBoundsException(originalRow + " not in 0.." + (this.indexesLength - 1));
    }

    private int compareRowsByColumn(int r1, int r2, int column) {
        Object object2;
        Object object1 = this.model.getValueAt(r1, column);
        if (object1 == (object2 = this.model.getValueAt(r2, column))) {
            return 0;
        }
        if (object1 == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object1 instanceof Comparable) {
            try {
                return ((Comparable)object1).compareTo(object2);
            }
            catch (ClassCastException e) {
                return object1.toString().compareTo(object2.toString());
            }
        }
        if (object1.getClass() == object2.getClass() && object1.getClass() == Integer.class) {
            return ((Integer)object1).compareTo((Integer)object2);
        }
        if (object1.getClass() == object2.getClass() && object1.getClass() == Boolean.class) {
            if (((Boolean)object1).equals(object2)) {
                return 0;
            }
            if (((Boolean)object1).booleanValue()) {
                return 1;
            }
            return -1;
        }
        return object1.toString().compareTo(object2.toString());
    }

    private int compare(int ro1, int ro2) {
        for (int layer = 0; layer < this.sortingColumns.size(); ++layer) {
            Integer columns = this.sortingColumns.elementAt(layer);
            int answer = this.compareRowsByColumn(ro1, ro2, columns);
            if (answer == 0) continue;
            return this.ascending ? answer : -answer;
        }
        return 0;
    }

    private void reallocateIndexes() {
        int rowsCount = this.model.getRowCount();
        if (this.indexes == null || this.indexes.length < rowsCount) {
            this.indexes = new int[rowsCount];
        }
        for (int ro = 0; ro < rowsCount; ++ro) {
            this.indexes[ro] = ro;
        }
        this.indexesLength = rowsCount;
    }

    public void doSort() {
        boolean temp = this.setSortOnRowInsertDelete;
        this.setSortOnRowInsertDelete = false;
        int column = 0;
        if (!this.sortingColumns.isEmpty()) {
            column = this.sortingColumns.elementAt(0);
        }
        this.sortByColumn(column);
        this.setSortOnRowInsertDelete = temp;
    }

    public void tableChanged(TableModelEvent e) {
        int selectedRow = -1;
        int[] selectedRows = null;
        if (this.table != null) {
            selectedRow = this.table.getOriginalSelectedRow();
            selectedRows = this.table.getOriginalSelectedRows();
        }
        if (e.getType() == 1 || e.getType() == -1 || e.getFirstRow() == -1) {
            this.reallocateIndexes();
            if (this.table != null) {
                this.table.editingStopped(new ChangeEvent(this));
            }
            if (this.setSortOnRowInsertDelete) {
                if (e.getFirstRow() == -1) {
                    this.sortingColumns.removeAllElements();
                }
                int column = 0;
                if (this.sortingColumns.isEmpty()) {
                    column = this.sortingColumns.elementAt(0);
                }
                this.sortByColumn(column);
            }
            this.sortByColumn(this.clickedColumn);
        }
        if (e.getFirstRow() == -1) {
            super.tableChanged(new TableModelEvent(this, -1));
        } else {
            super.tableChanged(new TableModelEvent(this));
        }
        if (this.table != null && selectedRow != -1) {
            if (this.indexesLength < selectedRow + 1 || e.getFirstRow() == selectedRow) {
                this.table.clearSelection();
            } else {
                for (int i = 0; i < this.indexesLength; ++i) {
                    if (this.indexes[i] != selectedRow) continue;
                    selectedRow = i;
                    break;
                }
                this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                block1: for (int j = 0; j < selectedRows.length; ++j) {
                    for (int i = 0; i < this.indexesLength; ++i) {
                        if (this.indexes[i] != selectedRows[j]) continue;
                        this.table.getSelectionModel().addSelectionInterval(i, i);
                        continue block1;
                    }
                }
            }
        }
    }

    private void sortByColumn(int column) {
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(column);
        this.sort();
        super.tableChanged(new TableModelEvent(this));
    }

    private void sort() {
        this.checkModel();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexesLength);
    }

    protected void checkModel() {
        if (this.indexesLength != this.model.getRowCount()) {
            this.reallocateIndexes();
        }
    }

    private void shuttlesort(int[] fromA, int[] toB, int lowLayer, int highLayer) {
        if (highLayer - lowLayer < 2) {
            return;
        }
        int middle = (lowLayer + highLayer) / 2;
        this.shuttlesort(toB, fromA, lowLayer, middle);
        this.shuttlesort(toB, fromA, middle, highLayer);
        int p = lowLayer;
        int q = middle;
        if (highLayer - lowLayer >= 4 && this.compare(fromA[middle - 1], fromA[middle]) <= 0) {
            for (int i = lowLayer; i < highLayer; ++i) {
                toB[i] = fromA[i];
            }
            return;
        }
        for (int i = lowLayer; i < highLayer; ++i) {
            toB[i] = q >= highLayer || p < middle && this.compare(fromA[p], fromA[q]) <= 0 ? fromA[p++] : fromA[q++];
        }
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        if (aRow < this.getRowCount()) {
            this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
        }
    }

    public void addMouseListenerToHeaderInTable(SortedTable table) {
        this.table = table;
        table.setColumnSelectionAllowed(false);
        this.tableHeader = table.getTableHeader();
        this.listMouseListener = new ListMouseListener(this);
        this.tableHeader.addMouseListener(this.listMouseListener);
    }

    public void removeMouseListenerToHeaderInTable() {
        if (this.listMouseListener != null) {
            this.tableHeader.removeMouseListener(this.listMouseListener);
        }
    }

    public void setSortOnRowInsertDelete(boolean setSortOnRowInsertDelete) {
        this.setSortOnRowInsertDelete = setSortOnRowInsertDelete;
    }

    public void resetClickedColumn() {
        this.clickedColumn = 0;
    }

    private class ListMouseListener
    extends MouseAdapter {
        SortedTableModel sorter = null;

        public ListMouseListener(SortedTableModel s) {
            this.sorter = s;
        }

        public void mouseClicked(MouseEvent e) {
            int row = -1;
            int selectedRow = SortedTableModel.this.table.getSelectedRow();
            if (selectedRow > -1) {
                row = SortedTableModel.this.indexes[selectedRow];
            }
            SortedTableModel.this.table.editingStopped(new ChangeEvent(this));
            TableColumnModel columnModel = SortedTableModel.this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = SortedTableModel.this.table.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() >= 1 && column != -1) {
                if (SortedTableModel.this.clickedColumn == column) {
                    this.sorter.ascending = !SortedTableModel.this.ascending;
                } else {
                    this.sorter.ascending = true;
                }
                SortedTableModel.this.clickedColumn = column;
                this.sorter.sortByColumn(column);
            }
            if (row > -1) {
                for (int i = 0; i < SortedTableModel.this.indexesLength; ++i) {
                    if (SortedTableModel.this.indexes[i] != row) continue;
                    SortedTableModel.this.table.setRowSelectionInterval(i, i);
                    break;
                }
            }
        }
    }
}

