/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.em.fm.common.view.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import se.ericsson.cello.em.fm.common.utils.ifc.FmConstants;
import se.ericsson.cello.em.fm.common.utils.ifc.ToolService;
import se.ericsson.cello.em.fm.common.utils.impl.FmType;
import se.ericsson.cello.em.fm.common.view.impl.AbstractActions;
import se.ericsson.cello.em.fm.common.view.impl.Menu;
import se.ericsson.cello.emt.helpservice.HelpServiceI;

public class Utils {
    public JMenu createMenu(Menu menu, JMenuItem[] menuItems) {
        JMenu jmenu = new JMenu(menu.TEXT);
        jmenu.setMnemonic(menu.MNEMONIC);
        for (JMenuItem menuItem : menuItems) {
            if (menuItem != null) {
                jmenu.add((Component)menuItem);
                continue;
            }
            jmenu.addSeparator();
        }
        return jmenu;
    }

    public JMenuItem[] getHelpMenuItems(ToolService toolService, JFrame mainFrame) {
        JMenuItem helpOnWindowMenuItem = new JMenuItem();
        helpOnWindowMenuItem.setAction(new HelpOnWindowAction(toolService));
        JMenuItem systemLibraryMenuItem = new JMenuItem();
        systemLibraryMenuItem.setAction(new SystemLibraryAction(toolService));
        JMenuItem usingHelpMenuItem = new JMenuItem();
        usingHelpMenuItem.setAction(new UsingHelpAction(toolService, mainFrame));
        JMenuItem aboutMenuItem = new JMenuItem();
        aboutMenuItem.setAction(new AboutAction(toolService, mainFrame));
        return new JMenuItem[]{helpOnWindowMenuItem, null, systemLibraryMenuItem, usingHelpMenuItem, null, aboutMenuItem};
    }

    public Action getHelpOnWindowAction(ToolService toolService, String text) {
        return new HelpOnWindowAction(toolService, text);
    }

    public JComponent createUserPanel() {
        JPanel user = new JPanel(new FlowLayout(0));
        user.setBorder(BorderFactory.createEtchedBorder(1));
        JLabel userText = new JLabel("User ID:");
        userText.setForeground(Color.black);
        JLabel userValue = new JLabel(this.getUserId());
        userValue.setForeground(Color.black);
        user.add((Component)userText, null);
        user.add((Component)userValue, null);
        return user;
    }

    public JComponent createCounterPanel(String counterText, JLabel counterValue, String toolTip) {
        JPanel counter = new JPanel(new FlowLayout(0));
        JLabel text = new JLabel(counterText);
        text.setForeground(Color.black);
        counterValue.setForeground(Color.black);
        if (toolTip != null) {
            counterValue.setToolTipText(toolTip);
        }
        counter.add(text);
        counter.add(counterValue);
        return counter;
    }

    public JComponent createChangedPanel(String changedText, JLabel changedValue) {
        JPanel changed = new JPanel(new FlowLayout(0));
        JLabel text = new JLabel(changedText);
        text.setForeground(Color.black);
        changedValue.setForeground(Color.black);
        changed.add(text);
        changed.add(changedValue);
        return changed;
    }

    public Component createSummaryPanel() {
        return null;
    }

    public String getCounterText(int ... counters) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int counter : counters) {
            sb.append(counter);
            sb.append("/");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }

    private String getUserId() {
        String userId = null;
        try {
            userId = System.getProperty("user.name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userId == null ? "Undefined User" : userId;
    }

    private class AboutAction
    extends AbstractActions.AbstractAboutAction {
        private static final long serialVersionUID = 1L;
        private ToolService toolService;
        private JFrame mainFrame;

        public AboutAction(ToolService toolService, JFrame mainFrame) {
            this.toolService = toolService;
            this.mainFrame = mainFrame;
            super.putValue("Name", "About " + toolService.getConfiguration().getShortTitle());
        }

        public void actionPerformed(ActionEvent event) {
            HelpServiceI helpService = this.toolService.getHelpService();
            if (helpService != null) {
                helpService.displayAbout(this.toolService.getConfiguration().getShortTitle(), this.toolService.getConfigurationFiles(), this.mainFrame, null, "", FmConstants.COPYRIGHT_YEAR, "");
            }
        }
    }

    private class UsingHelpAction
    extends AbstractActions.AbstractUsingHelpAction {
        private static final long serialVersionUID = 1L;
        private ToolService toolService;
        private JFrame mainFrame;

        public UsingHelpAction(ToolService toolService, JFrame mainFrame) {
            this.toolService = toolService;
            this.mainFrame = mainFrame;
        }

        public void actionPerformed(ActionEvent event) {
            HelpServiceI helpService = this.toolService.getHelpService();
            if (helpService != null) {
                helpService.displayUsingHelp(this.mainFrame);
            }
        }
    }

    private class SystemLibraryAction
    extends AbstractActions.AbstractSystemLibraryAction {
        private static final long serialVersionUID = 1L;
        private ToolService toolService;

        public SystemLibraryAction(ToolService toolService) {
            this.toolService = toolService;
        }

        public void actionPerformed(ActionEvent event) {
            this.toolService.displayAlexHelp("System Library", "");
        }
    }

    private class HelpOnWindowAction
    extends AbstractActions.AbstractHelpOnWindowAction {
        private static final long serialVersionUID = 1L;
        private ToolService toolService;

        public HelpOnWindowAction(ToolService toolService) {
            this.toolService = toolService;
        }

        public HelpOnWindowAction(ToolService toolService, String text) {
            this.toolService = toolService;
            this.putValue("Name", text);
        }

        public void actionPerformed(ActionEvent event) {
            FmType type = this.toolService.getConfiguration().getFmType();
            String helpTag = "MainWindowHelp";
            if (type.equals((Object)FmType.ALARM_LOG)) {
                helpTag = "AlarmLog";
            } else if (type.equals((Object)FmType.EVENT)) {
                helpTag = "EventLog";
            } else if (type.equals((Object)FmType.ALARM_LIST)) {
                helpTag = "AlarmList";
            }
            this.toolService.displayAlexHelp("Element Manager", helpTag);
        }
    }
}

