/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.cat.pmcommon;

import se.ericsson.crbs.cat.pmcommon.PmBase;
import se.ericsson.crbs.cat.pmcommon.PmBaseState;

public abstract class PmBaseStateMachine
extends PmBase {
    private PmBaseState m_terminatedState;
    private PmBaseState m_currentState;

    protected PmBaseStateMachine(PmBaseState initialState, PmBaseState terminatedState) {
        this.m_terminatedState = terminatedState;
        this.m_currentState = initialState;
    }

    protected PmBaseState getCurrentState() {
        return this.m_currentState;
    }

    public boolean isTerminated() {
        return this.m_terminatedState.toInt() == this.m_currentState.toInt();
    }

    public boolean isAtState(PmBaseState expected) {
        return expected.toInt() == this.m_currentState.toInt();
    }

    public boolean isBetweenStates(PmBaseState from, PmBaseState to) {
        this.enter("isBetweenStates");
        return from.toInt() <= this.m_currentState.toInt() && this.m_currentState.toInt() <= to.toInt();
    }

    public boolean checkState(PmBaseState expected) {
        this.enter("checkState");
        if (this.m_currentState.toInt() != expected.toInt()) {
            this.general("CHECK_STATE_FAILED - " + this.THIS_CLASS.getName() + ". Expected: " + expected.toString() + " actual: " + this.m_currentState.toString());
            return false;
        }
        return true;
    }

    public boolean validateState(PmBaseState expected) {
        this.enter("validateState");
        if (this.m_currentState.toInt() != expected.toInt()) {
            this.error("VALIDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". Expected: " + expected.toString() + " actual: " + this.m_currentState.toString());
            this.terminate();
            return false;
        }
        if (!this.onValidateState(this.m_currentState)) {
            this.error("VALIDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". onValidateState failed  . Expected: " + expected.toString() + " actual: " + this.m_currentState.toString());
            return false;
        }
        return true;
    }

    public boolean validateStates(PmBaseState[] expected) {
        this.enter("validateStates");
        int currentAsInt = this.m_currentState.toInt();
        boolean found = false;
        for (int iter = 0; iter < expected.length; ++iter) {
            int asInt = expected[iter].toInt();
            if (currentAsInt != asInt) continue;
            found = true;
            break;
        }
        if (!found) {
            StringBuffer sb = new StringBuffer();
            for (int iter = 0; iter < expected.length; ++iter) {
                if (iter > 0) {
                    sb.append(", ");
                }
                sb.append(expected[iter].toString());
            }
            this.error("VALIDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". Expected any of: " + sb.toString() + " actual: " + this.m_currentState.toString());
            this.terminate();
            return false;
        }
        if (!this.onValidateState(this.m_currentState)) {
            this.error("VALIDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". onValidateState failed  . Expected: " + expected.toString() + " actual: " + this.m_currentState.toString());
            return false;
        }
        return true;
    }

    public boolean validateStateRange(PmBaseState from, PmBaseState to) {
        this.enter("validateStateRange");
        if (this.m_currentState.toInt() < from.toInt() || this.m_currentState.toInt() > to.toInt()) {
            this.error("VALIDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". Expected between: " + from.toString() + ".." + to.toString() + " actual: " + this.m_currentState.toString());
            this.terminate();
            return false;
        }
        if (!this.onValidateState(this.m_currentState)) {
            this.error("VALIDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". onValidateState failed  . Expected between: " + from.toString() + ".." + to.toString() + " actual: " + this.m_currentState.toString());
            return false;
        }
        return true;
    }

    public boolean updateState(PmBaseState from, PmBaseState to) {
        this.enter("updateState");
        if (from.toInt() != this.m_currentState.toInt()) {
            this.error("UPDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". Given from state is not the actual current state, given: " + from.toString() + " actual: " + this.m_currentState.toString());
            this.terminate();
            return false;
        }
        this.general("UPDATE_STATE - " + this.THIS_CLASS.getName() + ".From: " + from.toString() + " to: " + to.toString());
        this.m_currentState = to;
        if (!this.onUpdateState(from, to)) {
            this.error("UPDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". onUpdateState failed, given: " + from.toString() + " actual: " + this.m_currentState.toString());
            return false;
        }
        return true;
    }

    public boolean forceState(PmBaseState to) {
        PmBaseState from = this.m_currentState;
        this.general("FORCE_STATE - " + this.THIS_CLASS.getName() + ".From: " + from.toString() + " to: " + to.toString());
        this.m_currentState = to;
        if (!this.onUpdateState(from, to)) {
            this.error("FORCE_UPDATE_STATE_FAILED - " + this.THIS_CLASS.getName() + ". onUpdateState failed, given: " + from.toString() + " actual: " + this.m_currentState.toString());
            return false;
        }
        return true;
    }

    protected boolean onValidateState(PmBaseState currentState) {
        return true;
    }

    protected boolean onUpdateState(PmBaseState from, PmBaseState to) {
        return true;
    }

    public void terminate() {
        this.enter("terminate");
        this.error("TERMINATED");
        this.m_currentState = this.m_terminatedState;
    }

    public String toString() {
        return "CURRENT_STATE - " + this.THIS_CLASS.getName() + ". " + this.m_currentState.toString();
    }
}

