/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.collector;

import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.DataWriter;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.common.DataCollectorMoConstants;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;

public class DataCollectorMoDataWriter
implements DataWriter,
DataCollectorMoConstants {
    private String identity = null;
    private ManagedObject mo = null;

    public DataCollectorMoDataWriter(String string) {
        this.identity = string;
    }

    public void writeData(Attribute attribute, CollectorContext collectorContext, Coordinator coordinator) throws AueException {
        if (this.mo == null) {
            this.mo = this.findMo(collectorContext);
            if (this.mo != null) {
                collectorContext.getLogger().info(this.getClass(), "Warning: An instance of the DataCollector MO exists in the MO repository. Will be deleted.");
                try {
                    this.mo.delete(coordinator);
                }
                catch (MoAccessException moAccessException) {
                    throw new AueException("Unable to delete MO", moAccessException);
                }
            }
            try {
                this.mo = collectorContext.getMoAccessor().lookupMoFactory("DataCollector").createMo(null, null, this.identity, null, coordinator);
            }
            catch (MoAccessException moAccessException) {
                throw new AueException("Unable to instantiate MO", moAccessException);
            }
        }
        try {
            this.mo.setAttribute("data", (Object)attribute, coordinator);
        }
        catch (MoAccessException moAccessException) {
            throw new AueException("Unable to add data to MO", moAccessException);
        }
    }

    private ManagedObject findMo(CollectorContext collectorContext) {
        MoIterator moIterator = collectorContext.getMoAccessor().lookupType("DataCollector");
        if (moIterator == null) {
            return null;
        }
        ManagedObject managedObject = null;
        while (moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (!managedObject.getNamingAttributeValue().equals(this.identity)) continue;
            return managedObject;
        }
        return null;
    }
}

