/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter.actions;

import java.util.Enumeration;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StructAttribute;

public class AttributeHelper {
    public static Attribute renameAttribute(Attribute attribute, String string) throws AueException {
        return AttributeHelper.modify(attribute, string, attribute.isAVCNotifier());
    }

    public static Attribute changeNotification(Attribute attribute, boolean bl) throws AueException {
        return AttributeHelper.modify(attribute, attribute.getName(), bl);
    }

    public static Attribute modify(Attribute attribute, String string, boolean bl) throws AueException {
        if (attribute instanceof StringAttribute) {
            StringAttribute stringAttribute = (StringAttribute)attribute;
            String string2 = stringAttribute.getValue(null);
            return new StringAttribute(string, bl, string2);
        }
        if (attribute instanceof IntegerAttribute) {
            IntegerAttribute integerAttribute = (IntegerAttribute)attribute;
            int n = integerAttribute.getValue(null);
            return new IntegerAttribute(string, bl, n);
        }
        if (attribute instanceof ReferenceAttribute) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)attribute;
            String string3 = referenceAttribute.getReferenceAsLDN();
            return new ReferenceAttribute(string, string3, bl);
        }
        if (attribute instanceof BooleanAttribute) {
            BooleanAttribute booleanAttribute = (BooleanAttribute)attribute;
            boolean bl2 = booleanAttribute.getValue(null);
            return new BooleanAttribute(string, bl, bl2);
        }
        if (attribute instanceof FloatAttribute) {
            FloatAttribute floatAttribute = (FloatAttribute)attribute;
            float f = floatAttribute.getValue(null);
            return new FloatAttribute(string, bl, f);
        }
        if (attribute instanceof SequenceAttribute) {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
            Attribute[] attributeArray = sequenceAttribute.getValue(null);
            sequenceAttribute = new SequenceAttribute(string, bl);
            sequenceAttribute.setValue(attributeArray);
            return sequenceAttribute;
        }
        if (attribute instanceof LongAttribute) {
            LongAttribute longAttribute = (LongAttribute)attribute;
            long l = longAttribute.getValue(null);
            return new LongAttribute(string, bl, l);
        }
        if (attribute instanceof StructAttribute) {
            StructAttribute structAttribute = (StructAttribute)attribute;
            Enumeration enumeration = structAttribute.elements();
            structAttribute = new StructAttribute(string, bl);
            while (enumeration.hasMoreElements()) {
                structAttribute.addElement((Attribute)enumeration.nextElement());
            }
            return structAttribute;
        }
        throw new AueException("Unsupported attribute type: " + attribute.getClass().getName());
    }
}

