/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.aueframework.converter.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.transaction.Coordinator;

public class RemoveReferencesAction
implements MoDataAction {
    private String referringMoTypeName;
    private String referringAttrName;
    static /* synthetic */ Class class$se$ericsson$cello$moframework$ReferenceAttribute;
    static /* synthetic */ Class class$se$ericsson$cello$moframework$SequenceAttribute;

    public RemoveReferencesAction(String string, String string2) {
        this.referringMoTypeName = string;
        this.referringAttrName = string2;
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws AueException {
        String string = moDataWrapper.getLocalDistinguishedName();
        Collection collection = converterContext.getMoDataAccessor().getByType(this.referringMoTypeName);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            MoDataWrapper moDataWrapper2 = (MoDataWrapper)iterator.next();
            Attribute attribute = moDataWrapper2.getAttribute(this.referringAttrName);
            if (attribute.getClass().equals(class$se$ericsson$cello$moframework$ReferenceAttribute == null ? RemoveReferencesAction.class$("se.ericsson.cello.moframework.ReferenceAttribute") : class$se$ericsson$cello$moframework$ReferenceAttribute)) {
                this.removeFromReference(moDataWrapper2, (ReferenceAttribute)attribute, string, coordinator);
                continue;
            }
            if (attribute.getClass().equals(class$se$ericsson$cello$moframework$SequenceAttribute == null ? RemoveReferencesAction.class$("se.ericsson.cello.moframework.SequenceAttribute") : class$se$ericsson$cello$moframework$SequenceAttribute)) {
                this.removeFromSequence(moDataWrapper2, (SequenceAttribute)attribute, string, coordinator);
                continue;
            }
            throw new AueException(this.referringMoTypeName + "." + this.referringAttrName + " is a " + attribute.getClass().getName());
        }
    }

    void removeFromReference(MoDataWrapper moDataWrapper, ReferenceAttribute referenceAttribute, String string, Coordinator coordinator) throws AueException {
        if (string.equals(referenceAttribute.getReferenceAsLDN())) {
            ReferenceAttribute referenceAttribute2 = new ReferenceAttribute(this.referringAttrName, referenceAttribute.isAVCNotifier());
            moDataWrapper.deregisterAttribute((Attribute)referenceAttribute);
            moDataWrapper.registerPersistentAttr((Attribute)referenceAttribute2);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        }
    }

    void removeFromSequence(MoDataWrapper moDataWrapper, SequenceAttribute sequenceAttribute, String string, Coordinator coordinator) throws AueException {
        Enumeration enumeration = sequenceAttribute.elements();
        while (enumeration.hasMoreElements()) {
            ReferenceAttribute referenceAttribute = (ReferenceAttribute)enumeration.nextElement();
            if (!referenceAttribute.getReferenceAsLDN().equals(string)) continue;
            sequenceAttribute.removeElement((Attribute)referenceAttribute);
            moDataWrapper.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            return;
        }
    }
}

