/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;

public class EsaTimeValidator {
    private static final int EXPECTED_TIME_FORMAT_LENGTH = 14;
    private static final int GRACE_PERIOD = 3600000;

    private EsaTimeValidator() {
    }

    public static boolean checkValidTime(String string, String string2) throws SecurityActivationInputException {
        return EsaTimeValidator.checkTime(string, string2, new Date());
    }

    protected static boolean checkTime(String string, String string2, Date date) throws SecurityActivationInputException {
        boolean bl = false;
        if (EsaTimeValidator.isWithinGracePeriod(date)) {
            EsaReportLogger.getInstance().logMessage("Current date is within grace period. Ignoring time check.");
            bl = true;
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss", Locale.ENGLISH);
            ParsePosition parsePosition = new ParsePosition(0);
            Date date2 = simpleDateFormat.parse(string, parsePosition);
            ParsePosition parsePosition2 = new ParsePosition(0);
            Date date3 = simpleDateFormat.parse(string2, parsePosition2);
            if (date2 == null || date3 == null || string.length() != 14 || string2.length() != 14) {
                throw new SecurityActivationInputException("The provided times does not match the required format yyyyMMDDhhmmss.");
            }
            bl = date.after(date2) && date.before(date3);
        }
        return bl;
    }

    private static boolean isWithinGracePeriod(Date date) {
        return date.getTime() <= 3600000L;
    }
}

