/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.logger;

import se.ericsson.security.cppsec.esa.EsaMessageHandler;
import se.ericsson.security.cppsec.esa.logger.EsaReportLogger;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapper;
import se.ericsson.security.cppsec.esa.wrapper.MessageLogWrapperFactory;

public class EsaMessageSender {
    private static EsaMessageHandler listener = null;
    private static final MessageLogWrapper logger = MessageLogWrapperFactory.getLogger(EsaMessageHandler.class);

    public EsaMessageSender() {
    }

    public EsaMessageSender(EsaMessageHandler esaMessageHandler) {
        listener = esaMessageHandler;
    }

    public synchronized void sendMessage(String string) {
        if (listener != null) {
            listener.reportProgress(string);
            logger.trace(1, string);
            EsaReportLogger.getInstance().logMessage("Sent to message handler: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMessageHandler(EsaMessageHandler esaMessageHandler) {
        Class clazz = EsaMessageSender.class;
        synchronized (clazz) {
            if (esaMessageHandler == null) {
                EsaReportLogger.getInstance().logMessage("Removed message handler.");
            } else {
                EsaReportLogger.getInstance().logMessage("Added message handler: " + esaMessageHandler.getClass().getName());
            }
            listener = esaMessageHandler;
        }
    }
}

