/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.cppsec.esa.model.elements;

import org.xml.sax.Attributes;
import se.ericsson.security.cppsec.esa.SecurityActivationInputException;
import se.ericsson.security.cppsec.esa.model.DataChallengePassword;
import se.ericsson.security.cppsec.esa.model.EnrollmentData;
import se.ericsson.security.cppsec.esa.model.elements.DataChallengePasswordElement;
import se.ericsson.security.cppsec.esa.parser.StackElement;

public class EnrollmentDataElement
extends StackElement
implements EnrollmentData {
    private static final String CA_FINGERPRINT = "cAFingerprint";
    private static final String DISTINGUISHED_NAME = "distinguishedName";
    private static final String ENROLLMENT_SERVER_URL = "enrollmentServerURL";
    private static final String KEY_LENGTH = "keyLength";
    private static final String ENROLLMENT_TIME_LIMIT = "enrollmentTimeLimit";
    private static final String ENROLLMENT_MODE = "enrollmentMode";
    private static final String CERTIFICATE_AUTHORITY_DN = "certificateAuthorityDn";
    public static final String ENROLLMENTDATA = "enrollmentData";
    private String cAFingerprint;
    private String distinguishedName;
    private String enrollmentServerURL;
    private String keyLength;
    private String enrollmentTimeLimit;
    private String enrollmentMode;
    private String certificateAuthorityDn;
    private DataChallengePasswordElement dataChallengePasswordElement = null;

    protected StackElement createElement(String string, String string2, String string3, Attributes attributes) {
        DataChallengePasswordElement dataChallengePasswordElement = null;
        if ("dataChallengePassword".equalsIgnoreCase(string2)) {
            dataChallengePasswordElement = new DataChallengePasswordElement();
        }
        this.dataChallengePasswordElement = dataChallengePasswordElement;
        return dataChallengePasswordElement;
    }

    protected void fetchAttributes(Attributes attributes) throws SecurityActivationInputException {
        this.cAFingerprint = super.getRequiredAttribute(attributes, CA_FINGERPRINT);
        this.distinguishedName = super.getRequiredAttribute(attributes, DISTINGUISHED_NAME);
        this.enrollmentServerURL = super.getRequiredAttribute(attributes, ENROLLMENT_SERVER_URL);
        this.keyLength = super.getOptionalAttribute(attributes, KEY_LENGTH, "0");
        this.enrollmentTimeLimit = super.getOptionalAttribute(attributes, ENROLLMENT_TIME_LIMIT, "120");
        String string = super.getOptionalAttribute(attributes, ENROLLMENT_MODE, "0");
        this.enrollmentMode = this.validateMode(string);
        this.certificateAuthorityDn = super.getOptionalAttribute(attributes, CERTIFICATE_AUTHORITY_DN, "");
        this.validateAttributes();
    }

    protected void validateAttributes() throws SecurityActivationInputException {
        int n;
        int n2;
        try {
            n2 = Integer.parseInt(this.keyLength);
        }
        catch (Throwable throwable) {
            throw new SecurityActivationInputException("attribute keyLength invalid value - " + this.keyLength, throwable);
        }
        if (n2 < 0 || n2 > 1) {
            throw new SecurityActivationInputException("attribute keyLength invalid value - " + this.keyLength);
        }
        try {
            n = Integer.parseInt(this.enrollmentTimeLimit);
        }
        catch (Throwable throwable) {
            throw new SecurityActivationInputException("attribute enrollmentTimeLimit invalid value - " + this.enrollmentTimeLimit, throwable);
        }
        if (n < 120 || n > 1800) {
            throw new SecurityActivationInputException("attribute enrollmentTimeLimit invalid value - " + this.enrollmentTimeLimit);
        }
    }

    public void checkConsistency() throws SecurityActivationInputException {
        if (this.getEnrollmentMode() != 1) {
            if (this.dataChallengePasswordElement == null) {
                throw new SecurityActivationInputException("The EnrollmentData Element is not consistent. It must contaion a DataChallengePassword element");
            }
            this.dataChallengePasswordElement.checkConsistency();
        }
    }

    protected String validateMode(String string) throws SecurityActivationInputException {
        if (Integer.parseInt(string) < 0 || Integer.parseInt(string) > 2) {
            throw new SecurityActivationInputException("attribute enrollment mode invalid value - " + string + " It must be 0 to 2");
        }
        return string;
    }

    public String getCAFingerprint() {
        return this.cAFingerprint;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    public String getEnrollmentServerURL() {
        return this.enrollmentServerURL;
    }

    public Integer getEnrollmentMode() {
        return Integer.valueOf(this.enrollmentMode);
    }

    public String getCertificateAuthorityDn() {
        return this.certificateAuthorityDn;
    }

    public Integer getKeyLength() {
        return Integer.valueOf(this.keyLength);
    }

    public DataChallengePassword getDataChallengePassword() {
        return this.dataChallengePasswordElement;
    }

    public Integer getEnrollmentTimeLimit() {
        return Integer.valueOf(this.enrollmentTimeLimit);
    }
}

