/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import com.ibm.oti.util.ASN1Decoder;
import com.ibm.oti.util.ASN1Encoder;
import com.ibm.oti.util.PriviAction;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.PBEParameterSpec;

public final class AlgorithmParametersPBE
extends AlgorithmParametersSpi {
    int iterationCount;
    byte[] salt = new byte[8];
    private boolean initialized = false;
    static /* synthetic */ Class class$0;

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (!this.initialized) {
            throw new IOException();
        }
        if (format == null || format.equals("ASN.1")) {
            Object[] PBEParameter = new Object[2];
            byte[] saltParamBytes = new byte[8];
            System.arraycopy(this.salt, 0, saltParamBytes, 0, 8);
            PBEParameter[0] = saltParamBytes;
            PBEParameter[1] = BigInteger.valueOf(this.iterationCount);
            return ASN1Encoder.getEncoding((Object)PBEParameter);
        }
        throw new IOException(Msg.getString("JCP000"));
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.crypto.spec.PBEParameterSpec");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (paramSpec != clazz) {
            throw new InvalidParameterSpecException();
        }
        return new PBEParameterSpec(this.salt, this.iterationCount);
    }

    protected void engineInit(byte[] params, String format) throws IOException {
        if (format == null || format.equals("ASN.1")) {
            try {
                Object[] pbeParams = (Object[])ASN1Decoder.getDecoded((byte[])params);
                this.salt = (byte[])pbeParams[0];
                this.iterationCount = ((BigInteger)pbeParams[1]).intValue();
            }
            catch (ClassCastException classCastException) {
                throw new IOException(Msg.getString("JCP003"));
            }
            this.initialized = true;
            return;
        }
        throw new IOException(Msg.getString("JCP002"));
    }

    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException();
        }
        PBEParameterSpec spec = (PBEParameterSpec)paramSpec;
        this.salt = spec.getSalt();
        this.iterationCount = spec.getIterationCount();
        this.initialized = true;
    }

    protected String engineToString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Salt:");
        int i = 0;
        while (i < this.salt.length) {
            sb.append(" ");
            sb.append(this.salt[i]);
            ++i;
        }
        sb.append("]");
        sb.append((String)AccessController.doPrivileged(new PriviAction("line.separator")));
        sb.append("[Iteration count:");
        sb.append(this.iterationCount);
        sb.append("]");
        return sb.toString();
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded("ASN.1");
    }

    protected void engineInit(byte[] params) throws IOException {
        this.engineInit(params, "ASN.1");
    }
}

