/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.bluez.crypto.CL3;
import com.ibm.j9.bluez.crypto.CL3Exception;
import com.ibm.j9.bluez.crypto.RSACipher;
import com.ibm.j9.jce.provider.AsymmetricCipherSpi;
import com.ibm.j9.jce.provider.Msg;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class AsymmetricCipherRSA
extends AsymmetricCipherSpi {
    private CL3 cl3KeyHandle = null;
    private static final int RSA_ENCRYPT = 1;
    private static final int RSA_DECRYPT = 2;
    private static final int RSA_SIGN = 3;
    private static final int RSA_VERIFY = 4;
    private static final int RSA_UNKNOWN_MODE = -1;

    protected int getPaddingID(String padding) {
        if (padding.equalsIgnoreCase("OAEP")) {
            return 4;
        }
        if (padding.equalsIgnoreCase("PKCS1")) {
            return 3;
        }
        if (padding.equalsIgnoreCase("NoPadding")) {
            return 2;
        }
        return -1;
    }

    protected int process(byte[] input, int inputLen, byte[] output, int outputStart) {
        if (this.cl3KeyHandle == null) {
            return -1;
        }
        int length = 0;
        int format = 0;
        switch (this.paddingMode) {
            case 4: {
                format |= 0x60;
                break;
            }
            case 3: {
                format |= 0x20;
                break;
            }
            case 2: {
                format |= 0;
                break;
            }
            default: {
                return -1;
            }
        }
        int rsaMode = this.getRSAMode();
        try {
            switch (rsaMode) {
                case 1: {
                    length = RSACipher.rsaEncrypt((CL3)this.cl3KeyHandle, (int)format, null, (byte[])input, (int)0, (int)inputLen, (byte[])output, (int)outputStart);
                    if (length != CL3.getSize((CL3)this.cl3KeyHandle)) {
                        length = -1;
                    }
                    break;
                }
                case 2: {
                    length = RSACipher.rsaDecrypt((CL3)this.cl3KeyHandle, (int)format, null, (byte[])input, (int)0, (int)inputLen, (byte[])output, (int)outputStart);
                    if (length < 0) {
                        length = -1;
                    }
                    break;
                }
                case 3: {
                    length = RSACipher.rsaSign((CL3)this.cl3KeyHandle, (int)format, null, (byte[])input, (int)0, (int)inputLen, (byte[])output, (int)outputStart);
                    if (length != CL3.getSize((CL3)this.cl3KeyHandle)) {
                        length = -1;
                    }
                    break;
                }
                case 4: {
                    length = RSACipher.rsaDecryptSignature((CL3)this.cl3KeyHandle, (int)format, null, (byte[])input, (int)0, (int)inputLen, (byte[])output, (int)outputStart);
                    if (length < 0) {
                        length = -1;
                    }
                    break;
                }
                default: {
                    length = -1;
                    break;
                }
            }
        }
        catch (CL3Exception cL3Exception) {
            length = -1;
        }
        return length;
    }

    private int getRSAMode() {
        if (this.operationMode == 1 && this.cipherKey instanceof PublicKey) {
            return 1;
        }
        if (this.operationMode == 1 && this.cipherKey instanceof PrivateKey) {
            return 3;
        }
        if (this.operationMode == 2 && this.cipherKey instanceof PublicKey) {
            return 4;
        }
        if (this.operationMode == 2 && this.cipherKey instanceof PrivateKey) {
            return 2;
        }
        return -1;
    }

    protected Key validateKey(Key k, int opMode) throws InvalidKeyException {
        try {
            if (k instanceof RSAPublicKey) {
                this.cl3KeyHandle = CL3.importKey((int)3, (byte[])k.getEncoded(), (int)0, (int)k.getEncoded().length);
            } else if (k instanceof RSAPrivateKey) {
                this.cl3KeyHandle = CL3.importKey((int)2, (byte[])k.getEncoded(), (int)0, (int)k.getEncoded().length);
            }
        }
        catch (CL3Exception cL3Exception) {
            throw new InvalidKeyException(Msg.getString("K0360"));
        }
        if (this.cl3KeyHandle == null) {
            throw new InvalidKeyException(Msg.getString("K0360"));
        }
        return k;
    }

    protected void algorithmSpecificReset() {
        this.cl3KeyHandle = null;
    }

    protected int getMaximumEncryptedSize() {
        if (this.cl3KeyHandle != null) {
            return CL3.getSize((CL3)this.cl3KeyHandle);
        }
        return 0;
    }

    protected int getMaximumMessageSize() {
        if (this.cl3KeyHandle == null) {
            return 0;
        }
        switch (this.paddingMode) {
            case 3: {
                return CL3.getSize((CL3)this.cl3KeyHandle) - 11;
            }
            case 4: {
                int hashLength = 20;
                return CL3.getSize((CL3)this.cl3KeyHandle) - 2 * hashLength - 2;
            }
        }
        return CL3.getSize((CL3)this.cl3KeyHandle);
    }

    protected int getMinimumMessageSize() {
        if (this.cl3KeyHandle != null && this.paddingMode == 2) {
            return CL3.getSize((CL3)this.cl3KeyHandle);
        }
        return 0;
    }
}

