/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public abstract class CipherSpiJ9
extends CipherSpi {
    protected static final int MODE_UNSUPPORTED = -1;
    protected static final int MODE_CBC = 0;
    protected static final int MODE_ECB = 1;
    protected static final int MODE_CFB = 2;
    protected static final String MODE_CBC_STRING = "CBC";
    protected static final String MODE_ECB_STRING = "ECB";
    protected static final String MODE_CFB_STRING = "CFB";
    protected static final String PADDING_NOPADDING_STRING = "NoPadding";
    protected static final String PADDING_SSL3PADDING_STRING = "SSL3Padding";
    protected static final String PADDING_PKCS1_STRING = "PKCS1";
    protected static final String PADDING_PKCS5PADDING_STRING = "PKCS5Padding";
    protected static final String PADDING_OAEP_STRING = "OAEP";
    protected static final int PADDING_UNSUPPORTED = -1;
    protected static final int PADDING_SSL3 = 0;
    protected static final int PADDING_PKCS5 = 1;
    protected static final int PADDING_NOPADDING = 2;
    protected static final int PADDING_PKCS1 = 3;
    protected static final int PADDING_OAEP = 4;
    protected int initialOpMode = -1;
    protected int operationMode = -1;
    protected Key cipherKey = null;
    protected SecureRandom randomSource = null;
    protected boolean initialized = false;
    protected int feedbackMode = 1;
    protected int paddingMode = -1;

    protected int getDefaultPadding() {
        return 1;
    }

    protected void validateState() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        this.validateState();
        if (this.initialOpMode != 3) {
            throw new IllegalStateException();
        }
        byte[] keyBytes = key.getEncoded();
        byte[] result = null;
        try {
            result = this.engineDoFinal(keyBytes, 0, keyBytes.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new IllegalBlockSizeException();
        }
        return result;
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (mode == null) {
            throw new NoSuchAlgorithmException(Msg.getString("JCP007"));
        }
        int modeID = this.getModeID(mode);
        if (modeID == -1) {
            throw new NoSuchAlgorithmException(Msg.getString("JCP008", mode));
        }
        this.feedbackMode = modeID;
    }

    protected int getModeID(String mode) {
        if (mode.equalsIgnoreCase(MODE_CBC_STRING)) {
            return 0;
        }
        if (mode.equalsIgnoreCase(MODE_ECB_STRING)) {
            return 1;
        }
        return -1;
    }

    protected int getPaddingID(String padding) {
        if (padding.equalsIgnoreCase(PADDING_SSL3PADDING_STRING)) {
            return 0;
        }
        if (padding.equalsIgnoreCase(PADDING_PKCS5PADDING_STRING)) {
            return 1;
        }
        if (padding.equalsIgnoreCase(PADDING_NOPADDING_STRING)) {
            return 2;
        }
        return -1;
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (padding == null) {
            throw new NoSuchPaddingException();
        }
        int paddingID = this.getPaddingID(padding);
        if (paddingID == -1) {
            throw new NoSuchPaddingException(Msg.getString("JCP009", padding));
        }
        this.paddingMode = paddingID;
    }

    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int keyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] keyBytes;
        this.validateState();
        if (this.initialOpMode != 4) {
            throw new IllegalStateException();
        }
        try {
            keyBytes = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException();
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException();
        }
        if (keyType == 3) {
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, algorithm);
            return keySpec;
        }
        if (keyType == 1) {
            PublicKey key;
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory factory = KeyFactory.getInstance(algorithm);
            try {
                key = factory.generatePublic(keySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException();
            }
            return key;
        }
        if (keyType == 2) {
            PrivateKey key;
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory factory = KeyFactory.getInstance(algorithm);
            try {
                key = factory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException();
            }
            return key;
        }
        throw new IllegalArgumentException();
    }

    protected void initForOperation(int opMode, Key key, SecureRandom random) throws InvalidKeyException {
        this.randomSource = random == null ? new SecureRandom() : random;
        this.reset();
        if (this.paddingMode == -1) {
            this.paddingMode = this.getDefaultPadding();
        }
        this.initialOpMode = opMode;
        switch (opMode) {
            case 1: 
            case 2: {
                this.operationMode = opMode;
                break;
            }
            case 3: {
                this.operationMode = 1;
                break;
            }
            case 4: {
                this.operationMode = 2;
                break;
            }
            default: {
                throw new InvalidKeyException();
            }
        }
        this.cipherKey = this.validateKey(key, this.operationMode);
        this.initialized = true;
    }

    protected abstract Key validateKey(Key var1, int var2) throws InvalidKeyException;

    protected abstract void reset();
}

