/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.SecretKeyDES;
import com.ibm.j9.jce.provider.Util;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public class KeyGeneratorDES
extends KeyGeneratorSpi {
    private SecureRandom random;
    private static final int KEYLEN_BYTES = 8;
    private static final int EFFECTIVE_KEYLEN_BITS = 56;
    private int keylen = 8;

    protected void engineInit(SecureRandom random) {
        this.random = random == null ? new SecureRandom() : random;
    }

    protected void engineInit(AlgorithmParameterSpec parameters, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(Msg.getString("JCP020"));
    }

    protected void engineInit(int keylen, SecureRandom random) {
        this.verifyKeyLength(keylen);
        if (random == null) {
            throw new NullPointerException();
        }
        this.random = random;
    }

    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] keyMaterial = new byte[8];
        this.random.nextBytes(keyMaterial);
        byte[] parityAdjustedKeyMaterial = Util.getParityAdjusted(keyMaterial, 0, 8);
        return new SecretKeyDES(parityAdjustedKeyMaterial);
    }

    private void verifyKeyLength(int keyLen) throws InvalidParameterException {
        if (keyLen != 56) {
            throw new InvalidParameterException(Msg.getString("JCP019"));
        }
    }
}

