/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import com.ibm.j9.jce.provider.SecretKeyDES;
import com.ibm.j9.jce.provider.Util;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public final class SecretKeyFactoryDES
extends SecretKeyFactorySpi {
    private static final int DES_KEY_LEN = 8;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected SecretKey engineGenerateSecret(KeySpec spec) throws InvalidKeySpecException {
        if (spec instanceof SecretKeySpec) {
            SecretKeySpec keySpec = (SecretKeySpec)spec;
            byte[] keyMaterial = keySpec.getEncoded();
            byte[] parityAdjustedKeyMaterial = Util.getParityAdjusted(keyMaterial, 0, 8);
            return new SecretKeyDES(parityAdjustedKeyMaterial);
        }
        if (spec instanceof DESKeySpec) {
            DESKeySpec keySpec = (DESKeySpec)spec;
            byte[] keyMaterial = keySpec.getKey();
            byte[] parityAdjustedKeyMaterial = Util.getParityAdjusted(keyMaterial, 0, 8);
            return new SecretKeyDES(parityAdjustedKeyMaterial);
        }
        throw new InvalidKeySpecException(Msg.getString("JCP022"));
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpecClass) throws InvalidKeySpecException {
        byte[] keyMaterial = null;
        if (!(key instanceof SecretKeyDES) && !(key instanceof SecretKeySpec)) {
            throw new InvalidKeySpecException(Msg.getString("JCP022"));
        }
        keyMaterial = key.getEncoded();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.crypto.spec.DESKeySpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (keySpecClass == clazz) {
                return new DESKeySpec(keyMaterial);
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("javax.crypto.spec.SecretKeySpec");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (keySpecClass == clazz2) {
                return new SecretKeySpec(keyMaterial, "DES");
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException(Msg.getString("JCP022"));
        }
        throw new InvalidKeySpecException(Msg.getString("JCP022"));
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (key.getFormat() != "RAW") {
            throw new InvalidKeyException(Msg.getString("JCP002"));
        }
        String algorithm = key.getAlgorithm();
        if (!algorithm.toUpperCase().equals("DES")) {
            throw new InvalidKeyException();
        }
        byte[] keyMaterial = key.getEncoded();
        byte[] parityAdjustedKeyMaterial = Util.getParityAdjusted(keyMaterial, 0, keyMaterial.length);
        return new SecretKeyDES(parityAdjustedKeyMaterial);
    }
}

