/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jce.provider;

import com.ibm.j9.jce.provider.Msg;
import java.io.IOException;

public final class Util {
    static final int BITS_IN_A_BTYE = 8;
    static final String[] SKSSupportingAlgorithms = new String[]{"AES", "DES", "DESede", "Blowfish"};
    private static int[] bitCountMap;

    static {
        int[] nArray = new int[16];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 1;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 3;
        nArray[12] = 2;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 4;
        bitCountMap = nArray;
    }

    static byte[] padPKCS5(byte[] data, int offset, int numDataBytes, int blockSize) {
        byte[] block = new byte[blockSize];
        if (data.length > 0) {
            System.arraycopy(data, offset, block, 0, numDataBytes);
        }
        int padlen = blockSize - numDataBytes;
        int i = numDataBytes;
        while (i < blockSize) {
            block[i] = (byte)padlen;
            ++i;
        }
        return block;
    }

    static byte[] unpadPKCS5(byte[] block, int blockSize) throws IOException {
        byte padlen = block[blockSize - 1];
        if (padlen < 1 || padlen > blockSize) {
            throw new IOException(Msg.getString("JCP025"));
        }
        if (padlen == blockSize) {
            return new byte[0];
        }
        byte[] unpadded = new byte[blockSize - padlen];
        System.arraycopy(block, 0, unpadded, 0, blockSize - padlen);
        return unpadded;
    }

    static byte[] padSSL(byte[] data, int offset, int numDataBytes, int blockSize) {
        byte[] tmpBlock = new byte[blockSize];
        int padlen = blockSize - numDataBytes;
        if (numDataBytes > 0) {
            System.arraycopy(data, offset, tmpBlock, 0, numDataBytes);
        }
        int i = numDataBytes;
        while (i < blockSize - 1) {
            tmpBlock[i] = 0;
            ++i;
        }
        tmpBlock[blockSize - 1] = (byte)(padlen - 1);
        return tmpBlock;
    }

    static byte[] unpadSSL(byte[] block, int blockSize) throws IOException {
        int padlen = block[blockSize - 1] + 1;
        if (padlen < 1 || padlen > blockSize) {
            throw new IOException(Msg.getString("JCP025"));
        }
        if (padlen == blockSize) {
            return new byte[0];
        }
        byte[] unpadded = new byte[blockSize - padlen];
        System.arraycopy(block, 0, unpadded, 0, blockSize - padlen);
        return unpadded;
    }

    static boolean isParityAdjusted(byte aByte) {
        int bitCount = 0;
        int topHalf = (aByte & 0xF0) >> 4;
        bitCount += bitCountMap[topHalf];
        int bottomHalf = aByte & 0xF;
        return (bitCount += bitCountMap[bottomHalf]) % 2 == 1;
    }

    static byte getParityAdjusted(byte aByte) {
        if (Util.isParityAdjusted(aByte)) {
            return aByte;
        }
        return (byte)(aByte ^ 1);
    }

    static byte[] getParityAdjusted(byte[] bytes, int offset, int len) {
        byte[] result = new byte[len];
        int i = 0;
        while (i < len) {
            result[i] = Util.getParityAdjusted(bytes[offset + i]);
            ++i;
        }
        return result;
    }

    static boolean isSKSSupportedAlgorithm(String algorithmName) {
        int i = 0;
        while (i < SKSSupportingAlgorithms.length) {
            if (SKSSupportingAlgorithms[i].toUpperCase().equals(algorithmName.toUpperCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

