/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9.jsse;

import com.ibm.j9.jsse.SSLServerSocketImpl;
import com.ibm.j9.jsse.SSLSession;
import com.ibm.j9.jsse.SSLSessionContext;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.j9.ssl.CipherSpec;
import com.ibm.j9.ssl.ConnectionState;
import com.ibm.j9.ssl.HandshakeHandler;
import com.ibm.j9.ssl.HandshakeSocket;
import com.ibm.j9.ssl.J9ProtocolException;
import com.ibm.j9.ssl.J9SSLContext;
import com.ibm.j9.ssl.Record;
import com.ibm.j9.ssl.SSLProtocol;
import com.ibm.j9.ssl.StreamQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;

public class SSLSocketImpl
extends SSLSocket
implements HandshakeSocket {
    private static final int UNOPENED = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private Socket baseSocket;
    private boolean closeBaseSocketOnClose = true;
    private int socketStatus = 0;
    private StreamQueue appDataQueue = new StreamQueue();
    private InputStream baseInputStream = null;
    private SSLInputStream sslInputStream = null;
    int inputStatus = 0;
    private OutputStream baseOutputStream = null;
    private SSLOutputStream sslOutputStream = null;
    int outputStatus = 0;
    private boolean rngInitialised = false;
    private J9SSLContext context;
    private HandshakeHandler handshakeHandler;
    private Vector handshakeDoneListeners = new Vector(2);
    private boolean needClientAuth = false;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites = new String[0];
    private boolean wantClientAuth;
    private boolean useClientMode = true;

    protected SSLSocketImpl(J9SSLContext context, String[] defaultCipherSuites) {
        this.baseSocket = new Socket();
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
        this.handshakeHandler = new HandshakeHandler((HandshakeSocket)this, context);
    }

    SSLSocketImpl(String host, int port, J9SSLContext context, String[] defaultCipherSuites) throws IOException, UnknownHostException {
        this.baseSocket = new Socket(host, port);
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
        this.handshakeHandler = new HandshakeHandler((HandshakeSocket)this, context);
    }

    SSLSocketImpl(InetAddress address, int port, J9SSLContext context, String[] defaultCipherSuites) throws IOException, UnknownHostException {
        this.baseSocket = new Socket(address, port);
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
        this.handshakeHandler = new HandshakeHandler((HandshakeSocket)this, context);
    }

    SSLSocketImpl(String hostName, int hostPort, InetAddress clientAddress, int clientPort, J9SSLContext context, String[] defaultCipherSuites) throws IOException, UnknownHostException {
        this.baseSocket = new Socket(hostName, hostPort, clientAddress, clientPort);
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
        this.handshakeHandler = new HandshakeHandler((HandshakeSocket)this, context);
    }

    SSLSocketImpl(InetAddress hostAddress, int hostPort, InetAddress clientAddress, int clientPort, J9SSLContext context, String[] defaultCiperSuites) throws IOException, UnknownHostException {
        this.baseSocket = new Socket(hostAddress, hostPort, clientAddress, clientPort);
        this.context = context;
        this.setEnabledCipherSuites(defaultCiperSuites);
        this.handshakeHandler = new HandshakeHandler((HandshakeSocket)this, context);
    }

    SSLSocketImpl(Socket socket, SSLServerSocketImpl serverSocket) {
        this.baseSocket = socket;
        this.closeBaseSocketOnClose = true;
        this.context = serverSocket.context;
        this.setEnabledCipherSuites(serverSocket.getEnabledCipherSuites());
        this.setEnabledProtocols(serverSocket.getEnabledProtocols());
        this.setEnableSessionCreation(serverSocket.getEnableSessionCreation());
        this.setNeedClientAuth(serverSocket.getNeedClientAuth());
        this.useClientMode = serverSocket.getUseClientMode();
        this.setWantClientAuth(serverSocket.getWantClientAuth());
        this.handshakeHandler = new HandshakeHandler((HandshakeSocket)this, this.context);
    }

    SSLSocketImpl(Socket socket, String hostName, int hostPort, boolean closeBaseSocketOnClose, J9SSLContext context, String[] defaultCipherSuites) throws IOException, UnknownHostException {
        this.baseSocket = socket;
        this.closeBaseSocketOnClose = closeBaseSocketOnClose;
        this.context = context;
        this.setEnabledCipherSuites(defaultCipherSuites);
        this.handshakeHandler = new HandshakeHandler((HandshakeSocket)this, context);
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSpec.SUPPORTED_SPEC_IDS.clone();
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public CipherSpec[] getEnabledCipherSpecs() {
        return CipherSpec.getCipherSpecs((String[])this.getEnabledCipherSuites());
    }

    public void setEnabledCipherSuites(String[] enabledCipherSuites) {
        if (enabledCipherSuites == null) {
            throw new IllegalArgumentException(Msg.getString("K03ad"));
        }
        int i = 0;
        while (i < enabledCipherSuites.length) {
            if (!this.isCipherSuiteSupported(enabledCipherSuites[i])) {
                throw new IllegalArgumentException(Msg.getString("K01e6", enabledCipherSuites[i]));
            }
            ++i;
        }
        this.enabledCipherSuites = enabledCipherSuites;
    }

    public String[] getSupportedProtocols() {
        return (String[])CipherSpec.SUPPORTED_PROTOCOLS.clone();
    }

    public String[] getEnabledProtocols() {
        if (this.enabledProtocols == null) {
            this.enabledProtocols = CipherSpec.SUPPORTED_PROTOCOLS;
        }
        return (String[])this.enabledProtocols.clone();
    }

    public void setEnabledProtocols(String[] enabledProtocols) {
        if (enabledProtocols == null) {
            throw new IllegalArgumentException(Msg.getString("K03bd"));
        }
        int i = 0;
        while (i < enabledProtocols.length) {
            if (!this.isProtocolSupported(enabledProtocols[i])) {
                throw new IllegalArgumentException(Msg.getString("K00b3", enabledProtocols[i]));
            }
            ++i;
        }
        this.enabledProtocols = enabledProtocols;
    }

    private boolean isProtocolSupported(String protocol) {
        int i = 0;
        while (i < CipherSpec.SUPPORTED_PROTOCOLS.length) {
            if (CipherSpec.SUPPORTED_PROTOCOLS[i].equals(protocol)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isCipherSuiteSupported(String cipherSuite) {
        if (cipherSuite == null) {
            throw new IllegalArgumentException(Msg.getString("K03ad"));
        }
        int i = 0;
        while (i < CipherSpec.SUPPORTED_SPEC_IDS.length) {
            if (CipherSpec.SUPPORTED_SPEC_IDS[i].equals(cipherSuite)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void startHandshake() throws IOException {
        this.completeHandshake();
    }

    public void setUseClientMode(boolean useClientMode) {
        if (this.handshakeHandler.isHandShakeCompleted() || this.handshakeHandler.isHandshaking()) {
            throw new IllegalArgumentException(Msg.getString("K042d"));
        }
        this.useClientMode = useClientMode;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
        if (needClientAuth) {
            this.wantClientAuth = needClientAuth;
        }
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setEnableSessionCreation(boolean enableSessionCreation) {
        this.context.setEnableSessionCreation(enableSessionCreation);
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.socketStatus == 2) {
            throw new IOException(Msg.getString("K03ac"));
        }
        this.completeHandshake();
        if (this.inputStatus == 0) {
            this.inputStatus = 1;
            this.sslInputStream = new SSLInputStream(this.appDataQueue, this.baseInputStream);
        }
        return this.sslInputStream;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        if (this.socketStatus == 2) {
            throw new IOException(Msg.getString("K03ac"));
        }
        this.completeHandshake();
        if (this.outputStatus == 0) {
            this.outputStatus = 1;
            this.sslOutputStream = new SSLOutputStream(this.baseOutputStream);
        }
        return this.sslOutputStream;
    }

    public boolean getEnableSessionCreation() {
        return this.context.getSessionCreationEnabled();
    }

    public long getTimeoutLength() {
        try {
            return super.getSoTimeout();
        }
        catch (SocketException socketException) {
            return 0L;
        }
    }

    public boolean readData() throws IOException {
        Record record = Record.readRecord((InputStream)this.baseInputStream);
        if (record == null) {
            return false;
        }
        byte[] plainText = null;
        try {
            plainText = this.getConnectionState().decipher(record.getContentType(), this.getUseClientMode(), record.getData());
        }
        catch (IOException e) {
            this.sendSocketAlert((byte)2, (byte)20);
            throw e;
        }
        switch (record.getContentType()) {
            case 23: {
                this.appDataQueue.getWriteStream().write(plainText);
                break;
            }
            case 20: {
                this.handshakeHandler.processChangeCipherSpec(true);
                break;
            }
            case 21: {
                this.handleAlert(plainText);
                break;
            }
            case -128: 
            case 22: {
                this.handshakeHandler.notifyReceived(plainText);
            }
        }
        return true;
    }

    private void handleAlert(byte[] recordData) throws SSLException {
        if (recordData[0] == 2) {
            String message = SSLProtocol.getAlertName((byte)recordData[1]);
            try {
                this.close();
            }
            catch (IOException iOException) {}
            throw new SSLException(message);
        }
    }

    public void sendSocketAlert(byte alertLevel, byte alertType) {
        if (this.getConnectionState() == null) {
            return;
        }
        byte[] alertData = new byte[]{alertLevel, alertType};
        try {
            if (this.socketStatus == 1) {
                this.writeData(alertData, 0, alertData.length, (byte)21);
            } else {
                this.baseOutputStream = this.baseSocket.getOutputStream();
                this.writeData(alertData, 0, alertData.length, (byte)21);
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized void writeData(byte[] input, int offset, int length, byte contentType) throws IOException {
        if (contentType == 23 && !this.handshakeHandler.isHandShakeCompleted()) {
            this.completeHandshake();
        }
        int i = 0;
        while (i < length) {
            byte[] writeData = new byte[length - i < 16384 ? length - i : 16384];
            System.arraycopy(input, offset + i, writeData, 0, writeData.length);
            byte[] cipherData = this.getConnectionState().encipher(contentType, this.getUseClientMode(), writeData);
            Record writeRecord = new Record(contentType, this.getConnectionState().getProtocolVersion(), cipherData);
            writeRecord.writeRecord(this.baseOutputStream);
            i += 16384;
            if (contentType != 20) continue;
            this.handshakeHandler.processChangeCipherSpec(false);
        }
    }

    private void closeConnection() throws IOException {
        this.inputStatus = 2;
        if (this.outputStatus != 2) {
            this.sendSocketAlert((byte)1, (byte)0);
            this.outputStatus = 2;
        }
        if (this.closeBaseSocketOnClose) {
            this.baseSocket.close();
        }
    }

    private void completeHandshake() throws IOException {
        if (this.socketStatus != 0) {
            return;
        }
        this.baseInputStream = this.baseSocket.getInputStream();
        this.baseOutputStream = this.baseSocket.getOutputStream();
        if (!this.rngInitialised) {
            this.context.getRandomBytes(new byte[1]);
            this.rngInitialised = true;
        }
        try {
            this.handshakeHandler.run();
        }
        catch (IOException e) {
            if (e instanceof J9ProtocolException) {
                this.sendSocketAlert((byte)2, (byte)40);
                throw new SSLProtocolException(e.getMessage());
            }
            this.sendSocketAlert((byte)2, (byte)40);
            if (e instanceof SSLHandshakeException) {
                throw e;
            }
            throw new SSLHandshakeException(e.getMessage());
        }
        this.socketStatus = 1;
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, new SSLSession(this.getConnectionState().getSessionState(), new SSLSessionContext(this.context.getSessionContext())));
        Enumeration listeners = this.handshakeDoneListeners.elements();
        while (listeners.hasMoreElements()) {
            ((HandshakeCompletedListener)listeners.nextElement()).handshakeCompleted(event);
        }
    }

    void notifyStreamClosed() throws IOException {
        this.closeConnection();
    }

    public String getHostName() {
        if (this.getInetAddress() == null) {
            return null;
        }
        return this.getInetAddress().getHostName();
    }

    public void bind(SocketAddress localAddr) throws IOException {
        this.baseSocket.bind(localAddr);
    }

    public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
        this.baseSocket.connect(remoteAddr, timeout);
    }

    public void connect(SocketAddress remoteAddr) throws IOException {
        this.baseSocket.connect(remoteAddr);
    }

    public InetAddress getLocalAddress() {
        return this.baseSocket.getLocalAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.baseSocket.getOOBInline();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.baseSocket.getLocalSocketAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.baseSocket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.baseSocket.getReuseAddress();
    }

    public int getTrafficClass() throws SocketException {
        return this.baseSocket.getTrafficClass();
    }

    public boolean isBound() {
        return this.baseSocket.isBound();
    }

    public boolean isConnected() {
        return this.baseSocket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.baseSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.baseSocket.isOutputShutdown();
    }

    public void sendUrgentData(int value) throws IOException {
        this.baseSocket.sendUrgentData(value);
    }

    public void setOOBInline(boolean oobinline) throws SocketException {
        this.baseSocket.setOOBInline(oobinline);
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        this.baseSocket.setReuseAddress(reuse);
    }

    public void setTrafficClass(int value) throws SocketException {
        this.baseSocket.setTrafficClass(value);
    }

    public InetAddress getInetAddress() {
        return this.baseSocket.getInetAddress();
    }

    public boolean getKeepAlive() throws SocketException {
        return this.baseSocket.getKeepAlive();
    }

    public int getLocalPort() {
        return this.baseSocket.getLocalPort();
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.baseSocket.getReceiveBufferSize();
    }

    public synchronized int getSendBufferSize() throws SocketException {
        return this.baseSocket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.baseSocket.getSoLinger();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.baseSocket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.baseSocket.getTcpNoDelay();
    }

    public boolean isClosed() {
        return this.socketStatus == 2;
    }

    public void setKeepAlive(boolean value) throws SocketException {
        this.baseSocket.setKeepAlive(value);
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.baseSocket.setReceiveBufferSize(size);
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.baseSocket.setSendBufferSize(size);
    }

    public void setSoLinger(boolean on, int timeout) throws SocketException {
        this.baseSocket.setSoLinger(on, timeout);
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.baseSocket.setSoTimeout(timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.baseSocket.setTcpNoDelay(on);
    }

    public void shutdownInput() throws IOException {
        this.baseSocket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.baseSocket.shutdownOutput();
    }

    public String toString() {
        return this.baseSocket.toString();
    }

    public synchronized javax.net.ssl.SSLSession getSession() {
        try {
            this.completeHandshake();
        }
        catch (IOException iOException) {
            return new SSLSession(null, null);
        }
        return new SSLSession(this.getConnectionState().getSessionState(), new SSLSessionContext(this.context.getSessionContext()));
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Msg.getString("K03af"));
        }
        this.handshakeDoneListeners.add(listener);
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(Msg.getString("K03af"));
        }
        if (!this.handshakeDoneListeners.contains(listener)) {
            throw new IllegalArgumentException(Msg.getString("K03b0"));
        }
        this.handshakeDoneListeners.remove(listener);
    }

    public ConnectionState getConnectionState() {
        return this.handshakeHandler.getConnectionState();
    }

    public void sendChangeCipherSpec() throws IOException {
        this.writeData(new byte[]{1}, 0, 1, (byte)20);
    }

    private final class SSLOutputStream
    extends OutputStream {
        SSLOutputStream(OutputStream outputStream) {
        }

        public void write(byte[] buffer, int offset, int count) throws IOException {
            SSLSocketImpl.this.writeData(buffer, offset, count, (byte)23);
        }

        public void write(byte[] buffer) throws IOException {
            SSLSocketImpl.this.writeData(buffer, 0, buffer.length, (byte)23);
        }

        public void write(int oneByte) throws IOException {
            this.write(new byte[]{(byte)oneByte});
        }

        public void close() throws IOException {
            if (SSLSocketImpl.this.outputStatus == 1) {
                SSLSocketImpl.this.outputStatus = 2;
            }
            SSLSocketImpl.this.notifyStreamClosed();
        }
    }

    private final class SSLInputStream
    extends InputStream {
        private final StreamQueue applicationDataInputQueue;
        private InputStream inputStream;

        SSLInputStream(StreamQueue applicationDataInputQueue, InputStream inputStream) {
            this.applicationDataInputQueue = applicationDataInputQueue;
            this.inputStream = inputStream;
        }

        public int available() throws IOException {
            if (SSLSocketImpl.this.inputStatus != 1) {
                throw new IOException(Msg.getString("K03ac"));
            }
            if (this.applicationDataInputQueue.getReadStream().available() == 0) {
                return 0;
            }
            boolean keepReading = true;
            while (keepReading && this.applicationDataInputQueue.getReadStream().available() == 0 && this.inputStream.available() > 0) {
                keepReading = SSLSocketImpl.this.readData();
            }
            return this.applicationDataInputQueue.getReadStream().available();
        }

        public int read() throws IOException {
            if (SSLSocketImpl.this.inputStatus != 1) {
                throw new IOException(Msg.getString("K03ac"));
            }
            boolean keepReading = true;
            while (keepReading && this.applicationDataInputQueue.getReadStream().available() == 0) {
                keepReading = SSLSocketImpl.this.readData();
            }
            if (this.applicationDataInputQueue.getReadStream().available() == 0) {
                return -1;
            }
            return this.applicationDataInputQueue.getReadStream().read();
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            if (SSLSocketImpl.this.inputStatus != 1) {
                throw new IOException(Msg.getString("K03ac"));
            }
            boolean keepReading = true;
            while (keepReading && this.applicationDataInputQueue.getReadStream().available() == 0) {
                keepReading = SSLSocketImpl.this.readData();
            }
            while (keepReading && this.inputStream.available() > 0 && this.applicationDataInputQueue.getReadStream().available() < length) {
                keepReading = SSLSocketImpl.this.readData();
            }
            if (!keepReading && this.applicationDataInputQueue.getReadStream().available() == 0) {
                return -1;
            }
            return this.applicationDataInputQueue.getReadStream().read(b, offset, length);
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public void close() throws IOException {
            SSLSocketImpl.this.inputStatus = 2;
            if (this.inputStream != null) {
                this.inputStream = null;
            }
            SSLSocketImpl.this.notifyStreamClosed();
        }
    }
}

