/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.net.www.protocol.https;

import com.ibm.j9.jsse.SSLProxySocketFactory;
import com.ibm.j9.jsse.support.Msg;
import com.ibm.oti.net.www.protocol.http.AuthCredential;
import com.ibm.oti.net.www.protocol.http.AuthCredentialCache;
import com.ibm.oti.net.www.protocol.http.BasicRequestHeader;
import com.ibm.oti.net.www.protocol.http.ConnectionInfo;
import com.ibm.oti.net.www.protocol.http.DigestRequestHeader;
import com.ibm.oti.net.www.protocol.http.Header;
import com.ibm.oti.security.provider.X500Principal;
import com.ibm.oti.util.PriviAction;
import com.ibm.oti.vm.VM;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public final class HttpsURLConnection
extends javax.net.ssl.HttpsURLConnection {
    private static final int MAX_ATTEMPTS = 15;
    SSLSocket sslSocket = null;
    int httpVersion = 1;
    private final int defaultPort;
    InputStream is;
    private InputStream uis;
    OutputStream socketOut;
    private HttpOutputStream os;
    private boolean sentRequest = false;
    boolean sendChunked = false;
    String proxyName;
    private int hostPort = -1;
    private int connectTimeout = this.getTimeout("com.ibm.oti.net.HttpConnectionConnectTimeout");
    private int readTimeout = this.getTimeout("com.ibm.oti.net.HttpConnectionReadTimeout");
    private static Header defaultReqHeader = new Header();
    public static AuthCredentialCache authenticationCache = new AuthCredentialCache();
    private Header reqHeader;
    private Header resHeader;
    private static Timer cacheTimer;
    private static Hashtable socketCache;
    private boolean reusingSocket = false;
    private String httpsProxyHost;
    private int httpsProxyPortInt;
    private AuthCredential serverCredential;
    private AuthCredential proxyCredential;

    protected HttpsURLConnection(URL url) throws IOException {
        this(url, 80);
    }

    private int getTimeout(String property) {
        try {
            return Integer.parseInt(HttpsURLConnection.getSystemProperty(property));
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected HttpsURLConnection(URL url, int port) throws IOException {
        super(url);
        this.defaultPort = port;
        this.reqHeader = (Header)defaultReqHeader.clone();
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.openNetworkInterfaceAndUpdateProxyInformation();
        Socket socket = this.openSocket();
        if (this.readTimeout >= 0) {
            socket.setSoTimeout(this.readTimeout);
        }
        this.connected = true;
        this.socketOut = socket.getOutputStream();
        try {
            this.socketOut = socket.getOutputStream();
        }
        catch (IOException e) {
            if (this.isReusingSocket()) {
                this.connected = false;
                socket.close();
                this.connect();
                return;
            }
            throw e;
        }
        this.is = new BufferedInputStream(socket.getInputStream());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Socket openSocket() throws IOException {
        boolean hostNameVerifierResult;
        if (this.usingSSLTunnel()) {
            this.httpsProxyHost = HttpsURLConnection.getSystemProperty("https.proxyHost");
            String httpsProxyPort = HttpsURLConnection.getSystemProperty("https.proxyPort");
            try {
                this.httpsProxyPortInt = Integer.parseInt(httpsProxyPort);
            }
            catch (NumberFormatException numberFormatException) {
                this.httpsProxyPortInt = 80;
            }
            this.sslSocket = HttpsURLConnection.getSocketFromCache(this.getHostName(), this.getHostPort(), this.httpsProxyHost, this.httpsProxyPortInt);
            if (this.sslSocket != null) {
                this.reusingSocket = true;
                return this.sslSocket;
            }
            this.reusingSocket = false;
            String agent = HttpsURLConnection.getSystemProperty("http.agent");
            if (agent == null) {
                agent = "Java" + HttpsURLConnection.getSystemProperty("java.version");
            }
            SSLProxySocketFactory proxyFactory = new SSLProxySocketFactory(this.httpsProxyHost, this.httpsProxyPortInt, this.getSSLSocketFactory(), agent);
            this.sslSocket = (SSLSocket)proxyFactory.createSocket(this.url.getHost(), this.getHostPort(), this.connectTimeout > 0 ? this.connectTimeout : 0);
        } else {
            this.sslSocket = HttpsURLConnection.getSocketFromCache(this.getHostName(), this.getHostPort(), null, 0);
            if (this.sslSocket != null) {
                this.reusingSocket = true;
                return this.sslSocket;
            }
            this.reusingSocket = false;
            this.sslSocket = (SSLSocket)this.getSSLSocketFactory().createSocket();
            this.sslSocket.connect(new InetSocketAddress(this.url.getHost(), this.getHostPort()), this.connectTimeout > 0 ? this.connectTimeout : 0);
        }
        this.sslSocket.startHandshake();
        boolean hostNameCheckResult = this.verify(this.getHostName(), this.sslSocket.getSession());
        if (!hostNameCheckResult && !(hostNameVerifierResult = this.hostnameVerifier.verify(this.getHostName(), this.sslSocket.getSession()))) {
            throw new IOException(Msg.getString("K03b4"));
        }
        return this.sslSocket;
    }

    protected void openNetworkInterfaceAndUpdateProxyInformation() {
        String httpsProxyHost = HttpsURLConnection.getSystemProperty("https.proxyHost");
        String httpsProxyPort = HttpsURLConnection.getSystemProperty("https.proxyPort");
        if (httpsProxyHost == null || httpsProxyPort == null) {
            final String[] proxyValues = VM.getHttpProxyParms();
            if (proxyValues == null) {
                return;
            }
            this.proxyName = proxyValues[0];
            this.hostPort = Integer.parseInt(proxyValues[1]);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Properties props = System.getProperties();
                    props.setProperty("https.proxyHost", HttpsURLConnection.this.proxyName);
                    props.setProperty("https.proxyPort", proxyValues[1]);
                    return null;
                }
            });
        }
    }

    public boolean isReusingSocket() {
        boolean retval = this.reusingSocket;
        return retval;
    }

    private static String getSockDescriptor(String hostName, int hostPort, String proxyName, int proxyPort) {
        StringBuffer sb = new StringBuffer();
        sb.append(hostName);
        sb.append(':');
        sb.append(hostPort);
        sb.append(':');
        sb.append(proxyName);
        sb.append(':');
        sb.append(proxyPort);
        return sb.toString();
    }

    private static SSLSocket getSocketFromCache(String hostName, int hostPort, String proxyHost, int proxyPort) {
        if (socketCache == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)socketCache.remove(HttpsURLConnection.getSockDescriptor(hostName, hostPort, proxyHost, proxyPort));
        if (cacheEntry != null) {
            cacheEntry.cancelTimerTask();
            return cacheEntry.getSocket();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSocketToCache(final String hostName, final int hostPort, final String proxyHost, final int proxyPort, int serverTimeout, final SSLSocket socket) {
        String doKeepAlive;
        if (socketCache == null) {
            socketCache = new Hashtable();
        }
        if (cacheTimer == null) {
            cacheTimer = new Timer(true);
        }
        if ((doKeepAlive = HttpsURLConnection.getSystemProperty("http.keepAlive")) != null && !"true".equalsIgnoreCase(doKeepAlive)) {
            return;
        }
        String maxConnProp = HttpsURLConnection.getSystemProperty("http.maxConnections");
        int maxConn = maxConnProp == null ? 5 : Integer.parseInt(maxConnProp);
        if (maxConn <= 0) {
            return;
        }
        String maxTimeout = HttpsURLConnection.getSystemProperty("http.defaultKeepAliveTimeout");
        int timeout = maxTimeout == null ? 15000 : Integer.parseInt(maxTimeout) * 1000;
        if (timeout <= 0) {
            return;
        }
        if (serverTimeout > 0) {
            timeout = serverTimeout * 1000;
        }
        Hashtable hashtable = socketCache;
        synchronized (hashtable) {
            if (socketCache.size() >= maxConn) {
                CacheEntry cacheEntry = (CacheEntry)socketCache.remove(socketCache.keys().nextElement());
                cacheEntry.closeSocket();
            }
        }
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean close = false;
                CacheEntry cacheEntry = null;
                String descriptor = HttpsURLConnection.getSockDescriptor(hostName, hostPort, proxyHost, proxyPort);
                Hashtable hashtable = socketCache;
                synchronized (hashtable) {
                    cacheEntry = (CacheEntry)socketCache.get(descriptor);
                    if (cacheEntry != null && cacheEntry.getSocket() == socket) {
                        close = true;
                        socketCache.remove(descriptor);
                    }
                }
                if (close) {
                    cacheEntry.closeSocket();
                }
            }
        };
        cacheTimer.schedule(task, timeout);
        CacheEntry oldEntry = socketCache.put(HttpsURLConnection.getSockDescriptor(hostName, hostPort, proxyHost, proxyPort), new CacheEntry(socket, task));
        if (oldEntry != null) {
            oldEntry.closeSocket();
        }
    }

    private boolean canReuseSocket() {
        if (this.resHeader == null || this.resHeader.getStatusLine() == null) {
            return false;
        }
        String strConnection = this.resHeader.get("Connection");
        if ("close".equalsIgnoreCase(strConnection)) {
            return false;
        }
        if (this.resHeader.getStatusLine().startsWith("HTTP/1.0") && !"keep-alive".equalsIgnoreCase(strConnection)) {
            return false;
        }
        if (this.uis == null) {
            return false;
        }
        try {
            if (this.uis.read() != -1) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return this.sslSocket != null;
    }

    public void setReadTimeout(int value) {
        if (value < 0) {
            throw new IllegalArgumentException(Msg.getString("K0036"));
        }
        this.readTimeout = value;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException(Msg.getString("K0036"));
        }
        this.connectTimeout = timeout;
    }

    public void disconnect() {
        try {
            this.closeSocket();
        }
        catch (IOException iOException) {}
    }

    private int getKeepAliveTimeoutFromResponse() {
        String serverTimeoutResponse = this.resHeader.get("Keep-Alive");
        int serverTimeoutResponseInt = 0;
        if (serverTimeoutResponse != null) {
            StringTokenizer t = new StringTokenizer(serverTimeoutResponse, "=, ");
            while (t.hasMoreElements()) {
                if (!"timeout".equalsIgnoreCase((String)t.nextElement())) continue;
                try {
                    serverTimeoutResponseInt = Integer.parseInt((String)t.nextElement());
                }
                catch (NumberFormatException numberFormatException) {
                    serverTimeoutResponseInt = 0;
                }
            }
        }
        return serverTimeoutResponseInt;
    }

    void closeSocket() throws IOException {
        if (this.canReuseSocket()) {
            HttpsURLConnection.addSocketToCache(this.getHostName(), this.getHostPort(), this.httpsProxyHost, this.httpsProxyPortInt, this.getKeepAliveTimeoutFromResponse(), this.sslSocket);
        } else if (this.is != null) {
            this.is.close();
        }
    }

    void endRequest() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
        this.sentRequest = false;
    }

    public static String getDefaultRequestProperty(String field) {
        return defaultReqHeader.get(field);
    }

    public InputStream getErrorStream() {
        if (this.connected && this.method != "HEAD" && this.responseCode >= 400) {
            return this.uis;
        }
        return null;
    }

    public String getHeaderField(int pos) {
        try {
            this.getInputStream();
            return this.resHeader.get(pos);
        }
        catch (IOException iOException) {
            if (this.resHeader != null) {
                return this.resHeader.get(pos);
            }
            return null;
        }
    }

    public String getHeaderField(String key) {
        try {
            this.getInputStream();
            return this.resHeader.get(key);
        }
        catch (IOException iOException) {
            if (this.resHeader != null) {
                return this.resHeader.get(key);
            }
            return null;
        }
    }

    public String getHeaderFieldKey(int pos) {
        try {
            this.getInputStream();
            return this.resHeader.getKey(pos);
        }
        catch (IOException iOException) {
            if (this.resHeader != null) {
                return this.resHeader.getKey(pos);
            }
            return null;
        }
    }

    public Map getHeaderFields() {
        return this.resHeader.getFieldMap();
    }

    public Map getRequestProperties() {
        return this.reqHeader.getFieldMap();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException(Msg.getString("K008d"));
        }
        this.doRequest();
        if (this.responseCode >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        return this.uis;
    }

    private InputStream getContentStream() throws IOException {
        if (this.uis != null) {
            return this.uis;
        }
        String encoding = this.resHeader.get("Transfer-Encoding");
        if (encoding != null && encoding.toLowerCase().equals("chunked")) {
            this.uis = new ChunkedInputStream();
            return this.uis;
        }
        String sLength = this.resHeader.get("Content-Length");
        if (sLength != null) {
            try {
                int length = Integer.parseInt(sLength);
                this.uis = new LimitedInputStream(length);
                return this.uis;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.uis = this.is;
        return this.uis;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new ProtocolException(Msg.getString("K008e"));
        }
        if (this.sentRequest) {
            throw new ProtocolException(Msg.getString("K0090"));
        }
        if (this.os != null) {
            return this.os;
        }
        if (this.method == "GET") {
            this.method = "POST";
        }
        if (this.method != "PUT" && this.method != "POST") {
            throw new ProtocolException(Msg.getString("K008f", this.method));
        }
        int limit = -1;
        String contentLength = this.reqHeader.get("Content-Length");
        if (contentLength != null) {
            limit = Integer.parseInt(contentLength);
        }
        String encoding = this.reqHeader.get("Transfer-Encoding");
        if (this.httpVersion > 0 && encoding != null && "chunked".equals(encoding = encoding.toLowerCase())) {
            this.sendChunked = true;
            limit = -1;
        }
        if (this.httpVersion > 0 && this.sendChunked || limit >= 0) {
            this.os = new HttpOutputStream(limit);
            this.doRequest();
            return this.os;
        }
        this.os = new HttpOutputStream();
        return this.os;
    }

    public Permission getPermission() throws IOException {
        return new SocketPermission(String.valueOf(this.getHostName()) + ":" + this.getHostPort(), "connect, resolve");
    }

    public String getRequestProperty(String field) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0091"));
        }
        return this.reqHeader.get(field);
    }

    /*
     * Unable to fully structure code
     */
    String readln() throws IOException {
        lastCr = false;
        result = new StringBuffer(80);
        c = this.is.read();
        if (c >= 0) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            if (lastCr) {
                result.append('\r');
                lastCr = false;
            }
            if (c == 13) {
                lastCr = true;
            } else {
                result.append((char)c);
            }
            c = this.is.read();
            if (c < 0) break;
lbl17:
            // 2 sources

            ** while (c != 10)
        }
lbl18:
        // 2 sources

        return result.toString();
    }

    private String requestString() {
        if (this.usingProxy() || this.proxyName != null) {
            return this.url.toString();
        }
        String file = this.url.getFile();
        if (file == null || file.length() == 0) {
            file = "/";
        }
        return file;
    }

    private boolean sendRequest() throws IOException {
        byte[] request = this.createRequest();
        while (true) {
            try {
                if (!this.connected) {
                    this.connect();
                }
                this.socketOut.write(request);
                this.sentRequest = true;
                if (this.os != null && this.os.isCached()) {
                    this.socketOut.write(this.os.toByteArray());
                }
                if (this.os == null || this.os.isCached()) {
                    this.readServerResponse();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                if (!this.isReusingSocket()) {
                    throw e;
                }
                this.sslSocket = null;
                this.closeSocket();
                this.connected = false;
                this.sentRequest = false;
                if (this.isReusingSocket()) continue;
                return false;
            }
            break;
        }
    }

    void readServerResponse() throws IOException {
        this.socketOut.flush();
        do {
            this.responseCode = -1;
            this.responseMessage = null;
            this.resHeader = new Header();
            String line = this.readln();
            if (line == null && this.isReusingSocket()) {
                this.connected = false;
                this.sentRequest = false;
                this.closeSocket();
                this.sendRequest();
                return;
            }
            if (line == null) continue;
            this.resHeader.setStatusLine(line.trim());
            this.readHeaders();
        } while (this.getResponseCode() == 100);
        if (this.method == "HEAD" || this.responseCode >= 100 && this.responseCode < 200 || this.responseCode == 204 || this.responseCode == 304) {
            this.closeSocket();
            this.uis = new LimitedInputStream(0);
        }
    }

    public int getResponseCode() throws IOException {
        int last;
        this.doRequest();
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        String response = this.resHeader.getStatusLine();
        if (response == null || !response.startsWith("HTTP/")) {
            return -1;
        }
        response.trim();
        int mark = response.indexOf(" ") + 1;
        if (mark == 0) {
            return -1;
        }
        if (response.charAt(mark - 2) != '1') {
            this.httpVersion = 0;
        }
        if ((last = mark + 3) > response.length()) {
            last = response.length();
        }
        this.responseCode = Integer.parseInt(response.substring(mark, last));
        if (last + 1 <= response.length()) {
            this.responseMessage = response.substring(last + 1);
        }
        return this.responseCode;
    }

    void readHeaders() throws IOException {
        String line;
        while ((line = this.readln()) != null && line.length() > 1) {
            int idx = line.indexOf(":");
            if (idx < 0) {
                this.resHeader.add("", line.trim());
                continue;
            }
            this.resHeader.add(line.substring(0, idx), line.substring(idx + 1).trim());
        }
    }

    private byte[] createRequest() throws IOException {
        StringBuffer output = new StringBuffer(256);
        output.append(this.method);
        output.append(' ');
        output.append(this.requestString());
        output.append(' ');
        output.append("HTTP/1.");
        if (this.httpVersion == 0) {
            output.append("0\r\n");
        } else {
            output.append("1\r\n");
        }
        if (this.reqHeader.get("User-Agent") == null) {
            output.append("User-Agent: ");
            String agent = HttpsURLConnection.getSystemProperty("http.agent");
            if (agent == null) {
                output.append("Java");
                output.append(HttpsURLConnection.getSystemProperty("java.version"));
            } else {
                output.append(agent);
            }
            output.append("\r\n");
        }
        if (this.reqHeader.get("Host") == null) {
            output.append("Host: ");
            output.append(this.url.getHost());
            int port = this.url.getPort();
            if (port > 0 && port != this.defaultPort) {
                output.append(':');
                output.append(Integer.toString(port));
            }
            output.append("\r\n");
        }
        if (this.reqHeader.get("Connection") == null) {
            if (this.httpVersion < 1) {
                output.append("Connection: close\r\n");
            } else {
                output.append("Connection: keep-alive\r\n");
            }
        }
        if (this.os != null) {
            if (this.reqHeader.get("Content-Type") == null) {
                output.append("Content-Type: application/x-www-form-urlencoded\r\n");
            }
            if (this.os.isCached()) {
                if (this.reqHeader.get("Content-Length") == null) {
                    output.append("Content-Length: ");
                    output.append(Integer.toString(this.os.size()));
                    output.append("\r\n");
                }
            } else if (this.os.isChunked()) {
                output.append("Transfer-Encoding: chunked\r\n");
            }
        }
        int i = 0;
        while (i < this.reqHeader.length()) {
            String key = this.reqHeader.getKey(i);
            if (key != null) {
                String lKey = key.toLowerCase();
                if (this.os != null && !this.os.isChunked() || !lKey.equals("transfer-encoding") && !lKey.equals("content-length")) {
                    output.append(key);
                    output.append(": ");
                    output.append(this.reqHeader.get(i));
                    output.append("\r\n");
                }
            }
            ++i;
        }
        output.append("\r\n");
        return output.toString().getBytes("ISO8859_1");
    }

    public static void setDefaultRequestProperty(String field, String value) {
        defaultReqHeader.add(field, value);
    }

    public void setIfModifiedSince(long newValue) throws IllegalAccessError {
        super.setIfModifiedSince(newValue);
        SimpleDateFormat sdf = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String date = sdf.format(new Date(newValue));
        this.reqHeader.add("If-Modified-Since", date);
    }

    public void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0092"));
        }
        if (field == null) {
            throw new NullPointerException();
        }
        this.reqHeader.set(field, newValue);
    }

    public void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0092"));
        }
        if (field == null) {
            throw new NullPointerException();
        }
        this.reqHeader.add(field, value);
    }

    protected int getHostPort() {
        if (this.hostPort != -1) {
            return this.hostPort;
        }
        String portString = this.getSystemPropertyOrAlternative("https.proxyPort", "proxyPort");
        this.hostPort = portString != null && this.usingProxy() ? Integer.parseInt(portString) : this.url.getPort();
        if (this.hostPort < 0) {
            this.hostPort = this.defaultPort;
        }
        return this.hostPort;
    }

    protected String getHostName() {
        if (this.proxyName != null) {
            return this.proxyName;
        }
        if (this.usingProxy()) {
            this.proxyName = this.getSystemPropertyOrAlternative("https.proxyHost", "proxyHost");
            return this.proxyName;
        }
        return this.url.getHost();
    }

    private String getSystemPropertyOrAlternative(String key, String alternativeKey) {
        String value = HttpsURLConnection.getSystemProperty(key);
        if (value == null) {
            value = HttpsURLConnection.getSystemProperty(alternativeKey);
        }
        return value;
    }

    private static String getSystemProperty(String property) {
        String retval = (String)AccessController.doPrivileged(new PriviAction(property));
        return retval;
    }

    public boolean usingProxy() {
        return false;
    }

    public boolean usingSSLTunnel() {
        boolean useProxy = true;
        String proxySet = HttpsURLConnection.getSystemProperty("https.proxySet");
        if (proxySet != null && proxySet.toLowerCase().equals("false")) {
            useProxy = false;
        }
        String host = HttpsURLConnection.getSystemProperty("https.proxyHost");
        return useProxy && host != null && host != "";
    }

    void doRequest() throws IOException {
        if (this.sentRequest) {
            if (this.resHeader == null && this.os != null) {
                this.os.close();
                this.readServerResponse();
                this.getContentStream();
            }
            return;
        }
        int redirect = 0;
        int attempts = 0;
        while (attempts < 15) {
            ConnectionInfo connectionInfo = new ConnectionInfo(this.getURL().getHost(), this.getRequestPort(), this.getURL().getProtocol(), this.getRequestMethod(), this.getURL().getFile());
            if (this.proxyCredential != null) {
                if (this.proxyCredential.getPasswordAuthentication() == null) {
                    return;
                }
                this.setRequestProperty(this.proxyCredential.getDirective(), this.proxyCredential.getAuthorizationResponse());
            }
            if (this.serverCredential != null) {
                if (this.serverCredential.getPasswordAuthentication() == null) {
                    return;
                }
                this.setRequestProperty(this.serverCredential.getDirective(), this.serverCredential.getAuthorizationResponse());
            }
            if (!this.sendRequest()) {
                return;
            }
            if (this.responseCode == 401 | this.responseCode == 407) {
                String challenge = null;
                int type = 0;
                if (this.responseCode == 401) {
                    challenge = this.resHeader.get("WWW-Authenticate");
                    type = 1;
                } else if (this.responseCode == 407) {
                    challenge = this.resHeader.get("Proxy-Authenticate");
                    type = 2;
                    connectionInfo = new ConnectionInfo(this.getHostName(), this.getRequestPort(), this.getURL().getProtocol(), this.getRequestMethod(), this.getURL().getFile());
                }
                if (challenge == null) break;
                int idx = challenge.indexOf(32);
                String scheme = challenge.substring(0, idx);
                AuthCredential credential = null;
                if (scheme.equals("Digest")) {
                    credential = this.getCredential((AuthCredential)new DigestRequestHeader(type, challenge, connectionInfo));
                } else {
                    if (!scheme.equals("Basic")) break;
                    credential = this.getCredential((AuthCredential)new BasicRequestHeader(type, challenge, connectionInfo));
                }
                if (credential == null) break;
                if (this.responseCode == 407) {
                    this.proxyCredential = credential;
                } else {
                    this.serverCredential = credential;
                }
                this.endRequest();
                this.closeSocket();
                this.connected = false;
                ++attempts;
                continue;
            }
            attempts = 0;
            if (this.proxyCredential != null) {
                authenticationCache.put(this.proxyCredential);
            }
            if (this.serverCredential != null) {
                authenticationCache.put(this.serverCredential);
            }
            if (!this.getInstanceFollowRedirects() || this.responseCode != 300 && this.responseCode != 301 && this.responseCode != 302 && this.responseCode != 303 && this.responseCode != 305 || this.os != null) break;
            if (++redirect > 4) {
                throw new ProtocolException(Msg.getString("K0093"));
            }
            String location = this.getHeaderField("Location");
            if (location == null) break;
            if (this.responseCode == 305) {
                int start = 0;
                if (location.startsWith(String.valueOf(this.url.getProtocol()) + ':')) {
                    start = this.url.getProtocol().length() + 1;
                }
                if (location.startsWith("//", start)) {
                    start += 2;
                }
                this.setProxy(location.substring(start));
            } else {
                this.url = new URL(this.url, location);
                connectionInfo.setURI(this.url.getFile());
                if (this.proxyCredential != null || this.serverCredential != null) {
                    this.endRequest();
                    this.closeSocket();
                    this.sentRequest = false;
                    this.connected = false;
                    if (this.proxyCredential != null) {
                        this.removeRequestProperty(this.proxyCredential.getDirective());
                    }
                    if (this.serverCredential == null) continue;
                    this.removeRequestProperty(this.serverCredential.getDirective());
                    continue;
                }
                this.hostPort = -1;
            }
            this.endRequest();
            this.closeSocket();
            this.sentRequest = false;
            this.connected = false;
        }
        this.getContentStream();
    }

    private int getRequestPort() {
        int port = this.getURL().getPort();
        if (port == -1) {
            port = this.getURL().getDefaultPort();
        }
        return port;
    }

    private AuthCredential getCredential(AuthCredential localCredential) throws IOException {
        AuthCredential cachedCredential = authenticationCache.get(localCredential);
        if (cachedCredential != null) {
            return cachedCredential;
        }
        return localCredential;
    }

    private void setProxy(String proxy) {
        int index = proxy.indexOf(58);
        if (index == -1) {
            this.proxyName = proxy;
            this.hostPort = this.defaultPort;
        } else {
            this.proxyName = proxy.substring(0, index);
            String port = proxy.substring(index + 1);
            try {
                this.hostPort = Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Msg.getString("K00af", port));
            }
            if (this.hostPort < 0 || this.hostPort > 65535) {
                throw new IllegalArgumentException(Msg.getString("K00b0"));
            }
        }
    }

    public String getCipherSuite() {
        if (this.sslSocket == null || !this.sslSocket.isConnected()) {
            throw new IllegalStateException(Msg.getString("K0074"));
        }
        return this.sslSocket.getSession().getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        if (this.sslSocket == null || !this.sslSocket.isConnected()) {
            throw new IllegalStateException(Msg.getString("K0074"));
        }
        return this.sslSocket.getSession().getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        if (this.sslSocket == null || !this.sslSocket.isConnected()) {
            throw new IllegalStateException(Msg.getString("K0074"));
        }
        return this.sslSocket.getSession().getPeerCertificates();
    }

    private boolean verify(String hostName, SSLSession sslSession) {
        Certificate[] serverCertificates;
        if (hostName == null || sslSession == null) {
            return false;
        }
        try {
            serverCertificates = sslSession.getPeerCertificates();
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return false;
        }
        int i = 0;
        while (i != serverCertificates.length) {
            X509Certificate serverX509Certificate;
            String hostCertCommonName;
            if (serverCertificates[i] instanceof X509Certificate && (hostCertCommonName = HttpsURLConnection.getX509CertSubjectCommonName(serverX509Certificate = (X509Certificate)serverCertificates[i])) != null && hostName.equalsIgnoreCase(hostCertCommonName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String getX509CertSubjectCommonName(X509Certificate cert) {
        String serverSubjectDN = cert.getSubjectDN().getName();
        X500Principal serverSubjectPrincipal = new X500Principal(serverSubjectDN);
        return serverSubjectPrincipal.getValueForKey("CN");
    }

    public void removeRequestProperty(String field) {
        if (this.connected) {
            throw new IllegalAccessError(Msg.getString("K0092"));
        }
        if (field == null) {
            throw new NullPointerException();
        }
        this.reqHeader.remove(field);
    }

    private static class CacheEntry {
        private SSLSocket socket;
        private TimerTask timerTask;

        public CacheEntry(SSLSocket aSocket, TimerTask aTimerTask) {
            this.socket = aSocket;
            this.timerTask = aTimerTask;
        }

        public SSLSocket getSocket() {
            return this.socket;
        }

        public void closeSocket() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            this.timerTask.cancel();
        }

        public void cancelTimerTask() {
            this.timerTask.cancel();
        }
    }

    private class LimitedInputStream
    extends InputStream {
        int bytesRemaining;

        public LimitedInputStream(int length) {
            this.bytesRemaining = length;
        }

        public void close() throws IOException {
            HttpsURLConnection.this.closeSocket();
            this.bytesRemaining = 0;
        }

        public int available() throws IOException {
            int result = HttpsURLConnection.this.is.available();
            if (result > this.bytesRemaining) {
                return this.bytesRemaining;
            }
            return result;
        }

        public int read() throws IOException {
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            int result = HttpsURLConnection.this.is.read();
            --this.bytesRemaining;
            return result;
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            int result;
            if (buf == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || offset > buf.length || buf.length - offset < length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.bytesRemaining <= 0) {
                return -1;
            }
            if (length > this.bytesRemaining) {
                length = this.bytesRemaining;
            }
            if ((result = HttpsURLConnection.this.is.read(buf, offset, length)) > 0) {
                this.bytesRemaining -= result;
            }
            return result;
        }

        public long skip(int amount) throws IOException {
            long result;
            if (this.bytesRemaining <= 0) {
                return -1L;
            }
            if (amount > this.bytesRemaining) {
                amount = this.bytesRemaining;
            }
            if ((result = HttpsURLConnection.this.is.skip(amount)) > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - result);
            }
            return result;
        }
    }

    private class ChunkedInputStream
    extends InputStream {
        int bytesRemaining = -1;
        boolean atEnd = false;

        public ChunkedInputStream() throws IOException {
            this.readChunkSize();
        }

        public void close() throws IOException {
            HttpsURLConnection.this.closeSocket();
            this.atEnd = true;
        }

        public int available() throws IOException {
            int result = HttpsURLConnection.this.is.available();
            if (result > this.bytesRemaining) {
                return this.bytesRemaining;
            }
            return result;
        }

        private void readChunkSize() throws IOException {
            String size;
            int index;
            if (this.atEnd) {
                return;
            }
            if (this.bytesRemaining == 0) {
                HttpsURLConnection.this.readln();
            }
            if ((index = (size = HttpsURLConnection.this.readln()).indexOf(59)) >= 0) {
                size = size.substring(0, index);
            }
            this.bytesRemaining = Integer.parseInt(size.trim(), 16);
            if (this.bytesRemaining == 0) {
                this.atEnd = true;
                HttpsURLConnection.this.readHeaders();
            }
        }

        public int read() throws IOException {
            if (this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            --this.bytesRemaining;
            return HttpsURLConnection.this.is.read();
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            int result;
            if (buf == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || offset > buf.length || buf.length - offset < length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (this.atEnd) {
                return -1;
            }
            if (length > this.bytesRemaining) {
                length = this.bytesRemaining;
            }
            if ((result = HttpsURLConnection.this.is.read(buf, offset, length)) > 0) {
                this.bytesRemaining -= result;
            }
            return result;
        }

        public long skip(int amount) throws IOException {
            long result;
            if (this.atEnd) {
                return -1L;
            }
            if (this.bytesRemaining <= 0) {
                this.readChunkSize();
            }
            if (amount > this.bytesRemaining) {
                amount = this.bytesRemaining;
            }
            if ((result = HttpsURLConnection.this.is.skip(amount)) > 0L) {
                this.bytesRemaining = (int)((long)this.bytesRemaining - result);
            }
            return result;
        }
    }

    private class HttpOutputStream
    extends OutputStream {
        static final int MAX = 1024;
        ByteArrayOutputStream cache = new ByteArrayOutputStream(1031);
        boolean writeToSocket;
        boolean closed = false;
        int limit;

        public HttpOutputStream() {
            this.limit = -1;
        }

        public HttpOutputStream(int limit) {
            this.writeToSocket = true;
            this.limit = limit;
        }

        private void output(String output) throws IOException {
            HttpsURLConnection.this.socketOut.write(output.getBytes("ISO8859_1"));
        }

        private void sendCache(boolean close) throws IOException {
            int size = this.cache.size();
            if (size > 0 || close) {
                if (this.limit < 0) {
                    if (size > 0) {
                        this.output(String.valueOf(Integer.toHexString(size)) + "\r\n");
                        this.cache.write(13);
                        this.cache.write(10);
                    }
                    if (close) {
                        this.cache.write(48);
                        this.cache.write(13);
                        this.cache.write(10);
                        this.cache.write(13);
                        this.cache.write(10);
                    }
                }
                HttpsURLConnection.this.socketOut.write(this.cache.toByteArray());
                this.cache.reset();
            }
        }

        public synchronized void flush() throws IOException {
            if (this.closed) {
                throw new IOException(Msg.getString("K0059"));
            }
            if (this.writeToSocket) {
                this.sendCache(false);
                HttpsURLConnection.this.socketOut.flush();
            }
        }

        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.writeToSocket) {
                if (this.limit > 0) {
                    throw new IOException(Msg.getString("K00a4"));
                }
                this.sendCache(this.closed);
            }
        }

        public synchronized void write(int data) throws IOException {
            if (this.closed) {
                throw new IOException(Msg.getString("K0059"));
            }
            if (this.limit >= 0) {
                if (this.limit == 0) {
                    throw new IOException(Msg.getString("K00b2"));
                }
                --this.limit;
            }
            this.cache.write(data);
            if (this.writeToSocket && this.cache.size() >= 1024) {
                this.sendCache(false);
            }
        }

        public synchronized void write(byte[] buffer, int offset, int count) throws IOException {
            if (this.closed) {
                throw new IOException(Msg.getString("K0059"));
            }
            if (buffer == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || count < 0 || offset > buffer.length || buffer.length - offset < count) {
                throw new ArrayIndexOutOfBoundsException(Msg.getString("K002f"));
            }
            if (this.limit >= 0) {
                if (count > this.limit) {
                    throw new IOException(Msg.getString("K00b2"));
                }
                this.limit -= count;
            }
            if (!this.writeToSocket || this.cache.size() + count < 1024) {
                this.cache.write(buffer, offset, count);
            } else {
                if (this.limit < 0) {
                    this.output(String.valueOf(Integer.toHexString(count + this.cache.size())) + "\r\n");
                }
                HttpsURLConnection.this.socketOut.write(this.cache.toByteArray());
                this.cache.reset();
                HttpsURLConnection.this.socketOut.write(buffer, offset, count);
                if (this.limit < 0) {
                    this.output("\r\n");
                }
            }
        }

        synchronized int size() {
            return this.cache.size();
        }

        synchronized byte[] toByteArray() {
            return this.cache.toByteArray();
        }

        boolean isCached() {
            return !this.writeToSocket;
        }

        boolean isChunked() {
            return this.writeToSocket && this.limit == -1;
        }
    }
}

