/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.ibm.j9.jsse.support.Msg;
import java.security.InvalidParameterException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLContext {
    private final SSLContextSpi implementation;
    private final Provider provider;
    private final String protocol;
    private static final String SSLCONTEXT_PREFIX = "SSLContext.";

    protected SSLContext(SSLContextSpi implementation, Provider provider, String protocol) {
        this.implementation = implementation;
        this.provider = provider;
        this.protocol = protocol;
    }

    public static SSLContext getInstance(String protocol) throws NoSuchAlgorithmException {
        Provider[] providers;
        try {
            providers = Security.getProviders(SSLCONTEXT_PREFIX + protocol);
        }
        catch (InvalidParameterException invalidParameterException) {
            throw new NoSuchAlgorithmException(Msg.getString("K00b3", protocol));
        }
        if (providers == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K00b3", protocol));
        }
        return SSLContext.getInstance(protocol, providers[0]);
    }

    public static SSLContext getInstance(String protocol, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (protocol == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03c3"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(Msg.getString("K03b6"));
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(Msg.getString("K03b7", provider));
        }
        return SSLContext.getInstance(protocol, p);
    }

    public static SSLContext getInstance(String protocol, Provider provider) throws NoSuchAlgorithmException {
        if (protocol == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03c3"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(Msg.getString("K03b6"));
        }
        String className = provider.getProperty(SSLCONTEXT_PREFIX + protocol);
        if (className == null) {
            throw new NoSuchAlgorithmException(Msg.getString("K03c2", protocol, provider.getName()));
        }
        Class<?> generatorClass = null;
        try {
            generatorClass = Class.forName(className, true, provider.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        SSLContextSpi implementationClass = null;
        try {
            implementationClass = (SSLContextSpi)generatorClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new NoSuchAlgorithmException(e.getMessage());
        }
        return new SSLContext(implementationClass, provider, protocol);
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
        this.implementation.engineInit(keyManagers, trustManagers, secureRandom);
    }

    public final SSLSocketFactory getSocketFactory() {
        return this.implementation.engineGetSocketFactory();
    }

    public final SSLServerSocketFactory getServerSocketFactory() {
        return this.implementation.engineGetServerSocketFactory();
    }

    public final SSLSessionContext getServerSessionContext() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.implementation.engineGetServerSessionContext();
    }

    public final SSLSessionContext getClientSessionContext() {
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            manager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.implementation.engineGetClientSessionContext();
    }
}

