/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.ibm.oti.util.PriviAction;
import java.security.AccessController;
import javax.net.ServerSocketFactory;

public abstract class SSLServerSocketFactory
extends ServerSocketFactory {
    protected SSLServerSocketFactory() {
    }

    private static final String getDefaultAlgorithm() {
        String result = (String)AccessController.doPrivileged(PriviAction.getSecurityProperty((String)"ssl.ServerSocketFactory.provider"));
        return result;
    }

    public static ServerSocketFactory getDefault() {
        String factoryName = SSLServerSocketFactory.getDefaultAlgorithm();
        if (factoryName == null) {
            return new com.ibm.j9.jsse.SSLServerSocketFactory();
        }
        try {
            Class<?> factoryClass = Class.forName(factoryName, true, ClassLoader.getSystemClassLoader());
            return (ServerSocketFactory)factoryClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();
}

