/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import com.ibm.j9.jsse.X509CertificateJSSE;
import com.ibm.oti.security.provider.X509CertImpl;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.util.Date;
import javax.security.cert.Certificate;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;

public abstract class X509Certificate
extends Certificate {
    public static final X509Certificate getInstance(InputStream inputStream) throws CertificateException {
        X509CertImpl certImpl;
        try {
            certImpl = X509CertImpl.certificateFromASN1Object((InputStream)inputStream);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
        return new X509CertificateJSSE(certImpl);
    }

    public static final X509Certificate getInstance(byte[] encodedCertificate) throws CertificateException {
        X509CertImpl certImpl;
        try {
            certImpl = X509CertImpl.certificateFromASN1Object((byte[])encodedCertificate);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
        return new X509CertificateJSSE(certImpl);
    }

    public abstract void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract void checkValidity(Date var1) throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract int getVersion();

    public abstract BigInteger getSerialNumber();

    public abstract Principal getIssuerDN();

    public abstract Principal getSubjectDN();

    public abstract Date getNotBefore();

    public abstract Date getNotAfter();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();
}

