/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.util.ArrayList;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public final class CryptoUpcalls {
    static /* synthetic */ Class class$0;

    private CryptoUpcalls() {
    }

    private static boolean isOurProvider(Provider p) {
        Package package_ = p.getClass().getPackage();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.conscrypt.CryptoUpcalls");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return package_.equals(clazz.getPackage());
    }

    private static ArrayList getExternalProviders(String algorithm) {
        ArrayList<Provider> providers = new ArrayList<Provider>(1);
        Provider[] prov = Security.getProviders(algorithm);
        int i = 0;
        while (i < prov.length) {
            Provider p = prov[i];
            if (!CryptoUpcalls.isOurProvider(p)) {
                providers.add(p);
            }
            ++i;
        }
        if (providers.isEmpty()) {
            System.err.println("Could not find external provider for algorithm: " + algorithm);
        }
        return providers;
    }

    public static byte[] rawSignDigestWithPrivateKey(PrivateKey javaKey, byte[] message) {
        Signature signature;
        String algorithm;
        String keyAlgorithm = javaKey.getAlgorithm();
        if ("RSA".equals(keyAlgorithm)) {
            algorithm = "NONEwithRSA";
        } else if ("EC".equals(keyAlgorithm)) {
            algorithm = "NONEwithECDSA";
        } else {
            throw new RuntimeException("Unexpected key type: " + javaKey.toString());
        }
        try {
            signature = Signature.getInstance(algorithm);
            signature.initSign(javaKey);
            if (CryptoUpcalls.isOurProvider(signature.getProvider())) {
                signature = null;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Unsupported signature algorithm: " + algorithm);
            return null;
        }
        catch (InvalidKeyException e) {
            System.err.println("Preferred provider doesn't support key:");
            e.printStackTrace();
            signature = null;
        }
        if (signature == null) {
            ArrayList providers = CryptoUpcalls.getExternalProviders("Signature." + algorithm);
            Iterator iter = providers.iterator();
            while (iter.hasNext()) {
                Provider p = (Provider)iter.next();
                try {
                    signature = Signature.getInstance(algorithm, p);
                    signature.initSign(javaKey);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    signature = null;
                }
                catch (InvalidKeyException e) {
                    signature = null;
                }
            }
            if (signature == null) {
                System.err.println("Could not find provider for algorithm: " + algorithm);
                return null;
            }
        }
        try {
            signature.update(message);
            return signature.sign();
        }
        catch (Exception e) {
            System.err.println("Exception while signing message with " + javaKey.getAlgorithm() + " private key:");
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] rsaDecryptWithPrivateKey(PrivateKey javaKey, int openSSLPadding, byte[] input) {
        String jcaPadding;
        String keyAlgorithm = javaKey.getAlgorithm();
        if (!"RSA".equals(keyAlgorithm)) {
            System.err.println("Unexpected key type: " + keyAlgorithm);
            return null;
        }
        switch (openSSLPadding) {
            case 1: {
                jcaPadding = "PKCS1Padding";
                break;
            }
            case 3: {
                jcaPadding = "NoPadding";
                break;
            }
            case 4: {
                jcaPadding = "OAEPPadding";
                break;
            }
            default: {
                System.err.println("Unsupported OpenSSL/BoringSSL padding: " + openSSLPadding);
                return null;
            }
        }
        String transformation = "RSA/ECB/" + jcaPadding;
        Cipher c = null;
        try {
            c = Cipher.getInstance(transformation);
            c.init(2, javaKey);
            if (CryptoUpcalls.isOurProvider(c.getProvider())) {
                c = null;
            }
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Unsupported cipher algorithm: " + transformation);
            return null;
        }
        catch (NoSuchPaddingException e) {
            System.err.println("Unsupported cipher algorithm: " + transformation);
            return null;
        }
        catch (InvalidKeyException e) {
            System.err.println("Preferred provider doesn't support key:");
            e.printStackTrace();
            c = null;
        }
        if (c == null) {
            ArrayList providers = CryptoUpcalls.getExternalProviders("Cipher." + transformation);
            Iterator pIterator = providers.iterator();
            while (pIterator.hasNext()) {
                Provider p = (Provider)pIterator.next();
                try {
                    c = Cipher.getInstance(transformation, p);
                    c.init(2, javaKey);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    c = null;
                }
                catch (InvalidKeyException e) {
                    c = null;
                }
                catch (NoSuchPaddingException e) {
                    c = null;
                }
            }
            if (c == null) {
                System.err.println("Could not find provider for algorithm: " + transformation);
                return null;
            }
        }
        try {
            return c.doFinal(input);
        }
        catch (Exception e) {
            System.err.println("Exception while decrypting message with " + javaKey.getAlgorithm() + " private key using " + transformation + ":");
            e.printStackTrace();
            return null;
        }
    }
}

