/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.net.ssl.SSLSession;
import org.conscrypt.Platform;
import org.conscrypt.SSLClientSessionCache;

public class FileClientSessionCache {
    public static final int MAX_SIZE = 12;
    static final Map caches = new HashMap();

    private FileClientSessionCache() {
    }

    public static synchronized SSLClientSessionCache usingDirectory(File directory) throws IOException {
        Impl cache = (Impl)caches.get(directory);
        if (cache == null) {
            cache = new Impl(directory);
            caches.put(directory, cache);
        }
        return cache;
    }

    static synchronized void reset() {
        caches.clear();
    }

    static class CacheFile
    extends File {
        private static final long serialVersionUID = 1L;
        final String name;
        long lastModified = -1L;

        CacheFile(File dir, String name) {
            super(dir, name);
            this.name = name;
        }

        public long lastModified() {
            long lastModified = this.lastModified;
            if (lastModified == -1L) {
                lastModified = this.lastModified = super.lastModified();
            }
            return lastModified;
        }

        public int compareTo(File another) {
            long result = this.lastModified() - another.lastModified();
            if (result == 0L) {
                return super.compareTo(another);
            }
            return result < 0L ? -1 : 1;
        }
    }

    static class Impl
    implements SSLClientSessionCache {
        final File directory;
        Map accessOrder = Impl.newAccessOrder();
        int size;
        String[] initialFiles;

        Impl(File directory) throws IOException {
            boolean exists = directory.exists();
            if (exists && !directory.isDirectory()) {
                throw new IOException(directory + " exists but is not a directory.");
            }
            if (exists) {
                this.initialFiles = directory.list();
                if (this.initialFiles == null) {
                    throw new IOException(directory + " exists but cannot list contents.");
                }
                Arrays.sort(this.initialFiles);
                this.size = this.initialFiles.length;
            } else {
                if (!directory.mkdirs()) {
                    throw new IOException("Creation of " + directory + " directory failed.");
                }
                this.size = 0;
            }
            this.directory = directory;
        }

        private static Map newAccessOrder() {
            return new LinkedHashMap(12, 0.75f, true);
        }

        private static String fileName(String host, int port) {
            if (host == null) {
                throw new NullPointerException("host == null");
            }
            return String.valueOf(host) + "." + port;
        }

        /*
         * Loose catch block
         */
        public synchronized byte[] getSessionData(String host, int port) {
            byte[] byArray;
            FileInputStream in;
            File file;
            block17: {
                String name = Impl.fileName(host, port);
                file = (File)this.accessOrder.get(name);
                if (file == null) {
                    if (this.initialFiles == null) {
                        return null;
                    }
                    if (Arrays.binarySearch(this.initialFiles, name) < 0) {
                        return null;
                    }
                    file = new File(this.directory, name);
                    this.accessOrder.put(name, file);
                }
                try {
                    in = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    Impl.logReadError(host, file, e);
                    return null;
                }
                int size = (int)file.length();
                byte[] data = new byte[size];
                new DataInputStream(in).readFully(data);
                byArray = data;
                Object var8_11 = null;
                if (in == null) break block17;
                try {
                    in.close();
                }
                catch (RuntimeException rethrown) {
                    throw rethrown;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return byArray;
            catch (IOException e) {
                block18: {
                    try {
                        Impl.logReadError(host, file, e);
                        Object var8_12 = null;
                        if (in == null) break block18;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (RuntimeException rethrown) {
                                throw rethrown;
                            }
                            catch (Exception exception) {}
                            {
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (RuntimeException rethrown) {
                        throw rethrown;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }

        static void logReadError(String host, File file, Throwable t) {
            System.err.println("FileClientSessionCache: Error reading session data for " + host + " from " + file + ".");
            t.printStackTrace();
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized void putSessionData(SSLSession session, byte[] sessionData) {
            host = session.getPeerHost();
            if (sessionData == null) {
                throw new NullPointerException("sessionData == null");
            }
            name = Impl.fileName(host, Platform.SSLSession_getPeerPort(session));
            file = new File(this.directory, name);
            existedBefore = file.exists();
            try {
                out = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                Impl.logWriteError(host, file, e);
                return;
            }
            if (!existedBefore) {
                ++this.size;
                this.makeRoom();
            }
            writeSuccessful = false;
            try {
                try {
                    out.write(sessionData);
                    writeSuccessful = true;
                }
                catch (IOException e) {
                    Impl.logWriteError(host, file, e);
                }
                var10_13 = null;
                closeSuccessful = false;
            }
            catch (Throwable var11_11) {
                var10_12 = null;
                closeSuccessful = false;
                try {
                    try {
                        out.close();
                        closeSuccessful = true;
                    }
                    catch (IOException e) {
                        Impl.logWriteError(host, file, e);
                    }
                    v0 = null;
                }
                catch (Throwable var15_18) {
                    v0 = var14_20 = null;
                }
                if (writeSuccessful && closeSuccessful) {
                    this.accessOrder.put(name, file);
                    throw var11_11;
                }
                this.delete(file);
                throw var11_11;
            }
            try {}
            catch (Throwable var15_19) {
                v1 = var14_21 = null;
lbl53:
                // 2 sources

                if (writeSuccessful && closeSuccessful) {
                    this.accessOrder.put(name, file);
                    return;
                }
                this.delete(file);
                return;
            }
            ** try [egrp 4[TRYBLOCK] [4 : 138->149)] { 
lbl60:
            // 1 sources

            out.close();
            closeSuccessful = true;
lbl63:
            // 1 sources

            catch (IOException e) {
                Impl.logWriteError(host, file, e);
            }
            v1 = null;
            ** GOTO lbl53
        }

        private void makeRoom() {
            if (this.size <= 12) {
                return;
            }
            this.indexFiles();
            int removals = this.size - 12;
            Iterator i = this.accessOrder.values().iterator();
            do {
                this.delete((File)i.next());
                i.remove();
            } while (--removals > 0);
        }

        private void indexFiles() {
            String[] initialFiles = this.initialFiles;
            if (initialFiles != null) {
                this.initialFiles = null;
                TreeSet<CacheFile> diskOnly = new TreeSet<CacheFile>();
                int i = 0;
                while (i < initialFiles.length) {
                    String name = initialFiles[i];
                    if (!this.accessOrder.containsKey(name)) {
                        diskOnly.add(new CacheFile(this.directory, name));
                    }
                    ++i;
                }
                if (!diskOnly.isEmpty()) {
                    Map newOrder = Impl.newAccessOrder();
                    Iterator iter = diskOnly.iterator();
                    while (iter.hasNext()) {
                        CacheFile cacheFile = (CacheFile)iter.next();
                        newOrder.put(cacheFile.name, cacheFile);
                    }
                    newOrder.putAll(this.accessOrder);
                    this.accessOrder = newOrder;
                }
            }
        }

        private void delete(File file) {
            if (!file.delete()) {
                new IOException("FileClientSessionCache: Failed to delete " + file + ".").printStackTrace();
            }
            --this.size;
        }

        static void logWriteError(String host, File file, Throwable t) {
            System.err.println("FileClientSessionCache: Error writing session data for " + host + " to " + file + ".");
            t.printStackTrace();
        }
    }
}

