/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayOutputStream;
import org.conscrypt.NativeCrypto;

public final class OpenSSLBIOSink {
    private final long ctx;
    private final ByteArrayOutputStream buffer;
    private int position;

    public static OpenSSLBIOSink create() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        return new OpenSSLBIOSink(buffer);
    }

    private OpenSSLBIOSink(ByteArrayOutputStream buffer) {
        this.ctx = NativeCrypto.create_BIO_OutputStream(buffer);
        this.buffer = buffer;
    }

    public int available() {
        return this.buffer.size() - this.position;
    }

    public void reset() {
        this.buffer.reset();
        this.position = 0;
    }

    public long skip(long byteCount) {
        int maxLength = Math.min(this.available(), (int)byteCount);
        this.position += maxLength;
        if (this.position == this.buffer.size()) {
            this.reset();
        }
        return maxLength;
    }

    public long getContext() {
        return this.ctx;
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public int position() {
        return this.position;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            NativeCrypto.BIO_free_all(this.ctx);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }
}

