/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.conscrypt.ArrayUtils;
import org.conscrypt.EmptyArray;
import org.conscrypt.GCMParameters;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeRef;
import org.conscrypt.Platform;

public abstract class OpenSSLCipher
extends CipherSpi {
    protected static final int CBC = 0;
    protected static final int CTR = 1;
    protected static final int ECB = 2;
    protected static final int GCM = 3;
    protected static String[] sModes = new String[]{"CBC", "CTR", "ECB", "GCM"};
    protected static final int NOPADDING = 0;
    protected static final int PKCS5PADDING = 1;
    protected static final int ISO10126PADDING = 2;
    protected static String[] sPaddings = new String[]{"NOPADDING", "PKCS5PADDING", "ISO10126PADDING"};
    protected int mode = 2;
    private int padding = 1;
    protected byte[] encodedKey;
    protected byte[] iv;
    private boolean encrypting;
    private int blockSize;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private static int modeFromString(String string) {
        int i = 0;
        while (i < sModes.length) {
            if (sModes[i].equals(string)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Mode " + string);
    }

    private static String modeToString(int mode) {
        return mode >= 0 && mode < sModes.length ? sModes[mode] : "";
    }

    private static int paddingFromString(String string) {
        int i = 0;
        while (i < sPaddings.length) {
            if (sPaddings[i].equals(string)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Padding " + string);
    }

    private static String paddingToString(int padding) {
        return padding >= 0 && padding < sPaddings.length ? sPaddings[padding] : "";
    }

    protected OpenSSLCipher() {
    }

    protected OpenSSLCipher(int mode, int padding) {
        this.mode = mode;
        this.padding = padding;
        this.blockSize = this.getCipherBlockSize();
    }

    protected abstract void engineInitInternal(byte[] var1, AlgorithmParameterSpec var2, SecureRandom var3) throws InvalidKeyException, InvalidAlgorithmParameterException;

    protected abstract int updateInternal(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws ShortBufferException;

    protected abstract int doFinalInternal(byte[] var1, int var2, int var3) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException;

    protected abstract String getBaseCipherName();

    protected abstract void checkSupportedKeySize(int var1) throws InvalidKeyException;

    protected abstract void checkSupportedMode(int var1) throws NoSuchAlgorithmException;

    protected abstract void checkSupportedPadding(int var1) throws NoSuchPaddingException;

    protected abstract int getCipherBlockSize();

    protected boolean supportsVariableSizeKey() {
        return false;
    }

    protected boolean supportsVariableSizeIv() {
        return false;
    }

    protected void engineSetMode(String modeStr) throws NoSuchAlgorithmException {
        int mode;
        try {
            mode = OpenSSLCipher.modeFromString(modeStr.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            NoSuchAlgorithmException newE = new NoSuchAlgorithmException("No such mode: " + modeStr);
            newE.initCause(e);
            throw newE;
        }
        this.checkSupportedMode(mode);
        this.mode = mode;
    }

    protected void engineSetPadding(String paddingStr) throws NoSuchPaddingException {
        int padding;
        String paddingStrUpper = paddingStr.toUpperCase(Locale.US);
        try {
            padding = OpenSSLCipher.paddingFromString(paddingStrUpper);
        }
        catch (IllegalArgumentException e) {
            NoSuchPaddingException newE = new NoSuchPaddingException("No such padding: " + paddingStr);
            newE.initCause(e);
            throw newE;
        }
        this.checkSupportedPadding(padding);
        this.padding = padding;
    }

    protected int getPadding() {
        return this.padding;
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected abstract int getOutputSizeForFinal(int var1);

    protected abstract int getOutputSizeForUpdate(int var1);

    protected int engineGetOutputSize(int inputLen) {
        return this.getOutputSizeForFinal(inputLen);
    }

    protected byte[] engineGetIV() {
        return this.iv;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.iv != null && this.iv.length > 0) {
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance(this.getBaseCipherName());
                params.init(this.iv);
                return params;
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.checkAndSetEncodedKey(opmode, key);
        try {
            this.engineInitInternal(this.encodedKey, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.checkAndSetEncodedKey(opmode, key);
        this.engineInitInternal(this.encodedKey, params, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec spec;
        if (params != null) {
            try {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("javax.crypto.spec.IvParameterSpec");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                spec = (AlgorithmParameterSpec)params.getParameterSpec(clazz);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException("Params must be convertible to IvParameterSpec " + e.getMessage());
            }
        }
        spec = null;
        this.engineInit(opmode, key, spec, random);
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        int bytesWritten;
        int maximumLen = this.getOutputSizeForUpdate(inputLen);
        byte[] output = maximumLen > 0 ? new byte[maximumLen] : EmptyArray.BYTE;
        try {
            bytesWritten = this.updateInternal(input, inputOffset, inputLen, output, 0, maximumLen);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException("calculated buffer size was wrong: " + maximumLen);
        }
        if (output.length == bytesWritten) {
            return output;
        }
        if (bytesWritten == 0) {
            return EmptyArray.BYTE;
        }
        return Platform.Arrays_copyOfRange(output, 0, bytesWritten);
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int maximumLen = this.getOutputSizeForUpdate(inputLen);
        return this.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int bytesWritten;
        int maximumLen = this.getOutputSizeForFinal(inputLen);
        byte[] output = new byte[maximumLen];
        if (inputLen > 0) {
            try {
                bytesWritten = this.updateInternal(input, inputOffset, inputLen, output, 0, maximumLen);
            }
            catch (ShortBufferException e) {
                throw new RuntimeException("our calculated buffer was too small", e);
            }
        } else {
            bytesWritten = 0;
        }
        try {
            bytesWritten += this.doFinalInternal(output, bytesWritten, maximumLen - bytesWritten);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException("our calculated buffer was too small", e);
        }
        if (bytesWritten == output.length) {
            return output;
        }
        if (bytesWritten == 0) {
            return EmptyArray.BYTE;
        }
        return Platform.Arrays_copyOfRange(output, 0, bytesWritten);
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int bytesWritten;
        if (output == null) {
            throw new NullPointerException("output == null");
        }
        int maximumLen = this.getOutputSizeForFinal(inputLen);
        if (inputLen > 0) {
            bytesWritten = this.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
            outputOffset += bytesWritten;
            maximumLen -= bytesWritten;
        } else {
            bytesWritten = 0;
        }
        return bytesWritten + this.doFinalInternal(output, outputOffset, maximumLen);
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            byte[] encoded = key.getEncoded();
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            IllegalBlockSizeException newE = new IllegalBlockSizeException();
            newE.initCause(e);
            throw newE;
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            if (wrappedKeyType == 1) {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                return keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 2) {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 3) {
                return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
            }
            throw new UnsupportedOperationException("wrappedKeyType == " + wrappedKeyType);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException(e.getMessage());
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    private byte[] checkAndSetEncodedKey(int opmode, Key key) throws InvalidKeyException {
        if (opmode == 1 || opmode == 3) {
            this.encrypting = true;
        } else if (opmode == 2 || opmode == 4) {
            this.encrypting = false;
        } else {
            throw new InvalidParameterException("Unsupported opmode " + opmode);
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey is supported");
        }
        byte[] encodedKey = key.getEncoded();
        if (encodedKey == null) {
            throw new InvalidKeyException("key.getEncoded() == null");
        }
        this.checkSupportedKeySize(encodedKey.length);
        this.encodedKey = encodedKey;
        return encodedKey;
    }

    protected boolean isEncrypting() {
        return this.encrypting;
    }

    public static abstract class EVP_AEAD
    extends OpenSSLCipher {
        private static final int DEFAULT_TAG_SIZE_BITS = 128;
        private static int lastGlobalMessageSize = 32;
        protected byte[] buf;
        protected int bufCount;
        protected long evpAead;
        private byte[] aad;
        private int tagLengthInBytes;

        public EVP_AEAD(int mode) {
            super(mode, 0);
        }

        private void expand(int i) {
            if (this.bufCount + i <= this.buf.length) {
                return;
            }
            byte[] newbuf = new byte[(this.bufCount + i) * 2];
            System.arraycopy(this.buf, 0, newbuf, 0, this.bufCount);
            this.buf = newbuf;
        }

        private void reset() {
            this.aad = null;
            int lastBufSize = lastGlobalMessageSize;
            if (this.buf == null) {
                this.buf = new byte[lastBufSize];
            } else if (this.bufCount > 0 && this.bufCount != lastBufSize) {
                lastGlobalMessageSize = this.bufCount;
                if (this.buf.length != this.bufCount) {
                    this.buf = new byte[this.bufCount];
                }
            }
            this.bufCount = 0;
        }

        protected void engineInitInternal(byte[] encodedKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            int tagLenBits;
            byte[] iv;
            if (params == null) {
                iv = null;
                tagLenBits = 128;
            } else {
                GCMParameters gcmParams = Platform.fromGCMParameterSpec(params);
                if (gcmParams != null) {
                    iv = gcmParams.getIV();
                    tagLenBits = gcmParams.getTLen();
                } else if (params instanceof IvParameterSpec) {
                    IvParameterSpec ivParams = (IvParameterSpec)params;
                    iv = ivParams.getIV();
                    tagLenBits = 128;
                } else {
                    iv = null;
                    tagLenBits = 128;
                }
            }
            if (tagLenBits % 8 != 0) {
                throw new InvalidAlgorithmParameterException("Tag length must be a multiple of 8; was " + this.tagLengthInBytes);
            }
            this.tagLengthInBytes = tagLenBits / 8;
            boolean encrypting = this.isEncrypting();
            this.evpAead = this.getEVP_AEAD(encodedKey.length);
            int expectedIvLength = NativeCrypto.EVP_AEAD_nonce_length(this.evpAead);
            if (iv == null && expectedIvLength != 0) {
                if (!encrypting) {
                    throw new InvalidAlgorithmParameterException("IV must be specified in " + this.mode + " mode");
                }
                iv = new byte[expectedIvLength];
                if (random != null) {
                    random.nextBytes(iv);
                } else {
                    NativeCrypto.RAND_bytes(iv);
                }
            } else {
                if (expectedIvLength == 0 && iv != null) {
                    throw new InvalidAlgorithmParameterException("IV not used in " + this.mode + " mode");
                }
                if (iv != null && iv.length != expectedIvLength) {
                    throw new InvalidAlgorithmParameterException("Expected IV length of " + expectedIvLength + " but was " + iv.length);
                }
            }
            this.iv = iv;
            this.reset();
        }

        protected int updateInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws ShortBufferException {
            if (this.buf == null) {
                throw new IllegalStateException("Cipher not initialized");
            }
            ArrayUtils.checkOffsetAndCount(input.length, inputOffset, inputLen);
            if (inputLen > 0) {
                this.expand(inputLen);
                System.arraycopy(input, inputOffset, this.buf, this.bufCount, inputLen);
                this.bufCount += inputLen;
            }
            return 0;
        }

        protected int doFinalInternal(byte[] output, int outputOffset, int maximumLen) throws IllegalBlockSizeException, BadPaddingException {
            int bytesWritten;
            try {
                bytesWritten = this.isEncrypting() ? NativeCrypto.EVP_AEAD_CTX_seal(this.evpAead, this.encodedKey, this.tagLengthInBytes, output, outputOffset, this.iv, this.buf, 0, this.bufCount, this.aad) : NativeCrypto.EVP_AEAD_CTX_open(this.evpAead, this.encodedKey, this.tagLengthInBytes, output, outputOffset, this.iv, this.buf, 0, this.bufCount, this.aad);
            }
            catch (BadPaddingException e) {
                Constructor<?> aeadBadTagConstructor = null;
                try {
                    Class<?> clazz = Class.forName("javax.crypto.AEADBadTagException");
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    aeadBadTagConstructor = clazz.getConstructor(classArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (aeadBadTagConstructor != null) {
                    BadPaddingException badTagException = null;
                    try {
                        badTagException = (BadPaddingException)aeadBadTagConstructor.newInstance(e.getMessage());
                        badTagException.initCause(e.getCause());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (InvocationTargetException e2) {
                        throw (BadPaddingException)new BadPaddingException().initCause(e2.getTargetException());
                    }
                    if (badTagException != null) {
                        throw badTagException;
                    }
                }
                throw e;
            }
            this.reset();
            return bytesWritten;
        }

        protected void checkSupportedPadding(int padding) throws NoSuchPaddingException {
            if (padding != 0) {
                throw new NoSuchPaddingException("Must be NoPadding for AEAD ciphers");
            }
        }

        protected int getOutputSizeForFinal(int inputLen) {
            return this.bufCount + inputLen + (this.isEncrypting() ? NativeCrypto.EVP_AEAD_max_overhead(this.evpAead) : 0);
        }

        protected void engineUpdateAAD(byte[] input, int inputOffset, int inputLen) {
            if (this.aad == null) {
                Platform.Arrays_copyOfRange(input, inputOffset, inputOffset + inputLen);
            } else {
                int newSize = this.aad.length + inputLen;
                byte[] newaad = new byte[newSize];
                System.arraycopy(this.aad, 0, newaad, 0, this.aad.length);
                System.arraycopy(input, inputOffset, newaad, this.aad.length, inputLen);
                this.aad = newaad;
            }
        }

        protected AlgorithmParameters engineGetParameters() {
            if (this.iv == null) {
                return null;
            }
            AlgorithmParameterSpec spec = Platform.toGCMParameterSpec(this.tagLengthInBytes * 8, this.iv);
            if (spec == null) {
                return super.engineGetParameters();
            }
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance("GCM");
                params.init(spec);
                return params;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                // empty catch block
            }
            return null;
        }

        protected abstract long getEVP_AEAD(int var1) throws InvalidKeyException;

        public static abstract class AES
        extends EVP_AEAD {
            private static final int AES_BLOCK_SIZE = 16;

            protected AES(int mode) {
                super(mode);
            }

            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                switch (keyLength) {
                    case 16: 
                    case 32: {
                        return;
                    }
                }
                throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes (must be 16 or 32)");
            }

            protected String getBaseCipherName() {
                return "AES";
            }

            protected int getCipherBlockSize() {
                return 16;
            }

            protected int getOutputSizeForUpdate(int inputLen) {
                return 0;
            }

            public static class GCM
            extends AES {
                private byte[] previousKey;
                private byte[] previousIv;
                private boolean mustInitialize;

                public GCM() {
                    super(3);
                }

                private void checkInitialization() {
                    if (this.mustInitialize) {
                        throw new IllegalStateException("Cannot re-use same key and IV for multiple encryptions");
                    }
                }

                private boolean arraysAreEqual(byte[] a, byte[] b) {
                    if (a.length != b.length) {
                        return false;
                    }
                    int diff = 0;
                    int i = 0;
                    while (i < a.length) {
                        diff |= a[i] ^ b[i];
                        ++i;
                    }
                    return diff == 0;
                }

                protected void engineInitInternal(byte[] encodedKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
                    super.engineInitInternal(encodedKey, params, random);
                    if (this.isEncrypting() && this.iv != null) {
                        if (this.previousKey != null && this.previousIv != null && this.arraysAreEqual(this.previousKey, encodedKey) && this.arraysAreEqual(this.previousIv, this.iv)) {
                            this.mustInitialize = true;
                            throw new InvalidAlgorithmParameterException("In GCM mode key and IV must not be re-used");
                        }
                        this.previousKey = encodedKey;
                        this.previousIv = this.iv;
                    }
                    this.mustInitialize = false;
                }

                protected int updateInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws ShortBufferException {
                    this.checkInitialization();
                    return super.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
                }

                protected int doFinalInternal(byte[] output, int outputOffset, int maximumLen) throws IllegalBlockSizeException, BadPaddingException {
                    this.checkInitialization();
                    int retVal = super.doFinalInternal(output, outputOffset, maximumLen);
                    if (this.isEncrypting()) {
                        this.mustInitialize = true;
                    }
                    return retVal;
                }

                protected void engineUpdateAAD(byte[] input, int inputOffset, int inputLen) {
                    this.checkInitialization();
                    super.engineUpdateAAD(input, inputOffset, inputLen);
                }

                protected void checkSupportedMode(int mode) throws NoSuchAlgorithmException {
                    if (mode != 3) {
                        throw new NoSuchAlgorithmException("Mode must be GCM");
                    }
                }

                protected long getEVP_AEAD(int keyLength) throws InvalidKeyException {
                    if (keyLength == 16) {
                        return NativeCrypto.EVP_aead_aes_128_gcm();
                    }
                    if (keyLength == 32) {
                        return NativeCrypto.EVP_aead_aes_256_gcm();
                    }
                    throw new RuntimeException("Unexpected key length: " + keyLength);
                }

                public static class AES_128
                extends GCM {
                    protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                        if (keyLength != 16) {
                            throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes (must be 16)");
                        }
                    }
                }

                public static class AES_256
                extends GCM {
                    protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                        if (keyLength != 32) {
                            throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes (must be 32)");
                        }
                    }
                }
            }
        }
    }

    public static abstract class EVP_CIPHER
    extends OpenSSLCipher {
        private final NativeRef.EVP_CIPHER_CTX cipherCtx = new NativeRef.EVP_CIPHER_CTX(NativeCrypto.EVP_CIPHER_CTX_new());
        protected boolean calledUpdate;
        private int modeBlockSize;

        public EVP_CIPHER(int mode, int padding) {
            super(mode, padding);
        }

        protected void engineInitInternal(byte[] encodedKey, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
            byte[] iv;
            if (params instanceof IvParameterSpec) {
                IvParameterSpec ivParams = (IvParameterSpec)params;
                iv = ivParams.getIV();
            } else {
                iv = null;
            }
            long cipherType = NativeCrypto.EVP_get_cipherbyname(this.getCipherName(encodedKey.length, this.mode));
            if (cipherType == 0L) {
                throw new InvalidAlgorithmParameterException("Cannot find name for key length = " + encodedKey.length * 8 + " and mode = " + this.mode);
            }
            boolean encrypting = this.isEncrypting();
            int expectedIvLength = NativeCrypto.EVP_CIPHER_iv_length(cipherType);
            if (iv == null && expectedIvLength != 0) {
                if (!encrypting) {
                    throw new InvalidAlgorithmParameterException("IV must be specified in " + this.mode + " mode");
                }
                iv = new byte[expectedIvLength];
                if (random != null) {
                    random.nextBytes(iv);
                } else {
                    NativeCrypto.RAND_bytes(iv);
                }
            } else {
                if (expectedIvLength == 0 && iv != null) {
                    throw new InvalidAlgorithmParameterException("IV not used in " + this.mode + " mode");
                }
                if (iv != null && iv.length != expectedIvLength) {
                    throw new InvalidAlgorithmParameterException("expected IV length of " + expectedIvLength + " but was " + iv.length);
                }
            }
            this.iv = iv;
            if (this.supportsVariableSizeKey()) {
                NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, cipherType, null, null, encrypting);
                NativeCrypto.EVP_CIPHER_CTX_set_key_length(this.cipherCtx, encodedKey.length);
                NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, 0L, encodedKey, iv, this.isEncrypting());
            } else {
                NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, cipherType, encodedKey, iv, encrypting);
            }
            NativeCrypto.EVP_CIPHER_CTX_set_padding(this.cipherCtx, this.getPadding() == 1);
            this.modeBlockSize = NativeCrypto.EVP_CIPHER_CTX_block_size(this.cipherCtx);
            this.calledUpdate = false;
        }

        protected int updateInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws ShortBufferException {
            int intialOutputOffset = outputOffset;
            int bytesLeft = output.length - outputOffset;
            if (bytesLeft < maximumLen) {
                throw new ShortBufferException("output buffer too small during update: " + bytesLeft + " < " + maximumLen);
            }
            outputOffset += NativeCrypto.EVP_CipherUpdate(this.cipherCtx, output, outputOffset, input, inputOffset, inputLen);
            this.calledUpdate = true;
            return outputOffset - intialOutputOffset;
        }

        protected int doFinalInternal(byte[] output, int outputOffset, int maximumLen) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
            int writtenBytes;
            int initialOutputOffset = outputOffset;
            if (!this.isEncrypting() && !this.calledUpdate) {
                return 0;
            }
            int bytesLeft = output.length - outputOffset;
            if (bytesLeft >= maximumLen) {
                writtenBytes = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx, output, outputOffset);
            } else {
                byte[] lastBlock = new byte[maximumLen];
                writtenBytes = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx, lastBlock, 0);
                if (writtenBytes > bytesLeft) {
                    throw new ShortBufferException("buffer is too short: " + writtenBytes + " > " + bytesLeft);
                }
                if (writtenBytes > 0) {
                    System.arraycopy(lastBlock, 0, output, outputOffset, writtenBytes);
                }
            }
            this.reset();
            return (outputOffset += writtenBytes) - initialOutputOffset;
        }

        protected int getOutputSizeForFinal(int inputLen) {
            if (this.modeBlockSize == 1) {
                return inputLen;
            }
            int buffered = NativeCrypto.get_EVP_CIPHER_CTX_buf_len(this.cipherCtx);
            if (this.getPadding() == 0) {
                return buffered + inputLen;
            }
            boolean finalUsed = NativeCrypto.get_EVP_CIPHER_CTX_final_used(this.cipherCtx);
            int totalLen = inputLen + buffered + (finalUsed ? this.modeBlockSize : 0);
            return (totalLen += totalLen % this.modeBlockSize != 0 || this.isEncrypting() ? this.modeBlockSize : 0) - totalLen % this.modeBlockSize;
        }

        protected int getOutputSizeForUpdate(int inputLen) {
            return this.getOutputSizeForFinal(inputLen);
        }

        protected abstract String getCipherName(int var1, int var2);

        private void reset() {
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx, 0L, this.encodedKey, this.iv, this.isEncrypting());
            this.calledUpdate = false;
        }

        public static class AES
        extends AES_BASE {
            protected AES(int mode, int padding) {
                super(mode, padding);
            }

            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                switch (keyLength) {
                    case 16: 
                    case 24: 
                    case 32: {
                        return;
                    }
                }
                throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes");
            }

            public static class CBC
            extends AES {
                public CBC(int padding) {
                    super(0, padding);
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(0);
                    }
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(1);
                    }
                }
            }

            public static class CTR
            extends AES {
                public CTR() {
                    super(1, 0);
                }
            }

            public static class ECB
            extends AES {
                public ECB(int padding) {
                    super(2, padding);
                }

                public static class NoPadding
                extends ECB {
                    public NoPadding() {
                        super(0);
                    }
                }

                public static class PKCS5Padding
                extends ECB {
                    public PKCS5Padding() {
                        super(1);
                    }
                }
            }
        }

        public static class AES_128
        extends AES_BASE {
            protected AES_128(int mode, int padding) {
                super(mode, padding);
            }

            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                if (keyLength != 16) {
                    throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes");
                }
            }

            public static class CBC
            extends AES_128 {
                public CBC(int padding) {
                    super(0, padding);
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(0);
                    }
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(1);
                    }
                }
            }

            public static class CTR
            extends AES_128 {
                public CTR() {
                    super(1, 0);
                }
            }

            public static class ECB
            extends AES_128 {
                public ECB(int padding) {
                    super(2, padding);
                }

                public static class NoPadding
                extends ECB {
                    public NoPadding() {
                        super(0);
                    }
                }

                public static class PKCS5Padding
                extends ECB {
                    public PKCS5Padding() {
                        super(1);
                    }
                }
            }
        }

        public static class AES_256
        extends AES_BASE {
            protected AES_256(int mode, int padding) {
                super(mode, padding);
            }

            protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
                if (keyLength != 32) {
                    throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes");
                }
            }

            public static class CBC
            extends AES_256 {
                public CBC(int padding) {
                    super(0, padding);
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(0);
                    }
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(1);
                    }
                }
            }

            public static class CTR
            extends AES_256 {
                public CTR() {
                    super(1, 0);
                }
            }

            public static class ECB
            extends AES_256 {
                public ECB(int padding) {
                    super(2, padding);
                }

                public static class NoPadding
                extends ECB {
                    public NoPadding() {
                        super(0);
                    }
                }

                public static class PKCS5Padding
                extends ECB {
                    public PKCS5Padding() {
                        super(1);
                    }
                }
            }
        }

        protected static abstract class AES_BASE
        extends EVP_CIPHER {
            private static final int AES_BLOCK_SIZE = 16;

            protected AES_BASE(int mode, int padding) {
                super(mode, padding);
            }

            protected void checkSupportedMode(int mode) throws NoSuchAlgorithmException {
                switch (mode) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return;
                    }
                }
                throw new NoSuchAlgorithmException("Unsupported mode " + OpenSSLCipher.modeToString(mode));
            }

            protected void checkSupportedPadding(int padding) throws NoSuchPaddingException {
                switch (padding) {
                    case 0: 
                    case 1: {
                        return;
                    }
                }
                throw new NoSuchPaddingException("Unsupported padding " + OpenSSLCipher.paddingToString(padding));
            }

            protected String getBaseCipherName() {
                return "AES";
            }

            protected String getCipherName(int keyLength, int mode) {
                return "aes-" + keyLength * 8 + "-" + OpenSSLCipher.modeToString(mode).toLowerCase(Locale.US);
            }

            protected int getCipherBlockSize() {
                return 16;
            }
        }

        public static class ARC4
        extends EVP_CIPHER {
            public ARC4() {
                super(2, 0);
            }

            protected String getBaseCipherName() {
                return "ARCFOUR";
            }

            protected String getCipherName(int keySize, int mode) {
                return "rc4";
            }

            protected void checkSupportedKeySize(int keySize) throws InvalidKeyException {
            }

            protected void checkSupportedMode(int mode) throws NoSuchAlgorithmException {
                throw new NoSuchAlgorithmException("ARC4 does not support modes");
            }

            protected void checkSupportedPadding(int padding) throws NoSuchPaddingException {
                throw new NoSuchPaddingException("ARC4 does not support padding");
            }

            protected int getCipherBlockSize() {
                return 0;
            }

            protected boolean supportsVariableSizeKey() {
                return true;
            }
        }

        public static class DESEDE
        extends EVP_CIPHER {
            private static final int DES_BLOCK_SIZE = 8;

            public DESEDE(int mode, int padding) {
                super(mode, padding);
            }

            protected String getBaseCipherName() {
                return "DESede";
            }

            protected String getCipherName(int keySize, int mode) {
                String baseCipherName = keySize == 16 ? "des-ede" : "des-ede3";
                return String.valueOf(baseCipherName) + "-" + OpenSSLCipher.modeToString(mode).toLowerCase(Locale.US);
            }

            protected void checkSupportedKeySize(int keySize) throws InvalidKeyException {
                if (keySize != 16 && keySize != 24) {
                    throw new InvalidKeyException("key size must be 128 or 192 bits");
                }
            }

            protected void checkSupportedMode(int mode) throws NoSuchAlgorithmException {
                if (mode != 0) {
                    throw new NoSuchAlgorithmException("Unsupported mode " + OpenSSLCipher.modeToString(mode));
                }
            }

            protected void checkSupportedPadding(int padding) throws NoSuchPaddingException {
                switch (padding) {
                    case 0: 
                    case 1: {
                        return;
                    }
                }
                throw new NoSuchPaddingException("Unsupported padding " + OpenSSLCipher.paddingToString(padding));
            }

            protected int getCipherBlockSize() {
                return 8;
            }

            public static class CBC
            extends DESEDE {
                public CBC(int padding) {
                    super(0, padding);
                }

                public static class NoPadding
                extends CBC {
                    public NoPadding() {
                        super(0);
                    }
                }

                public static class PKCS5Padding
                extends CBC {
                    public PKCS5Padding() {
                        super(1);
                    }
                }
            }
        }
    }
}

