/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.PublicKey;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLKeyHolder;
import org.conscrypt.Platform;

public final class OpenSSLECPublicKey
implements PublicKey,
OpenSSLKeyHolder {
    private static final long serialVersionUID = 3215842926808298020L;
    private static final String ALGORITHM = "EC";
    protected transient OpenSSLKey key;

    public OpenSSLECPublicKey(OpenSSLKey key) {
        this.key = key;
    }

    public String getAlgorithm() {
        return ALGORITHM;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        return NativeCrypto.i2d_PUBKEY(this.key.getNativeRef());
    }

    public OpenSSLKey getOpenSSLKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        Platform.unsupported("OpenSSLECPublicKey.equals");
        return false;
    }

    public int hashCode() {
        return Platform.Arrays_hashCode(NativeCrypto.i2d_PUBKEY(this.key.getNativeRef()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("OpenSSLECPublicKey{");
        sb.append("params={");
        sb.append(NativeCrypto.EVP_PKEY_print_params(this.key.getNativeRef()));
        sb.append("}}");
        return sb.toString();
    }
}

