/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import org.conscrypt.EvpMdRef;
import org.conscrypt.NativeCrypto;
import org.conscrypt.NativeRef;

public class OpenSSLMessageDigestJDK
extends MessageDigestSpi
implements Cloneable {
    private final NativeRef.EVP_MD_CTX ctx;
    private final long evp_md;
    private final int size;
    private final byte[] singleByte = new byte[1];
    private boolean digestInitializedInContext;

    private OpenSSLMessageDigestJDK(long evp_md, int size) throws NoSuchAlgorithmException {
        NativeRef.EVP_MD_CTX ctxLocal;
        this.evp_md = evp_md;
        this.size = size;
        this.ctx = ctxLocal = new NativeRef.EVP_MD_CTX(NativeCrypto.EVP_MD_CTX_create());
    }

    private OpenSSLMessageDigestJDK(long evp_md, int size, NativeRef.EVP_MD_CTX ctx, boolean digestInitializedInContext) {
        this.evp_md = evp_md;
        this.size = size;
        this.ctx = ctx;
        this.digestInitializedInContext = digestInitializedInContext;
    }

    private void ensureDigestInitializedInContext() {
        if (!this.digestInitializedInContext) {
            NativeRef.EVP_MD_CTX ctxLocal = this.ctx;
            NativeCrypto.EVP_DigestInit_ex(ctxLocal, this.evp_md);
            this.digestInitializedInContext = true;
        }
    }

    protected void engineReset() {
        NativeRef.EVP_MD_CTX ctxLocal = this.ctx;
        NativeCrypto.EVP_MD_CTX_cleanup(ctxLocal);
        this.digestInitializedInContext = false;
    }

    protected int engineGetDigestLength() {
        return this.size;
    }

    protected void engineUpdate(byte input) {
        this.singleByte[0] = input;
        this.engineUpdate(this.singleByte, 0, 1);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.ensureDigestInitializedInContext();
        NativeCrypto.EVP_DigestUpdate(this.ctx, input, offset, len);
    }

    protected void engineUpdate(byte[] input) {
        this.engineUpdate(input, 0, input.length);
    }

    protected byte[] engineDigest() {
        this.ensureDigestInitializedInContext();
        byte[] result = new byte[this.size];
        NativeCrypto.EVP_DigestFinal_ex(this.ctx, result, 0);
        this.digestInitializedInContext = false;
        return result;
    }

    public Object clone() {
        NativeRef.EVP_MD_CTX ctxCopy = new NativeRef.EVP_MD_CTX(NativeCrypto.EVP_MD_CTX_create());
        if (this.digestInitializedInContext) {
            NativeCrypto.EVP_MD_CTX_copy_ex(ctxCopy, this.ctx);
        }
        return new OpenSSLMessageDigestJDK(this.evp_md, this.size, ctxCopy, this.digestInitializedInContext);
    }

    /* synthetic */ OpenSSLMessageDigestJDK(long l, int n, OpenSSLMessageDigestJDK openSSLMessageDigestJDK) throws NoSuchAlgorithmException {
        this(l, n);
    }

    public static class MD5
    extends OpenSSLMessageDigestJDK {
        public MD5() throws NoSuchAlgorithmException {
            super(EvpMdRef.MD5.EVP_MD, EvpMdRef.MD5.SIZE_BYTES, null);
        }
    }

    public static class SHA1
    extends OpenSSLMessageDigestJDK {
        public SHA1() throws NoSuchAlgorithmException {
            super(EvpMdRef.SHA1.EVP_MD, EvpMdRef.SHA1.SIZE_BYTES, null);
        }
    }

    public static class SHA224
    extends OpenSSLMessageDigestJDK {
        public SHA224() throws NoSuchAlgorithmException {
            super(EvpMdRef.SHA224.EVP_MD, EvpMdRef.SHA224.SIZE_BYTES, null);
        }
    }

    public static class SHA256
    extends OpenSSLMessageDigestJDK {
        public SHA256() throws NoSuchAlgorithmException {
            super(EvpMdRef.SHA256.EVP_MD, EvpMdRef.SHA256.SIZE_BYTES, null);
        }
    }

    public static class SHA384
    extends OpenSSLMessageDigestJDK {
        public SHA384() throws NoSuchAlgorithmException {
            super(EvpMdRef.SHA384.EVP_MD, EvpMdRef.SHA384.SIZE_BYTES, null);
        }
    }

    public static class SHA512
    extends OpenSSLMessageDigestJDK {
        public SHA512() throws NoSuchAlgorithmException {
            super(EvpMdRef.SHA512.EVP_MD, EvpMdRef.SHA512.SIZE_BYTES, null);
        }
    }
}

