/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.utils.AlgNameMapper;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLBIOInputStream;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLKeyHolder;
import org.conscrypt.OpenSSLX509CRLEntry;
import org.conscrypt.OpenSSLX509Certificate;
import org.conscrypt.OpenSSLX509CertificateFactory;

public class OpenSSLX509CRL
extends X509CRL {
    private final long mContext;

    private OpenSSLX509CRL(long ctx) {
        this.mContext = ctx;
    }

    public static OpenSSLX509CRL fromX509DerInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        long crlCtx;
        OpenSSLBIOInputStream bis;
        block5: {
            bis = new OpenSSLBIOInputStream(is, true);
            crlCtx = NativeCrypto.d2i_X509_CRL_bio(bis.getBioContext());
            if (crlCtx != 0L) break block5;
            Object var4_4 = null;
            bis.release();
            return null;
        }
        try {
            OpenSSLX509CRL openSSLX509CRL = new OpenSSLX509CRL(crlCtx);
            Object var4_5 = null;
            bis.release();
            return openSSLX509CRL;
        }
        catch (Exception e) {
            try {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                bis.release();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List fromPkcs7DerInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        int i;
        ArrayList<OpenSSLX509CRL> certs;
        long[] certRefs;
        OpenSSLBIOInputStream bis = new OpenSSLBIOInputStream(is, true);
        try {
            try {
                certRefs = NativeCrypto.d2i_PKCS7_bio(bis.getBioContext(), 2);
            }
            catch (Exception e) {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            bis.release();
            throw throwable;
        }
        {
            Object var4_7 = null;
            bis.release();
            certs = new ArrayList<OpenSSLX509CRL>(certRefs.length);
            i = 0;
        }
        while (i < certRefs.length) {
            if (certRefs[i] != 0L) {
                certs.add(new OpenSSLX509CRL(certRefs[i]));
            }
            ++i;
        }
        return certs;
    }

    public static OpenSSLX509CRL fromX509PemInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        long crlCtx;
        OpenSSLBIOInputStream bis;
        block5: {
            bis = new OpenSSLBIOInputStream(is, true);
            crlCtx = NativeCrypto.PEM_read_bio_X509_CRL(bis.getBioContext());
            if (crlCtx != 0L) break block5;
            Object var4_4 = null;
            bis.release();
            return null;
        }
        try {
            OpenSSLX509CRL openSSLX509CRL = new OpenSSLX509CRL(crlCtx);
            Object var4_5 = null;
            bis.release();
            return openSSLX509CRL;
        }
        catch (Exception e) {
            try {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                bis.release();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List fromPkcs7PemInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        int i;
        ArrayList<OpenSSLX509CRL> certs;
        long[] certRefs;
        OpenSSLBIOInputStream bis = new OpenSSLBIOInputStream(is, true);
        try {
            try {
                certRefs = NativeCrypto.PEM_read_bio_PKCS7(bis.getBioContext(), 2);
            }
            catch (Exception e) {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            bis.release();
            throw throwable;
        }
        {
            Object var4_7 = null;
            bis.release();
            certs = new ArrayList<OpenSSLX509CRL>(certRefs.length);
            i = 0;
        }
        while (i < certRefs.length) {
            if (certRefs[i] != 0L) {
                certs.add(new OpenSSLX509CRL(certRefs[i]));
            }
            ++i;
        }
        return certs;
    }

    public Set getCriticalExtensionOIDs() {
        String[] critOids = NativeCrypto.get_X509_CRL_ext_oids(this.mContext, 1);
        if (critOids.length == 0 && NativeCrypto.get_X509_CRL_ext_oids(this.mContext, 0).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(critOids));
    }

    public byte[] getExtensionValue(String oid) {
        return NativeCrypto.X509_CRL_get_ext_oid(this.mContext, oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        String[] nonCritOids = NativeCrypto.get_X509_CRL_ext_oids(this.mContext, 0);
        if (nonCritOids.length == 0 && NativeCrypto.get_X509_CRL_ext_oids(this.mContext, 1).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(nonCritOids));
    }

    public boolean hasUnsupportedCriticalExtension() {
        String[] criticalOids = NativeCrypto.get_X509_CRL_ext_oids(this.mContext, 1);
        int i = 0;
        while (i < criticalOids.length) {
            String oid = criticalOids[i];
            long extensionRef = NativeCrypto.X509_CRL_get_ext(this.mContext, oid);
            if (NativeCrypto.X509_supported_extension(extensionRef) != 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public byte[] getEncoded() throws CRLException {
        return NativeCrypto.i2d_X509_CRL(this.mContext);
    }

    private void verifyOpenSSL(OpenSSLKey pkey) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        NativeCrypto.X509_CRL_verify(this.mContext, pkey.getNativeRef());
    }

    private void verifyInternal(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String sigAlg = this.getSigAlgName();
        if (sigAlg == null) {
            sigAlg = this.getSigAlgOID();
        }
        Signature sig = sigProvider == null ? Signature.getInstance(sigAlg) : Signature.getInstance(sigAlg, sigProvider);
        sig.initVerify(key);
        sig.update(this.getTBSCertList());
        if (!sig.verify(this.getSignature())) {
            throw new SignatureException("signature did not verify");
        }
    }

    public void verify(PublicKey key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (key instanceof OpenSSLKeyHolder) {
            OpenSSLKey pkey = ((OpenSSLKeyHolder)((Object)key)).getOpenSSLKey();
            this.verifyOpenSSL(pkey);
            return;
        }
        this.verifyInternal(key, null);
    }

    public void verify(PublicKey key, String sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verifyInternal(key, sigProvider);
    }

    public int getVersion() {
        return (int)NativeCrypto.X509_CRL_get_version(this.mContext) + 1;
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public X500Principal getIssuerX500Principal() {
        byte[] issuer = NativeCrypto.X509_CRL_get_issuer_name(this.mContext);
        return new X500Principal(issuer);
    }

    public Date getThisUpdate() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(14, 0);
        NativeCrypto.ASN1_TIME_to_Calendar(NativeCrypto.X509_CRL_get_lastUpdate(this.mContext), calendar);
        return calendar.getTime();
    }

    public Date getNextUpdate() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(14, 0);
        NativeCrypto.ASN1_TIME_to_Calendar(NativeCrypto.X509_CRL_get_nextUpdate(this.mContext), calendar);
        return calendar.getTime();
    }

    public X509CRLEntry getRevokedCertificate(BigInteger serialNumber) {
        long revokedRef = NativeCrypto.X509_CRL_get0_by_serial(this.mContext, serialNumber.toByteArray());
        if (revokedRef == 0L) {
            return null;
        }
        return new OpenSSLX509CRLEntry(NativeCrypto.X509_REVOKED_dup(revokedRef));
    }

    public X509CRLEntry getRevokedCertificate(X509Certificate certificate) {
        if (certificate instanceof OpenSSLX509Certificate) {
            OpenSSLX509Certificate osslCert = (OpenSSLX509Certificate)certificate;
            long x509RevokedRef = NativeCrypto.X509_CRL_get0_by_cert(this.mContext, osslCert.getContext());
            if (x509RevokedRef == 0L) {
                return null;
            }
            return new OpenSSLX509CRLEntry(NativeCrypto.X509_REVOKED_dup(x509RevokedRef));
        }
        return this.getRevokedCertificate(certificate.getSerialNumber());
    }

    public Set getRevokedCertificates() {
        long[] entryRefs = NativeCrypto.X509_CRL_get_REVOKED(this.mContext);
        if (entryRefs == null || entryRefs.length == 0) {
            return null;
        }
        HashSet<OpenSSLX509CRLEntry> crlSet = new HashSet<OpenSSLX509CRLEntry>();
        int i = 0;
        while (i < entryRefs.length) {
            long entryRef = entryRefs[i];
            crlSet.add(new OpenSSLX509CRLEntry(entryRef));
            ++i;
        }
        return crlSet;
    }

    public byte[] getTBSCertList() throws CRLException {
        return NativeCrypto.get_X509_CRL_crl_enc(this.mContext);
    }

    public byte[] getSignature() {
        return NativeCrypto.get_X509_CRL_signature(this.mContext);
    }

    public String getSigAlgName() {
        String oid = this.getSigAlgOID();
        String algName = AlgNameMapper.map2AlgName(oid);
        if (algName != null) {
            return algName;
        }
        return oid;
    }

    public String getSigAlgOID() {
        return NativeCrypto.get_X509_CRL_sig_alg_oid(this.mContext);
    }

    public byte[] getSigAlgParams() {
        return NativeCrypto.get_X509_CRL_sig_alg_parameter(this.mContext);
    }

    public boolean isRevoked(Certificate cert) {
        OpenSSLX509Certificate osslCert;
        if (!(cert instanceof X509Certificate)) {
            return false;
        }
        if (cert instanceof OpenSSLX509Certificate) {
            osslCert = (OpenSSLX509Certificate)cert;
        } else {
            try {
                osslCert = OpenSSLX509Certificate.fromX509DerInputStream(new ByteArrayInputStream(cert.getEncoded()));
            }
            catch (Exception e) {
                throw new RuntimeException("cannot convert certificate", e);
            }
        }
        long x509RevokedRef = NativeCrypto.X509_CRL_get0_by_cert(this.mContext, osslCert.getContext());
        return x509RevokedRef != 0L;
    }

    public String toString() {
        String string;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        long bioCtx = NativeCrypto.create_BIO_OutputStream(os);
        try {
            NativeCrypto.X509_CRL_print(bioCtx, this.mContext);
            string = os.toString();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            NativeCrypto.BIO_free_all(bioCtx);
            throw throwable;
        }
        NativeCrypto.BIO_free_all(bioCtx);
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mContext != 0L) {
                NativeCrypto.X509_CRL_free(this.mContext);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }
}

