/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import javax.crypto.BadPaddingException;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.utils.AlgNameMapper;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLBIOInputStream;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLKeyHolder;
import org.conscrypt.OpenSSLProvider;
import org.conscrypt.OpenSSLX509CertificateFactory;
import org.conscrypt.X509PublicKey;

public class OpenSSLX509Certificate
extends X509Certificate {
    private static final long serialVersionUID = 1992239142393372128L;
    private transient long mContext;
    private transient Integer mHashCode;

    OpenSSLX509Certificate(long ctx) {
        this.mContext = ctx;
    }

    public static OpenSSLX509Certificate fromX509DerInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        long certCtx;
        OpenSSLBIOInputStream bis;
        block5: {
            bis = new OpenSSLBIOInputStream(is, true);
            certCtx = NativeCrypto.d2i_X509_bio(bis.getBioContext());
            if (certCtx != 0L) break block5;
            Object var4_4 = null;
            bis.release();
            return null;
        }
        try {
            OpenSSLX509Certificate openSSLX509Certificate = new OpenSSLX509Certificate(certCtx);
            Object var4_5 = null;
            bis.release();
            return openSSLX509Certificate;
        }
        catch (Exception e) {
            try {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                bis.release();
                throw throwable;
            }
        }
    }

    public static OpenSSLX509Certificate fromX509Der(byte[] encoded) throws CertificateEncodingException {
        try {
            return new OpenSSLX509Certificate(NativeCrypto.d2i_X509(encoded));
        }
        catch (OpenSSLX509CertificateFactory.ParsingException e) {
            throw new CertificateEncodingException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List fromPkcs7DerInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        int i;
        ArrayList<OpenSSLX509Certificate> certs;
        long[] certRefs;
        OpenSSLBIOInputStream bis = new OpenSSLBIOInputStream(is, true);
        try {
            try {
                certRefs = NativeCrypto.d2i_PKCS7_bio(bis.getBioContext(), 1);
            }
            catch (Exception e) {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            bis.release();
            throw throwable;
        }
        {
            Object var4_7 = null;
            bis.release();
            if (certRefs == null) {
                return Collections.EMPTY_LIST;
            }
            certs = new ArrayList<OpenSSLX509Certificate>(certRefs.length);
            i = 0;
        }
        while (i < certRefs.length) {
            if (certRefs[i] != 0L) {
                certs.add(new OpenSSLX509Certificate(certRefs[i]));
            }
            ++i;
        }
        return certs;
    }

    public static OpenSSLX509Certificate fromX509PemInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        long certCtx;
        OpenSSLBIOInputStream bis;
        block5: {
            bis = new OpenSSLBIOInputStream(is, true);
            certCtx = NativeCrypto.PEM_read_bio_X509(bis.getBioContext());
            if (certCtx != 0L) break block5;
            Object var4_4 = null;
            bis.release();
            return null;
        }
        try {
            OpenSSLX509Certificate openSSLX509Certificate = new OpenSSLX509Certificate(certCtx);
            Object var4_5 = null;
            bis.release();
            return openSSLX509Certificate;
        }
        catch (Exception e) {
            try {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                bis.release();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List fromPkcs7PemInputStream(InputStream is) throws OpenSSLX509CertificateFactory.ParsingException {
        int i;
        ArrayList<OpenSSLX509Certificate> certs;
        long[] certRefs;
        OpenSSLBIOInputStream bis = new OpenSSLBIOInputStream(is, true);
        try {
            try {
                certRefs = NativeCrypto.PEM_read_bio_PKCS7(bis.getBioContext(), 1);
            }
            catch (Exception e) {
                throw new OpenSSLX509CertificateFactory.ParsingException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            bis.release();
            throw throwable;
        }
        {
            Object var4_7 = null;
            bis.release();
            certs = new ArrayList<OpenSSLX509Certificate>(certRefs.length);
            i = 0;
        }
        while (i < certRefs.length) {
            if (certRefs[i] != 0L) {
                certs.add(new OpenSSLX509Certificate(certRefs[i]));
            }
            ++i;
        }
        return certs;
    }

    public static OpenSSLX509Certificate fromCertificate(Certificate cert) throws CertificateEncodingException {
        if (cert instanceof OpenSSLX509Certificate) {
            return (OpenSSLX509Certificate)cert;
        }
        if (cert instanceof X509Certificate) {
            return OpenSSLX509Certificate.fromX509Der(cert.getEncoded());
        }
        throw new CertificateEncodingException("Only X.509 certificates are supported");
    }

    public Set getCriticalExtensionOIDs() {
        String[] critOids = NativeCrypto.get_X509_ext_oids(this.mContext, 1);
        if (critOids.length == 0 && NativeCrypto.get_X509_ext_oids(this.mContext, 0).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(critOids));
    }

    public byte[] getExtensionValue(String oid) {
        return NativeCrypto.X509_get_ext_oid(this.mContext, oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        String[] nonCritOids = NativeCrypto.get_X509_ext_oids(this.mContext, 0);
        if (nonCritOids.length == 0 && NativeCrypto.get_X509_ext_oids(this.mContext, 1).length == 0) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(nonCritOids));
    }

    public boolean hasUnsupportedCriticalExtension() {
        return (NativeCrypto.get_X509_ex_flags(this.mContext) & 0x200) != 0;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.getNotBefore().compareTo(date) > 0) {
            throw new CertificateNotYetValidException("Certificate not valid until " + this.getNotBefore().toString() + " (compared to " + date.toString() + ")");
        }
        if (this.getNotAfter().compareTo(date) < 0) {
            throw new CertificateExpiredException("Certificate expired at " + this.getNotAfter().toString() + " (compared to " + date.toString() + ")");
        }
    }

    public int getVersion() {
        return (int)NativeCrypto.X509_get_version(this.mContext) + 1;
    }

    public BigInteger getSerialNumber() {
        return new BigInteger(NativeCrypto.X509_get_serialNumber(this.mContext));
    }

    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    public Date getNotBefore() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(14, 0);
        NativeCrypto.ASN1_TIME_to_Calendar(NativeCrypto.X509_get_notBefore(this.mContext), calendar);
        return calendar.getTime();
    }

    public Date getNotAfter() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(14, 0);
        NativeCrypto.ASN1_TIME_to_Calendar(NativeCrypto.X509_get_notAfter(this.mContext), calendar);
        return calendar.getTime();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return NativeCrypto.get_X509_cert_info_enc(this.mContext);
    }

    public byte[] getSignature() {
        return NativeCrypto.get_X509_signature(this.mContext);
    }

    public String getSigAlgName() {
        return AlgNameMapper.map2AlgName(this.getSigAlgOID());
    }

    public String getSigAlgOID() {
        return NativeCrypto.get_X509_sig_alg_oid(this.mContext);
    }

    public byte[] getSigAlgParams() {
        return NativeCrypto.get_X509_sig_alg_parameter(this.mContext);
    }

    public boolean[] getIssuerUniqueID() {
        return NativeCrypto.get_X509_issuerUID(this.mContext);
    }

    public boolean[] getSubjectUniqueID() {
        return NativeCrypto.get_X509_subjectUID(this.mContext);
    }

    public boolean[] getKeyUsage() {
        boolean[] kusage = NativeCrypto.get_X509_ex_kusage(this.mContext);
        if (kusage == null) {
            return null;
        }
        if (kusage.length >= 9) {
            return kusage;
        }
        boolean[] resized = new boolean[9];
        System.arraycopy(kusage, 0, resized, 0, kusage.length);
        return resized;
    }

    public int getBasicConstraints() {
        if ((NativeCrypto.get_X509_ex_flags(this.mContext) & 0x10) == 0) {
            return -1;
        }
        int pathLen = NativeCrypto.get_X509_ex_pathlen(this.mContext);
        if (pathLen == -1) {
            return Integer.MAX_VALUE;
        }
        return pathLen;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return NativeCrypto.i2d_X509(this.mContext);
    }

    private void verifyOpenSSL(OpenSSLKey pkey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        try {
            NativeCrypto.X509_verify(this.mContext, pkey.getNativeRef());
        }
        catch (RuntimeException e) {
            throw new CertificateException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new SignatureException();
        }
    }

    private void verifyInternal(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature sig = sigProvider == null ? Signature.getInstance(this.getSigAlgName()) : Signature.getInstance(this.getSigAlgName(), sigProvider);
        sig.initVerify(key);
        sig.update(this.getTBSCertificate());
        if (!sig.verify(this.getSignature())) {
            throw new SignatureException("signature did not verify");
        }
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (key instanceof OpenSSLKeyHolder) {
            OpenSSLKey pkey = ((OpenSSLKeyHolder)((Object)key)).getOpenSSLKey();
            this.verifyOpenSSL(pkey);
            return;
        }
        this.verifyInternal(key, null);
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verifyInternal(key, sigProvider);
    }

    public void verify(PublicKey key, Provider sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (key instanceof OpenSSLKeyHolder && sigProvider instanceof OpenSSLProvider) {
            OpenSSLKey pkey = ((OpenSSLKeyHolder)((Object)key)).getOpenSSLKey();
            this.verifyOpenSSL(pkey);
            return;
        }
        Signature sig = sigProvider == null ? Signature.getInstance(this.getSigAlgName()) : Signature.getInstance(this.getSigAlgName(), sigProvider);
        sig.initVerify(key);
        sig.update(this.getTBSCertificate());
        if (!sig.verify(this.getSignature())) {
            throw new SignatureException("signature did not verify");
        }
    }

    public String toString() {
        String string;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        long bioCtx = NativeCrypto.create_BIO_OutputStream(os);
        try {
            NativeCrypto.X509_print_ex(bioCtx, this.mContext, 0L, 0L);
            string = os.toString();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            NativeCrypto.BIO_free_all(bioCtx);
            throw throwable;
        }
        NativeCrypto.BIO_free_all(bioCtx);
        return string;
    }

    public PublicKey getPublicKey() {
        try {
            OpenSSLKey pkey = new OpenSSLKey(NativeCrypto.X509_get_pubkey(this.mContext));
            return pkey.getPublicKey();
        }
        catch (NoSuchAlgorithmException pkey) {
        }
        catch (InvalidKeyException pkey) {
            // empty catch block
        }
        String oid = NativeCrypto.get_X509_pubkey_oid(this.mContext);
        byte[] encoded = NativeCrypto.i2d_X509_PUBKEY(this.mContext);
        try {
            KeyFactory kf = KeyFactory.getInstance(oid);
            return kf.generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        return new X509PublicKey(oid, encoded);
    }

    public X500Principal getIssuerX500Principal() {
        byte[] issuer = NativeCrypto.X509_get_issuer_name(this.mContext);
        return new X500Principal(issuer);
    }

    public X500Principal getSubjectX500Principal() {
        byte[] subject = NativeCrypto.X509_get_subject_name(this.mContext);
        return new X500Principal(subject);
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        String[] extUsage = NativeCrypto.get_X509_ex_xkusage(this.mContext);
        if (extUsage == null) {
            return null;
        }
        return Arrays.asList(extUsage);
    }

    private static Collection alternativeNameArrayToList(Object[][] altNameArray) {
        if (altNameArray == null) {
            return null;
        }
        ArrayList<List<Object>> coll = new ArrayList<List<Object>>(altNameArray.length);
        int i = 0;
        while (i < altNameArray.length) {
            coll.add(Collections.unmodifiableList(Arrays.asList(altNameArray[i])));
            ++i;
        }
        return Collections.unmodifiableCollection(coll);
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return OpenSSLX509Certificate.alternativeNameArrayToList(NativeCrypto.get_X509_GENERAL_NAME_stack(this.mContext, 1));
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return OpenSSLX509Certificate.alternativeNameArrayToList(NativeCrypto.get_X509_GENERAL_NAME_stack(this.mContext, 2));
    }

    public boolean equals(Object other) {
        if (other instanceof OpenSSLX509Certificate) {
            OpenSSLX509Certificate o = (OpenSSLX509Certificate)other;
            return NativeCrypto.X509_cmp(this.mContext, o.mContext) == 0;
        }
        return super.equals(other);
    }

    public int hashCode() {
        if (this.mHashCode != null) {
            return this.mHashCode;
        }
        this.mHashCode = new Integer(super.hashCode());
        return this.mHashCode;
    }

    public long getContext() {
        return this.mContext;
    }

    public OpenSSLX509Certificate withDeletedExtension(String oid) {
        OpenSSLX509Certificate copy = new OpenSSLX509Certificate(NativeCrypto.X509_dup(this.mContext));
        NativeCrypto.X509_delete_ext(copy.getContext(), oid);
        return copy;
    }

    public synchronized void free() {
        if (this.mContext != 0L) {
            NativeCrypto.X509_free(this.mContext);
            this.mContext = 0L;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            super.finalize();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        super.finalize();
    }

    static OpenSSLX509Certificate[] createCertChain(long[] certificateRefs) {
        if (certificateRefs == null) {
            return null;
        }
        OpenSSLX509Certificate[] certificates = new OpenSSLX509Certificate[certificateRefs.length];
        int i = 0;
        while (i < certificateRefs.length) {
            certificates[i] = new OpenSSLX509Certificate(certificateRefs[i]);
            ++i;
        }
        return certificates;
    }
}

