/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import com.ibm.oti.util.Inet6Util;
import java.io.FileDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.harmony.security.utils.AlgNameMapper;
import org.apache.harmony.security.utils.AlgNameMapperSource;
import org.conscrypt.AbstractOpenSSLSession;
import org.conscrypt.GCMParameters;
import org.conscrypt.NativeCrypto;
import org.conscrypt.OpenSSLKey;
import org.conscrypt.OpenSSLSocketFactoryImpl;
import org.conscrypt.OpenSSLSocketImpl;

class Platform {
    public static final int MISSING_SSL_MODE_CBC_RECORD_SPLITTING = 256;
    public static final int MISSING_SSL_MODE_ENABLE_FALSE_START = 0;
    public static final int MISSING_SSL_MODE_HANDSHAKE_CUTTHROUGH = 512;
    public static final int MISSING_SSL_ST_OK = 3;
    public static final int MISSING_SSL_ST_INIT = 12288;
    public static final int MISSING_SSL_ST_RENEGOTIATE = 12292;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static void setup() {
        NoPreloadHolder.MAPPER.ping();
    }

    private void ping() {
    }

    public static void unsupported(String string) {
        throw new UnsupportedOperationException(string);
    }

    public static int SSLSession_getPeerPort(SSLSession session) {
        return 0;
    }

    public static int Arrays_hashCode(byte[] bytes) {
        if (bytes == null) {
            return 0;
        }
        int ret = 1;
        int i = 0;
        while (i < bytes.length) {
            ret = ret * 31 + bytes[i];
            ++i;
        }
        return ret;
    }

    public static boolean SSLSession_isValid(SSLSession session) {
        return true;
    }

    public static byte[] Arrays_copyOfRange(byte[] src, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException("from " + from + " > to " + to);
        }
        byte[] ret = new byte[to - from];
        System.arraycopy(src, from, ret, 0, Math.min(to - from, src.length - from));
        return ret;
    }

    public static byte[] Arrays_copyOf(byte[] src, int newLength) {
        byte[] ret = new byte[newLength];
        System.arraycopy(src, 0, ret, 0, Math.min(src.length, newLength));
        return ret;
    }

    private Platform() {
        AlgNameMapper.setSource(new OpenSSLMapper());
    }

    public static FileDescriptor getFileDescriptor(Socket s) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field f_impl = clazz.getDeclaredField("impl");
            f_impl.setAccessible(true);
            Object socketImpl = f_impl.get(s);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.net.SocketImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field f_fd = clazz2.getDeclaredField("fd");
            f_fd.setAccessible(true);
            return (FileDescriptor)f_fd.get(socketImpl);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get FileDescriptor from socket", e);
        }
    }

    public static FileDescriptor getFileDescriptorFromSSLSocket(OpenSSLSocketImpl openSSLSocketImpl) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field f_impl = clazz.getDeclaredField("impl");
            f_impl.setAccessible(true);
            Object socketImpl = f_impl.get(openSSLSocketImpl);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.net.SocketImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field f_fd = clazz2.getDeclaredField("fd");
            f_fd.setAccessible(true);
            return (FileDescriptor)f_fd.get(socketImpl);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't get FileDescriptor from socket", e);
        }
    }

    public static void setSocketWriteTimeout(Socket s, long timeoutMillis) throws SocketException {
    }

    public static void checkServerTrusted(X509TrustManager x509tm, X509Certificate[] chain, String authType, OpenSSLSocketImpl socket) throws CertificateException {
        x509tm.checkServerTrusted(chain, authType);
    }

    public static void checkClientTrusted(X509TrustManager x509tm, X509Certificate[] chain, String authType, OpenSSLSocketImpl socket) throws CertificateException {
        x509tm.checkClientTrusted(chain, authType);
    }

    public static void logEvent(String message) {
        System.out.println(message);
    }

    public static boolean isLiteralIpAddress(String hostname) {
        return Inet6Util.isValidIPV4Address((String)hostname) || Inet6Util.isValidIP6Address((String)hostname);
    }

    public static SSLSocketFactory wrapSocketFactoryIfNeeded(OpenSSLSocketFactoryImpl factory) {
        return factory;
    }

    public static SSLSession wrapSSLSession(AbstractOpenSSLSession sslSession) {
        return sslSession;
    }

    public static SSLSession unwrapSSLSession(SSLSession sslSession) {
        return sslSession;
    }

    public static String getHostStringFromInetSocketAddress(InetSocketAddress addr) {
        return null;
    }

    public static boolean isCTVerificationRequired(String hostname) {
        if (hostname == null) {
            return false;
        }
        String property = Security.getProperty("conscrypt.ct.enable");
        if (property == null || !Boolean.valueOf(property).booleanValue()) {
            return false;
        }
        ArrayList<String> parts = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(hostname, ".");
        while (st.hasMoreElements()) {
            parts.add(st.nextToken());
        }
        Collections.reverse(parts);
        boolean enable = false;
        String propertyName = "conscrypt.ct.enforce";
        Iterator iter = parts.iterator();
        while (iter.hasNext()) {
            String part = (String)iter.next();
            property = Security.getProperty(String.valueOf(propertyName) + ".*");
            if (property != null) {
                enable = Boolean.valueOf(property);
            }
            propertyName = String.valueOf(propertyName) + "." + part;
        }
        property = Security.getProperty(propertyName);
        if (property != null) {
            enable = Boolean.valueOf(property);
        }
        return enable;
    }

    public static GCMParameters fromGCMParameterSpec(AlgorithmParameterSpec params) {
        Class<?> gcmSpecClass;
        try {
            gcmSpecClass = Class.forName("javax.crypto.spec.GCMParameterSpec");
        }
        catch (ClassNotFoundException e) {
            gcmSpecClass = null;
        }
        if (gcmSpecClass != null && gcmSpecClass.isAssignableFrom(params.getClass())) {
            try {
                Method getTLenMethod = gcmSpecClass.getMethod("getTLen", new Class[0]);
                Method getIVMethod = gcmSpecClass.getMethod("getIV", new Class[0]);
                int tLen = (Integer)getTLenMethod.invoke((Object)params, new Object[0]);
                byte[] iv = (byte[])getIVMethod.invoke((Object)params, new Object[0]);
                return new GCMParameters(tLen, iv);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("GCMParameterSpec lacks expected methods", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("GCMParameterSpec lacks expected methods", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Could not fetch GCM parameters", e.getTargetException());
            }
        }
        return null;
    }

    public static AlgorithmParameterSpec toGCMParameterSpec(int tagLenInBits, byte[] iv) {
        Class<?> gcmSpecClass;
        try {
            gcmSpecClass = Class.forName("javax.crypto.spec.GCMParameterSpec");
        }
        catch (ClassNotFoundException e) {
            gcmSpecClass = null;
        }
        if (gcmSpecClass != null) {
            try {
                Class[] classArray = new Class[2];
                classArray[0] = Integer.TYPE;
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("[B");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz;
                Constructor<?> constructor = gcmSpecClass.getConstructor(classArray);
                return (AlgorithmParameterSpec)constructor.newInstance(new Integer(tagLenInBits), iv);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
            }
        }
        return null;
    }

    public static OpenSSLKey wrapRsaKey(PrivateKey javaKey) {
        return null;
    }

    public static Object closeGuardGet() {
        return null;
    }

    public static void closeGuardWarnIfOpen(Object guard) {
    }

    public static void closeGuardClose(Object guard) {
    }

    public static void closeGuardOpen(Object guard, String op) {
    }

    public static void blockGuardOnNetwork() {
    }

    public static Integer createInteger(int i) {
        return new Integer(i);
    }

    /* synthetic */ Platform(Platform platform) {
        this();
    }

    private static class NoPreloadHolder {
        public static final Platform MAPPER = new Platform(null);

        private NoPreloadHolder() {
        }
    }

    private static class OpenSSLMapper
    implements AlgNameMapperSource {
        private OpenSSLMapper() {
        }

        public String mapNameToOid(String algName) {
            return NativeCrypto.OBJ_txt2nid_oid(algName);
        }

        public String mapOidToName(String oid) {
            return NativeCrypto.OBJ_txt2nid_longName(oid);
        }
    }
}

