/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

public final class SSLUtils {
    static final boolean USE_ENGINE_SOCKET_BY_DEFAULT = Boolean.valueOf(System.getProperty("org.conscrypt.useEngineSocketByDefault"));
    static final int MAX_PROTOCOL_LENGTH = 255;
    private static final int MAX_ENCRYPTION_OVERHEAD_LENGTH = 85;
    private static final int MAX_ENCRYPTION_OVERHEAD_DIFF = 0x7FFFFFAA;

    public static int calculateOutNetBufSize(int pendingBytes) {
        return Math.min(17733, 85 + Math.min(0x7FFFFFAA, pendingBytes));
    }

    static SSLHandshakeException toSSLHandshakeException(Throwable e) {
        if (e instanceof SSLHandshakeException) {
            return (SSLHandshakeException)e;
        }
        return (SSLHandshakeException)new SSLHandshakeException(e.getMessage()).initCause(e);
    }

    static SSLException toSSLException(Throwable e) {
        if (e instanceof SSLException) {
            return (SSLException)e;
        }
        return new SSLException(e.getMessage());
    }

    public static byte[] toLengthPrefixedList(String[] protocols) {
        int length = 0;
        int i = 0;
        while (i < protocols.length) {
            int protocolLength = protocols[i].length();
            if (protocolLength == 0 || protocolLength > 255) {
                throw new IllegalArgumentException("Protocol has invalid length (" + protocolLength + "): " + protocols[i]);
            }
            length += 1 + protocolLength;
            ++i;
        }
        byte[] data = new byte[length];
        int dataIndex = 0;
        int i2 = 0;
        while (i2 < protocols.length) {
            String protocol = protocols[i2];
            int protocolLength = protocol.length();
            data[dataIndex++] = (byte)protocolLength;
            int ci = 0;
            while (ci < protocolLength) {
                char c = protocol.charAt(ci);
                if (c > '\u007f') {
                    throw new IllegalArgumentException("Protocol contains invalid character: " + c + "(protocol=" + protocol + ")");
                }
                data[dataIndex++] = (byte)c;
                ++ci;
            }
            ++i2;
        }
        return data;
    }

    private static int getEncryptedPacketLength(byte[] buffer) {
        int packetLength = 0;
        switch (buffer[0]) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                return -1;
            }
        }
        int majorVersion = buffer[1] & 0xFF;
        if (majorVersion != 3) {
            return -1;
        }
        packetLength = (buffer[3] & 0xFF) << 8;
        packetLength += buffer[4] & 0xFF;
        if ((packetLength += 5) <= 5) {
            return -1;
        }
        return packetLength;
    }

    private static short unsignedByte(byte b) {
        return (short)(b & 0xFF);
    }

    private static int unsignedShort(short s) {
        return s & 0xFFFF;
    }

    private SSLUtils() {
    }
}

