/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step1;

import com.polyhedra.sql.SQLException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import se.ericsson.cello.aueframework.collector.CollectorContext;
import se.ericsson.cello.aueframework.collector.CollectorEdge;
import se.ericsson.cello.aueframework.collector.CollectorGraph;
import se.ericsson.cello.aueframework.collector.WriteableCollectorContext;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.DateTimeHelper;
import se.ericsson.crbs.omf.aue.common.LoggerImpl;
import se.ericsson.crbs.omf.aue.common.MainAueHelper;
import se.ericsson.crbs.omf.aue.common.RbsAueMetaData;
import se.ericsson.crbs.omf.aue.common.db.DbWrapper;
import se.ericsson.crbs.omf.aue.common.db.DbWrapperFactory;
import se.ericsson.crbs.omf.aue.common.db.sql.Sql;
import se.ericsson.crbs.omf.aue.common.jar.XmlHolder;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;
import se.ericsson.crbs.omf.aue.common.xml.ModificationXmlVersionHandler;
import se.ericsson.crbs.omf.aue.common.xml.MomInfo;
import se.ericsson.crbs.omf.aue.common.xml.XmlResourceFactory;
import se.ericsson.crbs.omf.aue.step1.AbstractLastCollectorEdge;
import se.ericsson.crbs.omf.aue.step1.AbstractRbsAueStep1;
import se.ericsson.crbs.omf.aue.step1.AbstractRbsAueStep1Helper;
import se.ericsson.crbs.omf.aue.step1.CollectorEdgeImpl;
import se.ericsson.crbs.omf.aue.step1.LastCollectorEdge;
import se.ericsson.crbs.omf.aue.step1.MomVersionHandler;
import se.ericsson.crbs.omf.aue.step1.RbsCollectorHandler;
import se.ericsson.crbs.omf.aue.step1.RbsCollectorHandlerImpl;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableDataException;
import se.ericsson.crbs.omf.aue.step1.actions.data.TableHandlerImpl;
import se.ericsson.crbs.omf.aue.step1.common.RbsDataCollector;
import se.ericsson.crbs.omf.aue.step1.common.SequenceHolderStep1;

public class AbstractRbsAueStep1HelperImpl
implements RbsDataCollector,
AbstractRbsAueStep1Helper {
    private static final Class THIS_CLASS = AbstractRbsAueStep1.class;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final MainAueHelper mainAueHelper;
    private MomInfo lastMomInfo;
    private String froVersionsTableName = "";
    private String froAttributesTableName = "";
    private final RbsAueMetaData rbsAueMetaData;
    private final Map rbsCollectorHandlers = new HashMap();

    public AbstractRbsAueStep1HelperImpl(RbsAueMetaData rbsAueMetaData) throws CrbsAueException {
        this.rbsAueMetaData = rbsAueMetaData;
        this.froVersionsTableName = rbsAueMetaData.getFroVersionsTableName();
        this.froAttributesTableName = rbsAueMetaData.getFroAttributesTableName();
        this.mainAueHelper = new MainAueHelper(rbsAueMetaData.getPropertiesFileStep1());
        new LoggerImpl(true);
        logger.info(THIS_CLASS, "Step1MainAue is starting now " + new Date().toString());
        logger.traceDebug(THIS_CLASS, "Step1MainAue initiating..");
        this.dropAndCreateAuePersistencyTable();
    }

    public CollectorGraph getCollectorGraph(XmlHolder[] xmlHolders, LastCollectorEdge lastCollectorEdge) {
        CollectorGraph collectorGraph;
        block5: {
            logger.traceEnter(THIS_CLASS, "getCollectorGraph()");
            boolean success = false;
            collectorGraph = null;
            ArrayList<LastCollectorEdge> edgeList = new ArrayList<LastCollectorEdge>();
            try {
                success = this.parseXmlFiles(edgeList, xmlHolders);
                if (!success) break block5;
                if (this.lastMomInfo == null) {
                    logger.traceError(THIS_CLASS, "Cannot determine MOM version to upgrade to");
                    break block5;
                }
                logger.traceDebug(THIS_CLASS, "The MOM will be upgraded to version " + this.lastMomInfo);
                lastCollectorEdge.setFromRevision(this.lastMomInfo.toString());
                edgeList.add(lastCollectorEdge);
                logger.traceDebug(THIS_CLASS, "Added \"Last Conversion Step\", from: " + lastCollectorEdge.getFromRevision() + ", to: " + lastCollectorEdge.getToRevision());
                CollectorEdge[] edges = new CollectorEdge[edgeList.size()];
                edgeList.toArray(edges);
                try {
                    this.lastMomInfo = MomInfo.getMomInfo(lastCollectorEdge.getToRevision());
                    logger.traceGeneral(THIS_CLASS, "Last conversion step set to: " + this.lastMomInfo);
                }
                catch (ParseException pe) {
                    logger.traceError(THIS_CLASS, "Failed to set the \"to version\" to the version specfied in the \"Last Collector Step\". This will prevent this last edge from being run.");
                }
                collectorGraph = new CollectorGraph(edges);
                logger.traceDebug(THIS_CLASS, "Created collector graph with " + edges.length + " nodes");
            }
            catch (SAXException se) {
                logger.traceError(THIS_CLASS, "Unable to instantiate SAXParser", se);
            }
        }
        logger.traceReturn(THIS_CLASS, "getCollectorGraph()");
        return collectorGraph;
    }

    private boolean parseXmlFiles(List edgeList, XmlHolder[] xmlHolders) throws SAXException {
        boolean success = false;
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        ModificationXmlVersionHandler handler = new ModificationXmlVersionHandler();
        parser.setContentHandler(handler);
        for (int i = 0; i < xmlHolders.length; ++i) {
            try {
                logger.traceGeneral(THIS_CLASS, "getConversionGraph xmlResourceName " + AueUtil.doubleQuote(xmlHolders[i].getPath()));
                ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlHolders[i].getContents().getBytes());
                InputSource inputSource = new InputSource(inputStream);
                parser.parse(inputSource);
                ((InputStream)inputStream).close();
                MomInfo fromMomInfo = handler.getFromMomInfo();
                MomInfo toMomInfo = handler.getToMomInfo();
                CollectorEdge collectorEdge = this.getCollectorEdge(fromMomInfo.toString(), toMomInfo.toString(), xmlHolders[i]);
                if (this.lastMomInfo == null || this.lastMomInfo.intValue() < toMomInfo.intValue()) {
                    this.lastMomInfo = toMomInfo;
                    logger.traceGeneral(THIS_CLASS, "getConversionGraph latestMomInfo: " + this.lastMomInfo);
                }
                edgeList.add(collectorEdge);
                logger.traceDebug(THIS_CLASS, "Adding ConversionStep from " + fromMomInfo + " to " + toMomInfo + ", xml=" + xmlHolders[i]);
                success = true;
                continue;
            }
            catch (IOException ioe) {
                logger.traceError(THIS_CLASS, "IO exception when parsing file " + xmlHolders[i], ioe);
                success = false;
                break;
            }
            catch (SAXException se) {
                logger.traceError(THIS_CLASS, "Parse error when parsing file " + xmlHolders[i], se);
                success = false;
                break;
            }
        }
        return success;
    }

    protected CollectorEdge getCollectorEdge(String fromRevision, String toRevision, XmlHolder xmlHolder) {
        return new CollectorEdgeImpl(fromRevision, toRevision, xmlHolder);
    }

    private MomInfo getFromVersion() throws SAXException, IOException, CrbsAueException {
        MomInfo momInfo = null;
        String toVersionFromPreviousUpgrade = AueUtil.getToVersionFromPreviousUpgrade(this.rbsAueMetaData.getAueName());
        if (!"".equals(toVersionFromPreviousUpgrade) && toVersionFromPreviousUpgrade != null) {
            try {
                momInfo = MomInfo.getMomInfo(toVersionFromPreviousUpgrade);
            }
            catch (ParseException e) {
                logger.traceAbnormal(THIS_CLASS, "Failed to create MomInfo from version read from performedUpgrades table. Version read = " + toVersionFromPreviousUpgrade + " . From version parsed from MOM instead.");
            }
        }
        if (momInfo == null) {
            try {
                momInfo = this.getFromMomInfo();
            }
            catch (IOException e) {
                String defaultStartVersion = this.rbsAueMetaData.getDefaultStartVersion();
                try {
                    momInfo = MomInfo.getMomInfo(defaultStartVersion);
                    logger.traceAbnormal(THIS_CLASS, "Failed to read from version from performedUpgrade and MOM. The hard coded value will be used instead: " + defaultStartVersion);
                }
                catch (ParseException e1) {
                    throw new CrbsAueException("Can not parse mom info :" + defaultStartVersion, e1);
                }
            }
        }
        return momInfo;
    }

    private MomInfo getFromMomInfo() throws SAXException, IOException {
        logger.traceEnter(THIS_CLASS, "getFromMomInfo()");
        String momFilePath = this.rbsAueMetaData.getMomDir();
        InputStream momInputStream = null;
        String[] momFileNames = this.rbsAueMetaData.getMomFileNames();
        for (int mfn = 0; mfn < momFileNames.length && momInputStream == null; ++mfn) {
            momInputStream = XmlResourceFactory.getXmlInputStream(momFilePath + momFileNames[mfn]);
        }
        final InputStream dtdInputStream = XmlResourceFactory.getXmlInputStream(momFilePath + this.rbsAueMetaData.getMomDtdFileName());
        InputSource inputSource = new InputSource(momInputStream);
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        MomVersionHandler handler = new MomVersionHandler();
        parser.setContentHandler(handler);
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                InputSource inp = null;
                logger.traceDebug(THIS_CLASS, "resolveEntity systemId " + systemId);
                if (systemId.endsWith(AbstractRbsAueStep1HelperImpl.this.rbsAueMetaData.getMomDtdFileName())) {
                    inp = new InputSource(dtdInputStream);
                }
                logger.traceDebug(THIS_CLASS, "resolveEntity inp " + inp);
                return inp;
            }
        });
        logger.traceDebug(THIS_CLASS, "getFromMomInfo starting to parse...");
        try {
            parser.parse(inputSource);
        }
        catch (SAXException saxe) {
            if (saxe == handler.allDoneException) {
                logger.traceDebug(THIS_CLASS, "getFromMomInfo parsing done");
            }
            throw saxe;
        }
        MomInfo momInfo = handler.getMomInfo();
        logger.traceDebug(THIS_CLASS, "getFromMomInfo: fromMomInfo=" + momInfo);
        logger.traceReturn(THIS_CLASS, "getFromMomInfo()");
        return momInfo;
    }

    private void dropAndCreateAuePersistencyTable() throws CrbsAueException {
        DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
        try {
            dbWrapper.openConnection();
            if (dbWrapper.doTableExist(this.rbsAueMetaData.getAuePersistencyTableName())) {
                dbWrapper.executeUpdate(new Sql.DropTable(this.rbsAueMetaData.getAuePersistencyTableName()));
            }
            dbWrapper.executeUpdate(new Sql.CreateTable(this.rbsAueMetaData.getAuePersistencyTableName(), new Sql.CreateTable.ColumnSpec[]{new Sql.CreateTable.ColumnSpec("name", Sql.SqlDataType.SQL_VARCHAR, 0, null, true), new Sql.CreateTable.ColumnSpec("value", Sql.SqlDataType.SQL_VARCHAR, 0, null, false)}));
        }
        catch (SQLException e) {
            throw new CrbsAueException("Exception when creating AuePersistencyTable " + (Object)((Object)e));
        }
    }

    private void storeFromMomInfo(DbWrapper dbWrapper, MomInfo fromMomInfo) throws SQLException {
        try {
            dbWrapper.executeUpdate("INSERT INTO " + this.rbsAueMetaData.getAuePersistencyTableName() + " VALUES ( " + AueUtil.quote("FROM_MOM_VERSION") + ", " + AueUtil.quote(fromMomInfo.toString()) + " )");
        }
        catch (SQLException sqle) {
            dbWrapper.executeUpdate("UPDATE " + this.rbsAueMetaData.getAuePersistencyTableName() + " SET value = " + AueUtil.quote(fromMomInfo.toString()) + " WHERE name = " + AueUtil.quote("FROM_MOM_VERSION"));
        }
    }

    public RbsDataCollector getRbsDataCollector(WriteableCollectorContext collectorContext, AbstractRbsAueStep1 abstractRbsAueStep1) {
        logger.traceEnter(THIS_CLASS, "getRbsDataCollector()" + this.rbsAueMetaData.getAueName());
        logger.info(THIS_CLASS, "Memory usage before metaData.getAueName() step1 is " + AueUtil.getUsedMemory() + " bytes of memory");
        AbstractRbsAueStep1 result = abstractRbsAueStep1;
        try {
            XmlHolder[] xmlHolders = this.mainAueHelper.getModificationXmlHolders();
            DbWrapper dbWrapper = DbWrapperFactory.getInstance().getDbWrapper();
            MomInfo fromMomInfo = this.getFromVersion();
            AbstractLastCollectorEdge lastCollectorEdge = abstractRbsAueStep1.getLastCollectorEdge(this.mainAueHelper.getResetXmlHolder());
            this.createRbsCollectorHandlers(xmlHolders, fromMomInfo, lastCollectorEdge);
            this.storeFromMomInfo(dbWrapper, fromMomInfo);
        }
        catch (CrbsAueException auee) {
            logger.traceError(THIS_CLASS, "Unable to process modification files: " + AueUtil.getExceptionMessage((Throwable)((Object)auee)), (Throwable)((Object)auee));
            result = null;
        }
        catch (SAXException saxe) {
            logger.traceError(THIS_CLASS, "Unable to parse MOM: " + AueUtil.getExceptionMessage(saxe), saxe);
            result = null;
        }
        catch (IOException ioe) {
            logger.traceError(THIS_CLASS, "Unable to parse MOM: " + AueUtil.getExceptionMessage(ioe), ioe);
            result = null;
        }
        catch (SQLException se) {
            logger.traceError(THIS_CLASS, "Database error: " + se.getMessage(), se);
            result = null;
        }
        logger.traceReturn(THIS_CLASS, "getRbsDataCollector()" + this.rbsAueMetaData.getAueName());
        return result;
    }

    private void createRbsCollectorHandlers(XmlHolder[] xmlHolders, MomInfo fromMomInfo, LastCollectorEdge lastCollectorEdge) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "createRbsCollectorHandlers()");
        try {
            SequenceHolderStep1[] sequenceHolders = this.parseXmlFiles(xmlHolders);
            this.finalizeSequenceHolders(sequenceHolders, fromMomInfo, lastCollectorEdge);
        }
        catch (SAXException se) {
            logger.traceError(THIS_CLASS, "", se);
        }
        catch (ParseException pe) {
            logger.traceError(THIS_CLASS, "Unable to determine the very last conversion step!");
        }
        logger.traceReturn(THIS_CLASS, "createRbsCollectorHandlers()");
    }

    private void finalizeSequenceHolders(SequenceHolderStep1[] sequenceHolders, MomInfo fromMomInfo, LastCollectorEdge lastCollectorEdge) throws ParseException {
        SequenceHolderStep1 lastSequence = null;
        for (int index = 0; index < sequenceHolders.length; ++index) {
            if (lastSequence != null && lastSequence.getSequenceToVersion().intValue() >= sequenceHolders[index].getSequenceToVersion().intValue()) continue;
            lastSequence = sequenceHolders[index];
        }
        logger.traceDebug(THIS_CLASS, "The MOM for AUE " + this.rbsAueMetaData.getAueName() + " will be upgraded to version " + lastSequence.getSequenceToVersion().toString());
        lastCollectorEdge.setFromRevision(lastSequence.getSequenceToVersion().toString());
        lastSequence.addCollectorEdge(lastSequence.getSequenceToVersion(), MomInfo.getMomInfo("Z.99.99"), lastCollectorEdge);
        int fromMomInfoIntValue = fromMomInfo.intValue();
        for (int index = 0; index < sequenceHolders.length; ++index) {
            if (fromMomInfoIntValue < sequenceHolders[index].getSequenceToVersion().intValue()) {
                CollectorGraph collectorGraph = new CollectorGraph(sequenceHolders[index].getCollectorEdges());
                logger.traceDebug(THIS_CLASS, "Created conversion graph with " + sequenceHolders[index].getCollectorEdges().length + " nodes");
                MomInfo fromMomInfoForThisSequence = fromMomInfoIntValue > sequenceHolders[index].getSequenceFromVersion().intValue() ? fromMomInfo : sequenceHolders[index].getSequenceFromVersion();
                RbsCollectorHandlerImpl rbsUpgradeHandler = new RbsCollectorHandlerImpl(collectorGraph, fromMomInfoForThisSequence, sequenceHolders[index].getSequenceToVersion(), sequenceHolders[index].getSequenceToVersionExcludingLastStep());
                this.rbsCollectorHandlers.put(sequenceHolders[index].getSequenceNumber(), rbsUpgradeHandler);
                continue;
            }
            logger.traceDebug(THIS_CLASS, "Converter " + this.rbsAueMetaData.getAueName() + " will not perform sequence " + sequenceHolders[index].getSequenceNumber() + " from MOM version " + sequenceHolders[index].getSequenceFromVersion() + " to " + sequenceHolders[index].getSequenceToVersion() + ".");
        }
    }

    public Integer[] getWantedRbsSequenceNumbers() {
        return this.rbsCollectorHandlers.keySet().toArray(new Integer[this.rbsCollectorHandlers.size()]);
    }

    private SequenceHolderStep1[] parseXmlFiles(XmlHolder[] xmlHolders) throws CrbsAueException, SAXException {
        HashMap<Integer, SequenceHolderStep1> sequenceMap = new HashMap<Integer, SequenceHolderStep1>();
        XMLReader parser = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        ModificationXmlVersionHandler handler = new ModificationXmlVersionHandler();
        parser.setContentHandler(handler);
        String xmlResourceName = null;
        for (int i = 0; i < xmlHolders.length; ++i) {
            try {
                xmlResourceName = xmlHolders[i].getPath();
                logger.traceGeneral(THIS_CLASS, "getConversionGraph xmlResourceName " + AueUtil.doubleQuote(xmlResourceName));
                ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlHolders[i].getContents().getBytes());
                InputSource inputSource = new InputSource(inputStream);
                parser.parse(inputSource);
                ((InputStream)inputStream).close();
                MomInfo fromMomInfo = handler.getFromMomInfo();
                MomInfo toMomInfo = handler.getToMomInfo();
                Integer sequenceNumber = handler.getSequenceNumber();
                CollectorEdge collectorEdge = this.getCollectorEdge(fromMomInfo.toString(), toMomInfo.toString(), xmlHolders[i]);
                logger.traceDebug(THIS_CLASS, "Adding ConversionStep from " + fromMomInfo + " to " + toMomInfo + " for sequence " + sequenceNumber + " , xml=" + xmlResourceName);
                if (sequenceMap.containsKey(sequenceNumber)) {
                    ((SequenceHolderStep1)sequenceMap.get(sequenceNumber)).addCollectorEdge(fromMomInfo, toMomInfo, collectorEdge);
                    continue;
                }
                SequenceHolderStep1 sequenceHolder = new SequenceHolderStep1(sequenceNumber);
                sequenceHolder.addCollectorEdge(fromMomInfo, toMomInfo, collectorEdge);
                sequenceMap.put(sequenceNumber, sequenceHolder);
                continue;
            }
            catch (IOException ioe) {
                logger.traceDebug(THIS_CLASS, AueUtil.appendReason("IO exception when parsing file " + xmlResourceName, ioe));
                throw new CrbsAueException("IO exception when parsing file " + xmlResourceName, ioe);
            }
            catch (SAXException se) {
                logger.traceDebug(THIS_CLASS, AueUtil.appendReason("Parse error when parsing file " + xmlResourceName, se));
                throw new CrbsAueException("Parse error when parsing file " + xmlResourceName, se);
            }
        }
        SequenceHolderStep1[] sequenceHolders = new SequenceHolderStep1[sequenceMap.size()];
        sequenceMap.values().toArray(sequenceHolders);
        return sequenceHolders;
    }

    public void collect(CollectorContext collectorContext, Integer currentSequenceNumber) throws CrbsAueException {
        long endTime;
        SimpleDateFormat dateFormat;
        if (this.rbsCollectorHandlers.containsKey(currentSequenceNumber)) {
            dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
            long startTime = System.currentTimeMillis();
            int memoryAtStart = (int)(AueUtil.getUsedMemory() / 1000L);
            logger.info(THIS_CLASS, this.rbsAueMetaData.getAueName() + " started " + DateTimeHelper.dateToString(startTime, dateFormat));
            RbsCollectorHandler currentRbsCollectorHandler = (RbsCollectorHandler)this.rbsCollectorHandlers.get(currentSequenceNumber);
            TableHandlerImpl tableHandler = new TableHandlerImpl(this.rbsAueMetaData, currentRbsCollectorHandler.getFromVersion(), currentRbsCollectorHandler.getToVersionExcludingLastCollectorEdge(), this.froVersionsTableName, this.froAttributesTableName);
            collectorContext.setAttribute("CURRENT_TABLE_HANDLER", (Object)tableHandler);
            try {
                currentRbsCollectorHandler.collect(collectorContext);
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
            try {
                tableHandler.storeAllTables();
            }
            catch (TableDataException tde) {
                throw new CrbsAueException(tde.getMessage(), tde);
            }
            this.froAttributesTableName = this.rbsAueMetaData.getFroAttributesTableName() + "_new";
            this.froVersionsTableName = this.rbsAueMetaData.getFroVersionsTableName() + "_new";
            endTime = System.currentTimeMillis();
            int memoryAtEnd = (int)(AueUtil.getUsedMemory() / 1000L);
            try {
                tableHandler.storePerformedUpgradeSequence(startTime, endTime, memoryAtStart, memoryAtEnd, collectorContext);
            }
            catch (Exception exception) {
                logger.traceError(THIS_CLASS, "Unable to store information about performed upgrade! " + AueUtil.getExceptionMessage(exception));
            }
        } else {
            throw new CrbsAueException("Incorrect trigger, " + currentSequenceNumber + " recived from RbsSequencer to upgrade participant " + this.rbsAueMetaData.getAueName() + ".");
        }
        logger.info(THIS_CLASS, this.rbsAueMetaData.getAueName() + " finished " + DateTimeHelper.dateToString(endTime, dateFormat));
    }

    public String[] getTablesToUpdate() {
        return new String[]{this.rbsAueMetaData.getFroAttributesTableName(), this.rbsAueMetaData.getFroVersionsTableName()};
    }

    public String getConverterName() {
        return this.rbsAueMetaData.getAueName();
    }
}

