/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.launcher;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import se.ericsson.security.launcher.ApplicationFileInterface;
import se.ericsson.security.launcher.ExceptionHandlerInterface;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.MetaLauncherInterface;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.download.DownloadListener;
import se.ericsson.security.utils.EmLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionedLauncherAdapter
implements LauncherInterface.RevLATEST {
    private static final EmLogger LOG = EmLogger.LAUNCHER;
    private Object launcher;
    private ClassLoader classLoader;

    public VersionedLauncherAdapter(ClassLoader cl) throws LauncherException {
        this.classLoader = cl;
        try {
            Class<?> c = this.classLoader.loadClass("se.ericsson.security.launcher.Launcher");
            Method m = c.getMethod("getInstance", ClassLoader.class);
            this.launcher = m.invoke(null, cl);
        }
        catch (ClassNotFoundException e) {
            LOG.severe("Unable to load initial Loader" + e.toString(), new Object[0]);
            throw new LauncherException("Failed to create adapter: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            LOG.severe("Unable to access class" + e.toString(), new Object[0]);
            throw new LauncherException("Failed to create adapter: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            LOG.severe("Failed method access: " + e.toString(), new Object[0]);
            throw new LauncherException("Failed to create adapter: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            LOG.severe("Failed method invocation: " + e.toString(), new Object[0]);
            e.getTargetException().printStackTrace();
            throw new LauncherException("Failed to create adapter: " + e.getTargetException().getMessage());
        }
    }

    public String getVersion() {
        try {
            return (String)this.callMethod("getVersion", null, null);
        }
        catch (LauncherException e) {
            LOG.severe("Failed getting version: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Override
    public String getProductNumber() {
        try {
            return (String)this.callMethod("getProductNumber", null, null);
        }
        catch (LauncherException e) {
            LOG.severe("Failed getting version: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    public void setMetaLauncher(MetaLauncherInterface metaLauncher) {
        try {
            Class[] parTypes = new Class[]{MetaLauncherInterface.class};
            Object[] arglist = new Object[]{metaLauncher};
            this.callMethod("setMetaLauncher", parTypes, arglist);
        }
        catch (LauncherException e) {
            LOG.severe("Unable to set meta-launcher" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public Launchable runApplication(String nameOrPath, String hostname, Properties arguments, Launchable parent_ref) throws LauncherException {
        Class[] parTypes = new Class[]{String.class, String.class, Properties.class, Launchable.class};
        Object[] arglist = new Object[]{nameOrPath, hostname, arguments, parent_ref};
        return (Launchable)this.callMethod("runApplication", parTypes, arglist);
    }

    @Override
    public Launchable runResource(String nameOrPath, String hostname, Properties arguments, Launchable parent_ref) throws LauncherException {
        Class[] parTypes = new Class[]{String.class, String.class, Properties.class, Launchable.class};
        Object[] arglist = new Object[]{nameOrPath, hostname, arguments, parent_ref};
        return (Launchable)this.callMethod("runResource", parTypes, arglist);
    }

    @Override
    public boolean hasNESameVersion(String url, Launchable callerApplication) {
        try {
            Class[] parTypes = new Class[]{String.class, Launchable.class};
            Object[] arglist = new Object[]{url, callerApplication};
            Boolean res = (Boolean)this.callMethod("hasNESameVersion", parTypes, arglist);
            return res;
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return false;
        }
    }

    @Override
    public boolean hasNESameSecurityState(String url, Launchable callerApplication) {
        try {
            Class[] parTypes = new Class[]{String.class, Launchable.class};
            Object[] arglist = new Object[]{url, callerApplication};
            Boolean res = (Boolean)this.callMethod("hasNESameSecurityState", parTypes, arglist);
            return res;
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return false;
        }
    }

    @Override
    public String getFile(URL fileName, DownloadListener downloadListener) throws LauncherException {
        Class[] parTypes = new Class[]{URL.class, DownloadListener.class};
        Object[] arglist = new Object[]{fileName, downloadListener};
        return (String)this.callMethod("getFile", parTypes, arglist);
    }

    @Override
    public String getFile(URL fileName, String productName, String productNumber, String productRevision, DownloadListener downloadListener) throws LauncherException {
        Class[] parTypes = new Class[]{URL.class, String.class, String.class, String.class, DownloadListener.class};
        Object[] arglist = new Object[]{fileName, productName, productNumber, productRevision, downloadListener};
        return (String)this.callMethod("getFile", parTypes, arglist);
    }

    @Override
    public void onExit(Launchable app) {
        try {
            Class[] parTypes = new Class[]{Launchable.class};
            Object[] arglist = new Object[]{app};
            this.callMethod("onExit", parTypes, arglist);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
        }
    }

    public Collection getRunningApplications() {
        try {
            return (Collection)this.callMethod("getRunningApplications", null, null);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return null;
        }
    }

    public Collection getRunningResources() {
        try {
            return (Collection)this.callMethod("getRunningResources", null, null);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Override
    public Properties getApplVersion(Launchable callerApplication) {
        try {
            Class[] parTypes = new Class[]{Launchable.class};
            Object[] arglist = new Object[]{callerApplication};
            return (Properties)this.callMethod("getApplVersion", parTypes, arglist);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return null;
        }
    }

    @Override
    public void NESwitch(String NEAddress, Launchable callerApplication) throws LauncherException {
        Class[] parTypes = new Class[]{String.class, Launchable.class};
        Object[] arglist = new Object[]{NEAddress, callerApplication};
        this.callMethod("NESwitch", parTypes, arglist);
    }

    public boolean runsApp(Launchable app) {
        try {
            Class[] parTypes = new Class[]{Launchable.class};
            Object[] arglist = new Object[]{app};
            Boolean res = (Boolean)this.callMethod("runsApp", parTypes, arglist);
            return res;
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return false;
        }
    }

    public URL getNEAddress(Launchable app) {
        try {
            Class[] parTypes = new Class[]{Launchable.class};
            Object[] arglist = new Object[]{app};
            return (URL)this.callMethod("getNEAddress", parTypes, arglist);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return null;
        }
    }

    public Collection getConfigurationFiles(Launchable app) {
        try {
            Class[] parTypes = new Class[]{Launchable.class};
            Object[] arglist = new Object[]{app};
            return (Collection)this.callMethod("getConfigurationFiles", parTypes, arglist);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
            return null;
        }
    }

    public ProgressListenerInterface getProgressListener() {
        try {
            return (ProgressListenerInterface)this.callMethod("getProgressListener", null, null);
        }
        catch (LauncherException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                LOG.warning(e.getMessage(), new Object[0]);
            } else {
                LOG.severe(e.getMessage(), new Object[0]);
            }
            return null;
        }
    }

    public ProgressListenerInterface openSplash() {
        try {
            return (ProgressListenerInterface)this.callMethod("openSplash", null, null);
        }
        catch (LauncherException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                LOG.warning(e.getMessage(), new Object[0]);
            } else {
                LOG.severe(e.getMessage(), new Object[0]);
            }
            return null;
        }
    }

    @Override
    public void setExceptionHandler(Launchable l, ExceptionHandlerInterface eh) {
        try {
            Class[] parTypes = new Class[]{Launchable.class, ExceptionHandlerInterface.class};
            Object[] arglist = new Object[]{l, eh};
            this.callMethod("setExceptionHandler", parTypes, arglist);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
        }
    }

    public Collection getUsedJars(ApplicationFileInterface appFileI) {
        try {
            Class[] parTypes = new Class[]{ApplicationFileInterface.class};
            Object[] arglist = new Object[]{appFileI};
            return (Collection)this.callMethod("getUsedJars", parTypes, arglist);
        }
        catch (LauncherException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                LOG.warning(e.getMessage(), new Object[0]);
            } else {
                LOG.severe(e.getMessage(), new Object[0]);
            }
            return new Vector();
        }
    }

    private Object callMethod(String method, Class<?>[] parTypes, Object[] args) throws LauncherException {
        try {
            LOG.fine("launcher.getClass(): " + this.launcher.getClass(), new Object[0]);
            Method m = this.launcher.getClass().getMethod(method, parTypes);
            LOG.fine("Method to call: " + m.getName(), new Object[0]);
            for (int i = 0; i < args.length; ++i) {
                if (args[i] != null) {
                    LOG.fine("argument: " + args[i].toString(), new Object[0]);
                    continue;
                }
                LOG.fine("null as argument", new Object[0]);
            }
            Object o = m.invoke(this.launcher, args);
            return o;
        }
        catch (IllegalAccessException e) {
            throw new LauncherException("Unable to access class when calling method " + method, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new LauncherException("Failed method access when calling method " + method, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new LauncherException("Failed to invoke method " + method, e.getTargetException());
        }
    }

    @Override
    public File getAndChmodFile(File cacheDirectory, URL wantedFile) throws LauncherException {
        File targetFile = null;
        try {
            Class[] parTypes = new Class[]{File.class, URL.class};
            Object[] argList = new Object[]{cacheDirectory, wantedFile};
            targetFile = (File)this.callMethod("getAndChmodFile", parTypes, argList);
        }
        catch (LauncherException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                LOG.warning(e.getMessage(), new Object[0]);
            }
            LOG.severe(e.getMessage(), new Object[0]);
        }
        return targetFile;
    }

    @Override
    public boolean chmodFile(File fileToChmod) {
        try {
            Class[] parTypes = new Class[]{File.class};
            Object[] argList = new Object[]{fileToChmod};
            Boolean result = (Boolean)this.callMethod("chmodFile", parTypes, argList);
            return result;
        }
        catch (LauncherException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                LOG.warning(e.getMessage(), new Object[0]);
            } else {
                LOG.severe(e.getMessage(), new Object[0]);
            }
            return false;
        }
    }

    @Override
    public void addObserver(Observer observer) {
        try {
            Class[] parTypes = new Class[]{Observer.class};
            Object[] argList = new Object[]{observer};
            this.callMethod("addObserver", parTypes, argList);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
        }
    }

    @Override
    public void removeObserver(Observer observer) {
        try {
            Class[] parTypes = new Class[]{Observer.class};
            Object[] argList = new Object[]{observer};
            this.callMethod("removeObserver", parTypes, argList);
        }
        catch (LauncherException e) {
            LOG.severe(e.getMessage(), new Object[0]);
        }
    }
}

